/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenTimer;
import org.apache.hadoop.hdfs.web.oauth2.OAuth2Constants;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.util.JsonSerialization;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class CredentialBasedAccessTokenProvider
extends AccessTokenProvider {
    public static final String OAUTH_CREDENTIAL_KEY = "dfs.webhdfs.oauth2.credential";
    private AccessTokenTimer timer;
    private String clientId;
    private String refreshURL;
    private String accessToken;
    private boolean initialCredentialObtained = false;

    CredentialBasedAccessTokenProvider() {
        this.timer = new AccessTokenTimer();
    }

    CredentialBasedAccessTokenProvider(Timer timer) {
        this.timer = new AccessTokenTimer(timer);
    }

    public abstract String getCredential();

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.clientId = Utils.notNull(conf, "dfs.webhdfs.oauth2.client.id");
        this.refreshURL = Utils.notNull(conf, "dfs.webhdfs.oauth2.refresh.url");
    }

    @Override
    public synchronized String getAccessToken() throws IOException {
        if (this.timer.shouldRefresh() || !this.initialCredentialObtained) {
            this.refresh();
            this.initialCredentialObtained = true;
        }
        return this.accessToken;
    }

    void refresh() throws IOException {
        try {
            OkHttpClient client = new OkHttpClient();
            client.setConnectTimeout(60000L, TimeUnit.MILLISECONDS);
            client.setReadTimeout(60000L, TimeUnit.MILLISECONDS);
            String bodyString = Utils.postBody("client_secret", this.getCredential(), "grant_type", "client_credentials", "client_id", this.clientId);
            RequestBody body = RequestBody.create(OAuth2Constants.URLENCODED, bodyString);
            Request request = new Request.Builder().url(this.refreshURL).post(body).build();
            Response responseBody = client.newCall(request).execute();
            if (responseBody.code() != 200) {
                throw new IllegalArgumentException("Received invalid http response: " + responseBody.code() + ", text = " + responseBody.toString());
            }
            Map response = (Map)JsonSerialization.mapReader().readValue(responseBody.body().string());
            String newExpiresIn = response.get("expires_in").toString();
            this.timer.setExpiresIn(newExpiresIn);
            this.accessToken = response.get("access_token").toString();
        }
        catch (Exception e2) {
            throw new IOException("Unable to obtain access token from credential", e2);
        }
    }
}

