/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.IOUtil;

public class Streams {
    public static BufferedInputStream bufferedInputStream(InputStream is) {
        return is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is, 65536);
    }

    public static BufferedOutputStream bufferedOutputStream(OutputStream os) {
        return os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os, 65536);
    }

    public static byte[] cacheBuffer() {
        return new byte[8192];
    }

    public static InputStream fileInputStream(File file) throws IOException {
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    public static InputStream fileInputStream(File file, String operation) throws ArchiverException {
        try {
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new ArchiverException("Problem reading input file for " + operation + " " + file.getParent() + ", " + e2.getMessage());
        }
    }

    public static OutputStream fileOutputStream(File file) throws IOException {
        return Files.newOutputStream(file.toPath(), new OpenOption[0]);
    }

    public static OutputStream fileOutputStream(File file, String operation) throws ArchiverException {
        try {
            return Files.newOutputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new ArchiverException("Problem creating output file for " + operation + " " + file.getParent() + ", " + e2.getMessage());
        }
    }

    public static void copyFully(@WillClose InputStream zIn, @WillClose OutputStream out, String gzip) throws ArchiverException {
        try {
            Streams.copyFullyDontCloseOutput(zIn, out, gzip);
            out.close();
            out = null;
        }
        catch (IOException e2) {
            throw new ArchiverException("Failure copying.", e2);
        }
        finally {
            IOUtil.close(out);
        }
    }

    public static void copyFullyDontCloseOutput(@WillClose InputStream zIn, @WillNotClose OutputStream out, String gzip) throws ArchiverException {
        try {
            byte[] buffer = Streams.cacheBuffer();
            int count = 0;
            do {
                try {
                    out.write(buffer, 0, count);
                }
                catch (IOException e2) {
                    throw new ArchiverException("Problem writing to output in " + gzip + " operation " + e2.getMessage());
                }
            } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
            zIn.close();
            zIn = null;
        }
        catch (IOException e3) {
            throw new ArchiverException("Problem reading from source file in " + gzip + " operation " + e3.getMessage());
        }
        finally {
            IOUtil.close(zIn);
        }
    }
}

