/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.launch.BundlePlan;
import org.eclipse.sisu.launch.SisuBundlePlan;
import org.eclipse.sisu.launch.SisuExtender;
import org.eclipse.sisu.launch.SisuExtensions;
import org.eclipse.sisu.space.BundleClassSpace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.BundleTracker;

public class SisuTracker
extends BundleTracker<Object>
implements BundlePlan {
    private static final Object PLACEHOLDER;
    private static final Set<String> SUPPORT_BUNDLE_NAMES;
    private static final Map<Long, Object> bundlePublishers;
    protected final int stateMask;
    protected final MutableBeanLocator locator;
    protected final List<BundlePlan> plans;

    static {
        Class[] supportTypes;
        PLACEHOLDER = new Object();
        SUPPORT_BUNDLE_NAMES = new HashSet<String>();
        Class[] classArray = supportTypes = new Class[]{Inject.class, Guice.class, SisuExtender.class};
        int n2 = supportTypes.length;
        int n3 = 0;
        while (n3 < n2) {
            Class type = classArray[n3];
            SUPPORT_BUNDLE_NAMES.add(FrameworkUtil.getBundle((Class)type).getSymbolicName());
            ++n3;
        }
        bundlePublishers = Collections.synchronizedMap(Weak.values());
    }

    public SisuTracker(BundleContext context, int stateMask, MutableBeanLocator locator) {
        super(context, stateMask, null);
        this.stateMask = stateMask;
        this.locator = locator;
        this.plans = this.discoverPlans();
    }

    public final void open() {
        super.open();
        this.purgeBundles();
    }

    public final Object addingBundle(Bundle bundle, BundleEvent event) {
        Long bundleId = bundle.getBundleId();
        if (!bundlePublishers.containsKey(bundleId)) {
            bundlePublishers.put(bundleId, PLACEHOLDER);
            BindingPublisher publisher = this.prepare(bundle);
            if (publisher != null) {
                this.addPublisher(bundleId, publisher);
            } else {
                bundlePublishers.remove(bundleId);
            }
        }
        return bundle;
    }

    public final void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (this.evictBundle(bundle)) {
            this.removePublisher(bundle.getBundleId());
        }
    }

    public final void purgeBundles() {
        for (long bundleId : new ArrayList<Long>(bundlePublishers.keySet())) {
            Bundle bundle = this.context.getBundle(bundleId);
            if (bundle != null && !this.evictBundle(bundle)) continue;
            this.removePublisher(bundleId);
        }
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        if (SUPPORT_BUNDLE_NAMES.contains(bundle.getSymbolicName())) {
            return null;
        }
        if (bundle.getHeaders().get("Fragment-Host") != null) {
            return null;
        }
        BindingPublisher publisher = null;
        int i2 = this.plans.size() - 1;
        while (i2 >= 0 && publisher == null) {
            publisher = this.plans.get(i2).prepare(bundle);
            --i2;
        }
        return publisher;
    }

    protected List<BundlePlan> discoverPlans() {
        ArrayList<BundlePlan> localPlans = new ArrayList<BundlePlan>();
        localPlans.add(new SisuBundlePlan(this.locator));
        SisuExtensions extensions = SisuExtensions.local(new BundleClassSpace(this.context.getBundle()));
        localPlans.addAll(extensions.create(BundlePlan.class, MutableBeanLocator.class, this.locator));
        return localPlans;
    }

    protected boolean evictBundle(Bundle bundle) {
        return (bundle.getState() & this.stateMask) == 0;
    }

    private void addPublisher(Long bundleId, BindingPublisher publisher) {
        if (this.locator.add(publisher)) {
            bundlePublishers.put(bundleId, publisher);
        } else if (publisher instanceof InjectorBindings) {
            bundlePublishers.put(bundleId, ((InjectorBindings)publisher).getInjector());
        }
    }

    private void removePublisher(Long bundleId) {
        Object publisher = bundlePublishers.remove(bundleId);
        if (publisher instanceof BindingPublisher) {
            this.locator.remove((BindingPublisher)publisher);
        } else if (publisher instanceof Injector) {
            this.locator.remove(new InjectorBindings((Injector)publisher, null));
        }
    }
}

