/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.sisu.bean.BeanListener;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.plexus.PlexusBeanBinder;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBeanSource;

public final class PlexusBindingModule
implements Module {
    private final BeanManager manager;
    private final PlexusBeanModule[] modules;

    public PlexusBindingModule(BeanManager manager, PlexusBeanModule ... modules) {
        this.manager = manager;
        this.modules = (PlexusBeanModule[])modules.clone();
    }

    public PlexusBindingModule(BeanManager manager, Collection<? extends PlexusBeanModule> modules) {
        this.manager = manager;
        this.modules = modules.toArray(new PlexusBeanModule[modules.size()]);
    }

    @Override
    public void configure(Binder binder) {
        ArrayList<PlexusBeanSource> sources = new ArrayList<PlexusBeanSource>(this.modules.length);
        PlexusBeanModule[] plexusBeanModuleArray = this.modules;
        int n2 = this.modules.length;
        int n3 = 0;
        while (n3 < n2) {
            PlexusBeanModule module = plexusBeanModuleArray[n3];
            PlexusBeanSource source = module.configure(binder);
            if (source != null) {
                sources.add(source);
            }
            ++n3;
        }
        PlexusBeanBinder plexusBinder = new PlexusBeanBinder(this.manager, sources);
        binder.bindListener(Matchers.any(), new BeanListener(plexusBinder));
        if (this.manager instanceof Module) {
            ((Module)((Object)this.manager)).configure(binder);
        }
    }
}

