/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public final class DatabaseScripts {
    private DatabaseScripts() {
    }

    public static List<String> getSchemaSQL(File fileObject) throws IOException {
        Properties scriptProperties = new Properties();
        FileInputStream scriptInputStream = new FileInputStream(fileObject.getPath());
        try {
            scriptProperties.load(scriptInputStream);
        }
        finally {
            IOUtils.closeQuietly(scriptInputStream);
        }
        String scriptLocation = scriptProperties.getProperty("jahia.database.schemascriptdir");
        File parentFile = fileObject.getParentFile();
        File schemaDir = new File(parentFile, scriptLocation);
        List<String> result = DatabaseScripts.getSQLStatementsInDir(schemaDir, ".sql");
        return result;
    }

    public static List<String> getSQLStatementsInDir(File sqlDir, final String extension) throws IOException {
        List<String> curFileSQL;
        int i2;
        ArrayList<String> result = new ArrayList<String>();
        Object[] schemaFiles = sqlDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (extension != null) {
                    return name.toLowerCase().endsWith(extension);
                }
                return true;
            }
        });
        if (schemaFiles == null) {
            return result;
        }
        Arrays.sort(schemaFiles);
        ArrayList<Object> indexFiles = new ArrayList<Object>();
        for (i2 = 0; i2 < schemaFiles.length; ++i2) {
            Object sqlFile = schemaFiles[i2];
            if (((File)sqlFile).getName().endsWith("index.sql")) {
                indexFiles.add(sqlFile);
                continue;
            }
            System.out.println("Loading statements from script file " + (File)sqlFile);
            curFileSQL = DatabaseScripts.getScriptFileStatements((File)sqlFile);
            result.addAll(curFileSQL);
        }
        for (i2 = 0; i2 < indexFiles.size(); ++i2) {
            File indexFile = (File)indexFiles.get(i2);
            System.out.println("Loading statements from index script file " + indexFile);
            curFileSQL = DatabaseScripts.getScriptFileStatements(indexFile);
            result.addAll(curFileSQL);
        }
        return result;
    }

    private static List<String> getScriptFileStatements(File fileObject) throws IOException {
        return org.jahia.commons.DatabaseScripts.getScriptStatements(new FileReader(fileObject));
    }
}

