/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class StringLengthFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 0) {
            return StringLengthFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (args.size() == 1) {
            return StringLengthFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string-length() requires one argument.");
    }

    public static Double evaluate(Object obj, Navigator nav) throws FunctionCallException {
        String str = StringFunction.evaluate(obj, nav);
        char[] data = str.toCharArray();
        int length = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            char c2 = data[i2];
            ++length;
            if (c2 < '\ud800' || c2 > '\udfff') continue;
            try {
                char low = data[i2 + 1];
                if (low < '\udc00' || low > '\udfff') {
                    throw new FunctionCallException("Bad surrogate pair in string " + str);
                }
                ++i2;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new FunctionCallException("Bad surrogate pair in string " + str);
            }
        }
        return new Double(length);
    }
}

