/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.codec.LocalDateTimeCodec;
import org.mariadb.jdbc.plugin.codec.TimeCodec;

public class TimestampColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public TimestampColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected TimestampColumn(TimestampColumn prev) {
        super(prev, true);
    }

    @Override
    public TimestampColumn useAliasAsName() {
        return new TimestampColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Timestamp.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 93;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return this.dataType.name();
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeTimestampText(buf, length, null);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeTimestampBinary(buf, length, null);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (length.get() == 0) {
            StringBuilder zeroValue = new StringBuilder("0000-00-00 00:00:00");
            if (this.getDecimals() > 0) {
                zeroValue.append(".");
                for (int i2 = 0; i2 < this.getDecimals(); ++i2) {
                    zeroValue.append("0");
                }
            }
            return zeroValue.toString();
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte day = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && day == 0) {
            return "0000-00-00 00:00:00";
        }
        LocalDateTime dateTime = LocalDateTime.of(year, month, (int)day, (int)hour, (int)minutes, (int)seconds).plusNanos(microseconds * 1000L);
        StringBuilder microSecPattern = new StringBuilder();
        if (this.getDecimals() > 0 || microseconds > 0L) {
            int decimal = this.getDecimals() & 0xFF;
            if (decimal == 0) {
                decimal = 6;
            }
            microSecPattern.append(".");
            for (int i3 = 0; i3 < decimal; ++i3) {
                microSecPattern.append("S");
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss" + microSecPattern);
        return dateTime.toLocalDate().toString() + ' ' + dateTime.toLocalTime().format(formatter);
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        Timestamp timestamp;
        Calendar c2;
        int begin;
        int pos = buf.pos();
        int nanoBegin = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        int partIdx = 0;
        for (begin = 0; begin < length.get(); ++begin) {
            byte b2 = buf.readByte();
            if (b2 == 45 || b2 == 32 || b2 == 58) {
                ++partIdx;
                continue;
            }
            if (b2 == 46) {
                ++partIdx;
                nanoBegin = begin;
                continue;
            }
            if (b2 < 48 || b2 > 57) {
                buf.pos(pos);
                throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{buf.readString(length.get()), this.dataType}));
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b2 - 48;
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0 && timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
            length.set(-1);
            return null;
        }
        if (nanoBegin > 0) {
            for (begin = 0; begin < 6 - (length.get() - nanoBegin - 1); ++begin) {
                timestampsPart[6] = timestampsPart[6] * 10;
            }
        }
        if (cal == null) {
            c2 = Calendar.getInstance();
            c2.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
            timestamp = new Timestamp(c2.getTime().getTime());
            timestamp.setNanos(timestampsPart[6] * 1000);
        } else {
            c2 = cal;
            synchronized (c2) {
                cal.clear();
                cal.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
                timestamp = new Timestamp(cal.getTime().getTime());
                timestamp.setNanos(timestampsPart[6] * 1000);
            }
        }
        String st = timestamp.toString();
        return Date.valueOf(st.substring(0, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        Calendar cal;
        if (length.get() == 0) {
            length.set(-1);
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0 && microseconds == 0L) {
            length.set(-1);
            return null;
        }
        if (calParam == null) {
            cal = Calendar.getInstance();
            cal.clear();
            cal.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
            timestamp = new Timestamp(cal.getTimeInMillis());
        } else {
            cal = calParam;
            synchronized (cal) {
                calParam.clear();
                calParam.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
                timestamp = new Timestamp(calParam.getTimeInMillis());
            }
        }
        timestamp.setNanos((int)(microseconds * 1000L));
        String st = timestamp.toString();
        return Date.valueOf(st.substring(0, 10));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        LocalDateTime lt = LocalDateTimeCodec.INSTANCE.decodeText(buf, length, this, cal);
        if (lt == null) {
            return null;
        }
        Calendar cc = cal == null ? Calendar.getInstance() : cal;
        ZonedDateTime d2 = TimeCodec.EPOCH_DATE.atTime(lt.toLocalTime()).atZone(cc.getTimeZone().toZoneId());
        return new Time(d2.toEpochSecond() * 1000L + (long)(d2.getNano() / 1000000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        if (length.get() == 0) {
            length.set(-1);
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0) {
            length.set(-1);
            return null;
        }
        if (calParam == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(1970, 0, 1, hour, minutes, seconds);
            return new Time(cal.getTimeInMillis() + microseconds / 1000L);
        }
        Calendar calendar = calParam;
        synchronized (calendar) {
            calParam.clear();
            calParam.set(1970, 0, 1, hour, minutes, seconds);
            return new Time(calParam.getTimeInMillis() + microseconds / 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        int begin;
        int pos = buf.pos();
        int nanoBegin = -1;
        int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
        int partIdx = 0;
        for (begin = 0; begin < length.get(); ++begin) {
            byte b2 = buf.readByte();
            if (b2 == 45 || b2 == 32 || b2 == 58) {
                ++partIdx;
                continue;
            }
            if (b2 == 46) {
                ++partIdx;
                nanoBegin = begin;
                continue;
            }
            if (b2 < 48 || b2 > 57) {
                buf.pos(pos);
                throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{buf.readString(length.get()), this.dataType}));
            }
            timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b2 - 48;
        }
        if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0 && timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
            length.set(-1);
            return null;
        }
        if (nanoBegin > 0) {
            for (begin = 0; begin < 6 - (length.get() - nanoBegin - 1); ++begin) {
                timestampsPart[6] = timestampsPart[6] * 10;
            }
        }
        if (calParam == null) {
            Calendar c2 = Calendar.getInstance();
            c2.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
            timestamp = new Timestamp(c2.getTime().getTime());
            timestamp.setNanos(timestampsPart[6] * 1000);
        } else {
            Calendar calendar = calParam;
            synchronized (calendar) {
                calParam.clear();
                calParam.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
                timestamp = new Timestamp(calParam.getTime().getTime());
                timestamp.setNanos(timestampsPart[6] * 1000);
            }
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        if (length.get() == 0) {
            length.set(-1);
            return null;
        }
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        byte dayOfMonth = buf.readByte();
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        long microseconds = 0L;
        if (length.get() > 4) {
            hour = buf.readByte();
            minutes = buf.readByte();
            seconds = buf.readByte();
            if (length.get() > 7) {
                microseconds = buf.readUnsignedInt();
            }
        }
        if (year == 0 && month == 0 && dayOfMonth == 0 && hour == 0 && minutes == 0 && seconds == 0 && microseconds == 0L) {
            length.set(-1);
            return null;
        }
        if (calParam == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
            timestamp = new Timestamp(cal.getTimeInMillis());
        } else {
            Calendar calendar = calParam;
            synchronized (calendar) {
                calParam.clear();
                calParam.set(year, month - 1, dayOfMonth, hour, minutes, seconds);
                timestamp = new Timestamp(calParam.getTimeInMillis());
            }
        }
        timestamp.setNanos((int)(microseconds * 1000L));
        return timestamp;
    }
}

