/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.impl;

import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.client.ReadableByteBuf;

public final class StandardReadableByteBuf
implements ReadableByteBuf {
    public byte[] buf;
    public int pos = 0;
    private int limit;

    public StandardReadableByteBuf(byte[] buf, int limit) {
        this.buf = buf;
        this.limit = limit;
    }

    public StandardReadableByteBuf(byte[] buf) {
        this.buf = buf;
        this.limit = buf.length;
    }

    @Override
    public int readableBytes() {
        return this.limit - this.pos;
    }

    @Override
    public int pos() {
        return this.pos;
    }

    @Override
    public byte[] buf() {
        return this.buf;
    }

    @Override
    public void buf(byte[] buf, int limit, int pos) {
        this.buf = buf;
        this.limit = limit;
        this.pos = pos;
    }

    @Override
    public void pos(int pos) {
        this.pos = pos;
    }

    @Override
    public void skip() {
        ++this.pos;
    }

    @Override
    public void skip(int length) {
        this.pos += length;
    }

    @Override
    public void skipLengthEncoded() {
        byte len = this.buf[this.pos++];
        switch (len) {
            case -5: {
                return;
            }
            case -4: {
                this.skip(this.readUnsignedShort());
                return;
            }
            case -3: {
                this.skip(this.readUnsignedMedium());
                return;
            }
            case -2: {
                this.skip((int)(4L + this.readUnsignedInt()));
                return;
            }
        }
        this.pos += len & 0xFF;
    }

    @Override
    public MariaDbBlob readBlob(int length) {
        this.pos += length;
        return MariaDbBlob.safeMariaDbBlob(this.buf, this.pos - length, length);
    }

    @Override
    public long atoll(int length) {
        boolean negate = false;
        int idx = 0;
        long result = 0L;
        if (length > 0 && this.buf[this.pos] == 45) {
            negate = true;
            ++this.pos;
        }
        while (true) {
            int n2 = ++idx;
            ++idx;
            if (n2 >= length) break;
            result = result * 10L + (long)this.buf[this.pos++] - 48L;
        }
        return negate ? -1L * result : result;
    }

    @Override
    public long atoull(int length) {
        long result = 0L;
        for (int idx = 0; idx < length; ++idx) {
            result = result * 10L + (long)this.buf[this.pos++] - 48L;
        }
        return result;
    }

    @Override
    public byte getByte() {
        return this.buf[this.pos];
    }

    @Override
    public byte getByte(int index) {
        return this.buf[index];
    }

    @Override
    public short getUnsignedByte() {
        return (short)(this.buf[this.pos] & 0xFF);
    }

    @Override
    public long readLongLengthEncodedNotNull() {
        int type;
        if ((type = this.buf[this.pos++] & 0xFF) < 251) {
            return type;
        }
        switch (type) {
            case 252: {
                return this.readUnsignedShort();
            }
            case 253: {
                return this.readUnsignedMedium();
            }
        }
        return this.readLong();
    }

    @Override
    public int readIntLengthEncodedNotNull() {
        int type;
        if ((type = this.buf[this.pos++] & 0xFF) < 251) {
            return type;
        }
        switch (type) {
            case 252: {
                return this.readUnsignedShort();
            }
            case 253: {
                return this.readUnsignedMedium();
            }
            case 254: {
                return (int)this.readLong();
            }
        }
        return type;
    }

    @Override
    public int skipIdentifier() {
        int len = this.readIntLengthEncodedNotNull();
        this.pos += len;
        return this.pos;
    }

    @Override
    public Integer readLength() {
        short type = this.readUnsignedByte();
        switch (type) {
            case 251: {
                return null;
            }
            case 252: {
                return this.readUnsignedShort();
            }
            case 253: {
                return this.readUnsignedMedium();
            }
            case 254: {
                return (int)this.readLong();
            }
        }
        return type;
    }

    @Override
    public byte readByte() {
        return this.buf[this.pos++];
    }

    @Override
    public short readUnsignedByte() {
        return (short)(this.buf[this.pos++] & 0xFF);
    }

    @Override
    public short readShort() {
        return (short)((this.buf[this.pos++] & 0xFF) + (this.buf[this.pos++] << 8));
    }

    @Override
    public int readUnsignedShort() {
        return (this.buf[this.pos++] & 0xFF) + (this.buf[this.pos++] << 8) & 0xFFFF;
    }

    @Override
    public int readMedium() {
        int value = this.readUnsignedMedium();
        if ((value & 0x800000) != 0) {
            value |= 0xFF000000;
        }
        return value;
    }

    @Override
    public int readUnsignedMedium() {
        return (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16);
    }

    @Override
    public int readInt() {
        return (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16) + ((this.buf[this.pos++] & 0xFF) << 24);
    }

    @Override
    public int readIntBE() {
        return ((this.buf[this.pos++] & 0xFF) << 24) + ((this.buf[this.pos++] & 0xFF) << 16) + ((this.buf[this.pos++] & 0xFF) << 8) + (this.buf[this.pos++] & 0xFF);
    }

    @Override
    public long readUnsignedInt() {
        return (long)((this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16)) + ((long)(this.buf[this.pos++] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        return ((long)this.buf[this.pos++] & 0xFFL) + (((long)this.buf[this.pos++] & 0xFFL) << 8) + (((long)this.buf[this.pos++] & 0xFFL) << 16) + (((long)this.buf[this.pos++] & 0xFFL) << 24) + (((long)this.buf[this.pos++] & 0xFFL) << 32) + (((long)this.buf[this.pos++] & 0xFFL) << 40) + (((long)this.buf[this.pos++] & 0xFFL) << 48) + (((long)this.buf[this.pos++] & 0xFFL) << 56);
    }

    @Override
    public long readLongBE() {
        return (((long)this.buf[this.pos++] & 0xFFL) << 56) + (((long)this.buf[this.pos++] & 0xFFL) << 48) + (((long)this.buf[this.pos++] & 0xFFL) << 40) + (((long)this.buf[this.pos++] & 0xFFL) << 32) + (((long)this.buf[this.pos++] & 0xFFL) << 24) + (((long)this.buf[this.pos++] & 0xFFL) << 16) + (((long)this.buf[this.pos++] & 0xFFL) << 8) + ((long)this.buf[this.pos++] & 0xFFL);
    }

    @Override
    public void readBytes(byte[] dst) {
        System.arraycopy(this.buf, this.pos, dst, 0, dst.length);
        this.pos += dst.length;
    }

    @Override
    public byte[] readBytesNullEnd() {
        int initialPosition = this.pos;
        int cnt = 0;
        while (this.readableBytes() > 0 && this.buf[this.pos++] != 0) {
            ++cnt;
        }
        byte[] dst = new byte[cnt];
        System.arraycopy(this.buf, initialPosition, dst, 0, dst.length);
        return dst;
    }

    @Override
    public StandardReadableByteBuf readLengthBuffer() {
        int len = this.readIntLengthEncodedNotNull();
        StandardReadableByteBuf b2 = new StandardReadableByteBuf(this.buf, this.pos + len);
        b2.pos = this.pos;
        this.pos += len;
        return b2;
    }

    @Override
    public String readString(int length) {
        this.pos += length;
        return new String(this.buf, this.pos - length, length, StandardCharsets.UTF_8);
    }

    @Override
    public String readAscii(int length) {
        this.pos += length;
        return new String(this.buf, this.pos - length, length, StandardCharsets.US_ASCII);
    }

    @Override
    public String readStringNullEnd() {
        int initialPosition = this.pos;
        int cnt = 0;
        while (this.readableBytes() > 0 && this.buf[this.pos++] != 0) {
            ++cnt;
        }
        return new String(this.buf, initialPosition, cnt, StandardCharsets.UTF_8);
    }

    @Override
    public String readStringEof() {
        int initialPosition = this.pos;
        this.pos = this.limit;
        return new String(this.buf, initialPosition, this.pos - initialPosition, StandardCharsets.UTF_8);
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public double readDoubleBE() {
        return Double.longBitsToDouble(this.readLongBE());
    }
}

