/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication.standard;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.message.server.AuthSwitchPacket;
import org.mariadb.jdbc.plugin.AuthenticationPlugin;

public class NativePasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "mysql_native_password";
    private String authenticationData;
    private byte[] seed;

    public static byte[] encryptPassword(CharSequence password, byte[] seed) {
        try {
            if (password == null) {
                return new byte[0];
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] bytePwd = password.toString().getBytes(StandardCharsets.UTF_8);
            byte[] stage1 = messageDigest.digest(bytePwd);
            messageDigest.reset();
            byte[] stage2 = messageDigest.digest(stage1);
            messageDigest.reset();
            messageDigest.update(seed);
            messageDigest.update(stage2);
            byte[] digest = messageDigest.digest();
            byte[] returnBytes = new byte[digest.length];
            for (int i2 = 0; i2 < digest.length; ++i2) {
                returnBytes[i2] = (byte)(stage1[i2] ^ digest[i2]);
            }
            return returnBytes;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException("Could not use SHA-1, failing", e2);
        }
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Configuration conf) {
        this.seed = seed;
        this.authenticationData = authenticationData;
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context) throws IOException {
        if (this.authenticationData == null) {
            out.writeEmptyPacket();
        } else {
            byte[] truncatedSeed = AuthSwitchPacket.getTruncatedSeed(this.seed);
            out.writeBytes(NativePasswordPlugin.encryptPassword(this.authenticationData, truncatedSeed));
            out.flush();
        }
        return in.readReusablePacket();
    }
}

