/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.util.BitSet;
import java.util.Calendar;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.plugin.Codec;

public class BitSetCodec
implements Codec<BitSet> {
    public static final BitSetCodec INSTANCE = new BitSetCodec();

    public static BitSet parseBit(ReadableByteBuf buf, MutableInt length) {
        byte[] arr = new byte[length.get()];
        buf.readBytes(arr);
        BitSetCodec.revertOrder(arr);
        return BitSet.valueOf(arr);
    }

    public static void revertOrder(byte[] array) {
        int i2 = 0;
        for (int j2 = array.length - 1; j2 > i2; --j2, ++i2) {
            byte tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = tmp;
        }
    }

    @Override
    public String className() {
        return BitSet.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.BIT && type.isAssignableFrom(BitSet.class);
    }

    @Override
    public BitSet decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public BitSet decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BitSet;
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long length) throws IOException {
        byte[] bytes = ((BitSet)value).toByteArray();
        BitSetCodec.revertOrder(bytes);
        StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
        sb.append("b'");
        for (int i2 = 0; i2 < 8 * bytes.length; ++i2) {
            sb.append((bytes[i2 / 8] << i2 % 8 & 0x80) == 0 ? (char)'0' : '1');
        }
        sb.append("'");
        encoder.writeAscii(sb.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        byte[] bytes = ((BitSet)value).toByteArray();
        BitSetCodec.revertOrder(bytes);
        encoder.writeLength(bytes.length);
        encoder.writeBytes(bytes);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

