/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.plugin.Codec;

public class StringCodec
implements Codec<String> {
    public static final StringCodec INSTANCE = new StringCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.BIT, new DataType[]{DataType.OLDDECIMAL, DataType.TINYINT, DataType.SMALLINT, DataType.INTEGER, DataType.FLOAT, DataType.DOUBLE, DataType.TIMESTAMP, DataType.BIGINT, DataType.MEDIUMINT, DataType.DATE, DataType.TIME, DataType.DATETIME, DataType.YEAR, DataType.NEWDATE, DataType.JSON, DataType.DECIMAL, DataType.ENUM, DataType.SET, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return String.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(String.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof String;
    }

    @Override
    public String decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeStringText(buf, length, cal);
    }

    @Override
    public String decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeStringBinary(buf, length, cal);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeByte(39);
        encoder.writeStringEscaped(maxLen == null ? value.toString() : value.toString().substring(0, maxLen.intValue()), (context.getServerStatus() & 0x200) != 0);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer writer, Object value, Calendar cal, Long maxLength) throws IOException {
        byte[] b2 = value.toString().getBytes(StandardCharsets.UTF_8);
        int len = maxLength != null ? Math.min(maxLength.intValue(), b2.length) : b2.length;
        writer.writeLength(len);
        writer.writeBytes(b2, 0, len);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARSTRING.get();
    }
}

