/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.WindowsAccount;

public class WindowsPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String fqn;
    private final byte[] sid;
    private final String sidString;
    private final List<String> roles;
    private transient IWindowsIdentity identity;
    private final Map<String, WindowsAccount> groups;

    public WindowsPrincipal(IWindowsIdentity windowsIdentity) {
        this(windowsIdentity, PrincipalFormat.FQN, PrincipalFormat.FQN);
    }

    public WindowsPrincipal(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat, PrincipalFormat roleFormat) {
        this.identity = windowsIdentity;
        this.fqn = windowsIdentity.getFqn();
        this.sid = windowsIdentity.getSid();
        this.sidString = windowsIdentity.getSidString();
        this.groups = WindowsPrincipal.getGroups(windowsIdentity.getGroups());
        this.roles = WindowsPrincipal.getRoles(windowsIdentity, principalFormat, roleFormat);
    }

    private static List<String> getRoles(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat, PrincipalFormat roleFormat) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(WindowsPrincipal.getPrincipalNames(windowsIdentity, principalFormat));
        for (IWindowsAccount group : windowsIdentity.getGroups()) {
            roles.addAll(WindowsPrincipal.getRoleNames(group, roleFormat));
        }
        return roles;
    }

    private static Map<String, WindowsAccount> getGroups(IWindowsAccount[] groups) {
        HashMap<String, WindowsAccount> groupMap = new HashMap<String, WindowsAccount>();
        for (IWindowsAccount group : groups) {
            groupMap.put(group.getFqn(), new WindowsAccount(group));
        }
        return groupMap;
    }

    public byte[] getSid() {
        return (byte[])this.sid.clone();
    }

    public String getSidString() {
        return this.sidString;
    }

    public Map<String, WindowsAccount> getGroups() {
        return this.groups;
    }

    private static List<String> getRoleNames(IWindowsAccount group, PrincipalFormat principalFormat) {
        ArrayList<String> principals = new ArrayList<String>();
        switch (principalFormat) {
            case FQN: {
                principals.add(group.getFqn());
                break;
            }
            case SID: {
                principals.add(group.getSidString());
                break;
            }
            case BOTH: {
                principals.add(group.getFqn());
                principals.add(group.getSidString());
                break;
            }
        }
        return principals;
    }

    private static List<String> getPrincipalNames(IWindowsIdentity windowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<String> principals = new ArrayList<String>();
        switch (principalFormat) {
            case FQN: {
                principals.add(windowsIdentity.getFqn());
                break;
            }
            case SID: {
                principals.add(windowsIdentity.getSidString());
                break;
            }
            case BOTH: {
                principals.add(windowsIdentity.getFqn());
                principals.add(windowsIdentity.getSidString());
                break;
            }
        }
        return principals;
    }

    public String getRolesString() {
        return String.join((CharSequence)", ", this.roles);
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    @Override
    public String getName() {
        return this.fqn;
    }

    public IWindowsIdentity getIdentity() {
        return this.identity;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof WindowsPrincipal) {
            return this.getName().equals(((WindowsPrincipal)o2).getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }
}

