/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CVarcharAccessor
extends VarcharAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    static final int MAX_CALL_LENGTH_PRE102 = 4001;
    static final int MIN_SQL_LENGTH = 32;
    boolean underlyingLong = false;
    private T4CMarshaller marshaller = null;
    static final int NONE = -1;
    static final int DAY = 1;
    static final int MM_MONTH = 2;
    static final int FULL_MONTH = 3;
    static final int MON_MONTH = 4;
    static final int YY_YEAR = 5;
    static final int RR_YEAR = 6;
    static final int HH_HOUR = 7;
    static final int HH24_HOUR = 8;
    static final int MINUTE = 9;
    static final int SECOND = 10;
    static final int NSECOND = 11;
    static final int AM = 12;
    static final int TZR = 13;
    static final int TZH = 14;
    static final int TZM = 15;

    T4CVarcharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, isOutBind, false);
        this.mare = _mare;
        this.calculateSizeTmpByteArray();
    }

    T4CVarcharAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int maxCodePointLen, int _oacmxl, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, maxCodePointLen);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
        this.calculateSizeTmpByteArray();
        this.oacmxl = _oacmxl;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    @Override
    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && (this.describeType == 112 || this.describeType == 127) || this.internalType == 23 && this.describeType == 113 || this.internalType == 112 && this.describeType == 127) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                if (!this.lastCopyRowIsNull) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(this.lastCopyRowOffset, this.lastCopyRowLength);
                    this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
                }
            } else {
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.lastCopyRow = -1;
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        return this.getMarshaller().unmarshalOneRow(this);
    }

    int readStreamFromWire(byte[] buffer, int offset, int length, int[] escapeSequenceArr, boolean[] readHeaderArr, boolean[] readAsNonStreamArr, T4CMAREngine mare, T4CTTIoer11 oer) throws SQLException, IOException {
        return this.getMarshaller().readStreamFromWire(buffer, offset, length, escapeSequenceArr, readHeaderArr, readAsNonStreamArr, mare, oer);
    }

    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        NUMBER result = null;
        if (this.definedColumnType == 0) {
            result = super.getNUMBER(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                return T4CVarcharAccessor.StringToNUMBER(s2.trim());
            }
        }
        return result;
    }

    @Override
    DATE getDATE(int currentRow) throws SQLException {
        DATE result = null;
        if (this.definedColumnType == 0) {
            result = super.getDATE(currentRow);
        } else {
            Date d = this.getDate(currentRow);
            if (d != null) {
                result = new DATE(d);
            }
        }
        return result;
    }

    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMP result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMP(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMP(ts);
            }
        }
        return result;
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        TIMESTAMPTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        TIMESTAMPLTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPLTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPLTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    @Override
    RAW getRAW(int currentRow) throws SQLException {
        RAW result = null;
        if (this.definedColumnType == 0) {
            result = super.getRAW(currentRow);
        } else if (!this.rowNull[currentRow]) {
            result = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars(currentRow)) : new RAW(super.getBytes(currentRow));
        }
        return result;
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(currentRow);
        }
        Datum result = null;
        if (this.rowNull == null) {
            throw (SQLException)DatabaseError.createSqlException(21).fillInStackTrace();
        }
        if (!this.rowNull[currentRow]) {
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(currentRow);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(currentRow);
                }
                case 91: {
                    return this.getDATE(currentRow);
                }
                case 92: {
                    return this.getDATE(currentRow);
                }
                case 93: {
                    return this.getTIMESTAMP(currentRow);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(currentRow);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(currentRow);
                }
                case -8: {
                    return this.getROWID(currentRow);
                }
            }
            throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
        }
        return result;
    }

    @Override
    byte getByte(int currentRow) throws SQLException {
        byte result = 0;
        if (this.definedColumnType == 0) {
            result = super.getByte(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.byteValue();
            }
        }
        return result;
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        int result = 0;
        if (this.definedColumnType == 0) {
            result = super.getInt(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.intValue();
            }
        }
        return result;
    }

    @Override
    short getShort(int currentRow) throws SQLException {
        short result = 0;
        if (this.definedColumnType == 0) {
            result = super.getShort(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.shortValue();
            }
        }
        return result;
    }

    @Override
    long getLong(int currentRow) throws SQLException {
        long result = 0L;
        if (this.definedColumnType == 0) {
            result = super.getLong(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.longValue();
            }
        }
        return result;
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        float result = 0.0f;
        if (this.definedColumnType == 0) {
            result = super.getFloat(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.floatValue();
            }
        }
        return result;
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        double result = 0.0;
        if (this.definedColumnType == 0) {
            result = super.getDouble(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.doubleValue();
            }
        }
        return result;
    }

    @Override
    Date getDate(int currentRow) throws SQLException {
        Date result = null;
        if (this.definedColumnType == 0) {
            result = super.getDate(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                try {
                    result = new Date(T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nanos).getTimeInMillis());
                }
                catch (NumberFormatException ex) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        Timestamp result = null;
        if (this.definedColumnType == 0) {
            result = super.getTimestamp(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                try {
                    Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                    result = new Timestamp(cal.getTimeInMillis());
                    result.setNanos(nanos[0]);
                }
                catch (NumberFormatException ex) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        Time result = null;
        if (this.definedColumnType == 0) {
            result = super.getTime(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                try {
                    Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                    result = new Time(cal.getTimeInMillis());
                }
                catch (NumberFormatException ex) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                }
            }
        }
        return result;
    }

    private final T4CMarshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = this.describeType == 8 ? T4CMarshaller.LONG : T4CMarshaller.VARCHAR;
        }
        return this.marshaller;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        if (this.isUnexpected()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(currentRow);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(currentRow);
            }
            case 4: {
                return this.getInt(currentRow);
            }
            case -6: {
                return this.getByte(currentRow);
            }
            case 5: {
                return this.getShort(currentRow);
            }
            case -7: 
            case 16: {
                return this.getBoolean(currentRow);
            }
            case -5: {
                return this.getLong(currentRow);
            }
            case 7: {
                return Float.valueOf(this.getFloat(currentRow));
            }
            case 6: 
            case 8: {
                return this.getDouble(currentRow);
            }
            case 91: {
                return this.getDate(currentRow);
            }
            case 92: {
                return this.getTime(currentRow);
            }
            case 93: {
                return this.getTimestamp(currentRow);
            }
            case -101: {
                return this.getTIMESTAMPTZ(currentRow);
            }
            case -102: {
                return this.getTIMESTAMPLTZ(currentRow);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytesFromHexChars(currentRow);
            }
            case -8: {
                return this.getROWID(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    static final NUMBER StringToNUMBER(String str) throws SQLException {
        try {
            return new NUMBER(new BigDecimal(str));
        }
        catch (NumberFormatException ex) {
            throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
        }
    }

    static final Calendar DATEStringToCalendar(String value, String fmt, int[] out) throws SQLException {
        char[] fmtChars = (fmt + " ").toCharArray();
        value = value + " ";
        int sLength = Math.min(value.length(), fmtChars.length);
        int state = -1;
        int oldState = -1;
        int index = 0;
        int prevIndex = 0;
        int vsIndex = 0;
        int veIndex = 0;
        int day = 0;
        int month = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nsecond = 0;
        String am = null;
        String tzr = null;
        boolean needToProcessValue = false;
        String[] sMonths = null;
        String[] lMonths = null;
        for (int i = 0; i < sLength; ++i) {
            switch (fmtChars[i]) {
                case 'R': 
                case 'r': {
                    if (state == 6) break;
                    state = 6;
                    index = i;
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (state == 5) break;
                    state = 5;
                    index = i;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (state == 1) break;
                    state = 1;
                    index = i;
                    break;
                }
                case 'M': 
                case 'm': {
                    if (state == 2 && state == 4 && state == 3 && state == 9) break;
                    index = i;
                    if (!(i + 4 >= sLength || fmtChars[i + 1] != 'O' && fmtChars[i + 1] != 'o' || fmtChars[i + 2] != 'N' && fmtChars[i + 2] != 'n' || fmtChars[i + 3] != 'T' && fmtChars[i + 3] != 't' || fmtChars[i + 4] != 'H' && fmtChars[i + 4] != 'h')) {
                        state = 3;
                        i += 4;
                        break;
                    }
                    if (!(i + 2 >= sLength || fmtChars[i + 1] != 'O' && fmtChars[i + 1] != 'o' || fmtChars[i + 2] != 'N' && fmtChars[i + 2] != 'n')) {
                        state = 4;
                        i += 2;
                        break;
                    }
                    if (i + 1 < sLength && (fmtChars[i + 1] == 'M' || fmtChars[i + 1] == 'm')) {
                        state = 2;
                        ++i;
                        break;
                    }
                    if (i + 1 >= sLength || fmtChars[i + 1] != 'I' && fmtChars[i + 1] != 'i') break;
                    state = 9;
                    ++i;
                    break;
                }
                case 'H': 
                case 'h': {
                    if (state != 7) {
                        state = 7;
                        index = i;
                        break;
                    }
                    if (i + 2 >= sLength || fmtChars[i + 1] != '2' && fmtChars[i + 4] != '4') break;
                    state = 8;
                    i += 2;
                    break;
                }
                case 'S': 
                case 's': {
                    if (i + 1 >= sLength || fmtChars[i + 1] != 'S' && fmtChars[i + 1] != 's') break;
                    state = 10;
                    index = i++;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (state == 11) break;
                    state = 11;
                    index = i;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (i + 1 >= sLength || fmtChars[i + 1] != 'M' && fmtChars[i + 1] != 'm') break;
                    state = 12;
                    index = i++;
                    break;
                }
                case 'T': 
                case 't': {
                    if (i + 2 >= sLength || fmtChars[i + 1] != 'Z' && fmtChars[i + 1] != 'z' || fmtChars[i + 2] != 'R' && fmtChars[i + 2] != 'r') break;
                    state = 13;
                    index = i;
                    i += 2;
                    break;
                }
                default: {
                    needToProcessValue = true;
                }
            }
            if (!needToProcessValue || state == -1) continue;
            int length = i - index;
            int skip = index - prevIndex;
            vsIndex = veIndex + skip;
            veIndex = vsIndex + length;
            switch (state) {
                case 1: {
                    day = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 2: {
                    month = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 3: {
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && value.charAt(x) != fmtChars[i]; ++x) {
                    }
                    veIndex = x;
                    String temp = null;
                    if (veIndex == vsIndex) break;
                    temp = value.substring(vsIndex, veIndex);
                    temp = temp.trim();
                    if (lMonths == null) {
                        lMonths = new DateFormatSymbols().getMonths();
                    }
                    for (month = 0; month < lMonths.length && !temp.equalsIgnoreCase(lMonths[month]); ++month) {
                    }
                    if (month < 12) break;
                    throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
                }
                case 4: {
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && value.charAt(x) != fmtChars[i]; ++x) {
                    }
                    veIndex = x;
                    String temp = null;
                    if (veIndex == vsIndex) break;
                    temp = value.substring(vsIndex, veIndex);
                    temp = temp.trim();
                    if (sMonths == null) {
                        sMonths = new DateFormatSymbols().getShortMonths();
                    }
                    for (month = 0; month < sMonths.length && !temp.equalsIgnoreCase(sMonths[month]); ++month) {
                    }
                    if (month < 12) break;
                    throw DatabaseError.createSqlException(59);
                }
                case 5: {
                    year = Integer.parseInt(value.substring(vsIndex, veIndex));
                    if (length != 2) break;
                    year += 2000;
                    break;
                }
                case 6: {
                    year = Integer.parseInt(value.substring(vsIndex, veIndex));
                    if (length == 2 && year < 50) {
                        year += 2000;
                        break;
                    }
                    year += 1900;
                    break;
                }
                case 7: 
                case 8: {
                    veIndex = vsIndex + 2;
                    hour = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 9: {
                    minute = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 10: {
                    second = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 11: {
                    char c;
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && (c = value.charAt(x)) >= '0' && c <= '9'; ++x) {
                    }
                    if ((veIndex += x - vsIndex) == vsIndex) break;
                    nsecond = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 12: {
                    if (veIndex <= 0) break;
                    am = value.substring(vsIndex, veIndex);
                    break;
                }
                case 13: {
                    char c;
                    int x = vsIndex;
                    veIndex = vsIndex;
                    x = vsIndex;
                    while (x < value.length() && ((c = value.charAt(x)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                        veIndex = x++;
                    }
                    if (veIndex == vsIndex) break;
                    tzr = value.substring(vsIndex, veIndex);
                    break;
                }
                default: {
                    System.out.println("\n\n\n             ***** ERROR(1) ****\n");
                }
            }
            prevIndex = i;
            state = -1;
            needToProcessValue = false;
        }
        GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, minute, second);
        if (am != null) {
            cal.set(9, am.equalsIgnoreCase("AM") ? 0 : 1);
        }
        if (tzr != null) {
            // empty if block
        }
        if (nsecond != 0) {
            out[0] = nsecond;
        }
        return cal;
    }

    @Override
    int getBytes(int currentRow, byte[] buffer, int offset) throws SQLException {
        if (this.isNull(currentRow)) {
            return 0;
        }
        return this.rowData.getUtf8Bytes(this.getOffset(currentRow), this.getLength(currentRow), buffer, offset, this.statement.connection.conversion.getCharacterSet(this.formOfUse));
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        AccessorPrototype p = new AccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CVarcharAccessor acc = new T4CVarcharAccessor(stmt, T4CVarcharAccessor.this.describeMaxLength, T4CVarcharAccessor.this.nullable, -1, T4CVarcharAccessor.this.precision, T4CVarcharAccessor.this.scale, T4CVarcharAccessor.this.contflag, -1, T4CVarcharAccessor.this.formOfUse, T4CVarcharAccessor.this.describeMaxLengthChars, T4CVarcharAccessor.this.oacmxl, T4CVarcharAccessor.this.definedColumnType, T4CVarcharAccessor.this.definedColumnSize, null);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }
}

