/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.JakartaGeneratorWrapper;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;

public class JakartaOsonObject
extends OsonAbstractObject
implements JsonObject,
Wrapper {
    public JakartaOsonObject(OsonContext ctx) {
        super(ctx);
    }

    public JakartaOsonObject(OsonContext ctx, int pos) {
        super(ctx, pos);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(new OsonObjectImpl(new OsonContext(this.ctx), this.pos));
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(OsonObjectImpl.class);
    }

    public JsonValue get(Object key) {
        return (JsonValue)this.getInternal(key);
    }

    public JsonArray getJsonArray(String key) {
        return (JsonArray)this.getJsonArrayInternal(key);
    }

    public JsonObject getJsonObject(String key) {
        return (JsonObject)this.getJsonObjectInternal(key);
    }

    public JsonNumber getJsonNumber(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset < 0) {
            return null;
        }
        return (JsonNumber)this.getValueInternal(childOffset);
    }

    public JsonString getJsonString(String key) {
        return (JsonString)this.get(key);
    }

    @Override
    public String getString(String key) {
        return this.getJsonString(key).getString();
    }

    @Override
    public String getString(String key, String defaultValue) {
        JsonValue v = this.get(key);
        if (v == null) {
            return defaultValue;
        }
        if (v.getValueType() == JsonValue.ValueType.STRING) {
            return ((JsonString)v).getString();
        }
        return defaultValue;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    public JsonValue put(String key, JsonValue value) {
        throw new UnsupportedOperationException();
    }

    public JsonValue remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends JsonValue> m4) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Collection<JsonValue> values() {
        return new OsonAbstractObject.OsonObjectValues<JsonValue>(this);
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return new OsonAbstractObject.OsonEntrySet<JsonValue>(this);
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Map.Entry<String, JsonValue> e : this.entrySet()) {
            result += e.hashCode();
        }
        return result;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        JakartaGeneratorWrapper ser = new JakartaGeneratorWrapper(new JsonSerializerImpl(writer));
        ser.write((JsonValue)this);
        ser.close();
        return writer.toString();
    }
}

