/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JakartaObjectImpl;
import oracle.jdbc.driver.json.tree.JsonpObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonObjectImpl
implements OracleJsonObject {
    final Map<String, OracleJsonValue> map;

    public OracleJsonObjectImpl() {
        this.map = new LinkedHashMap<String, OracleJsonValue>();
    }

    public OracleJsonObjectImpl(OracleJsonObject other) {
        this.map = new HashMap<String, OracleJsonValue>();
        block4: for (Map.Entry e : other.entrySet()) {
            String key = (String)e.getKey();
            OracleJsonValue value = (OracleJsonValue)e.getValue();
            switch (value.getOracleJsonType()) {
                case OBJECT: {
                    this.map.put(key, new OracleJsonObjectImpl(value.asJsonObject()));
                    continue block4;
                }
                case ARRAY: {
                    this.map.put(key, new OracleJsonArrayImpl(value.asJsonArray()));
                    continue block4;
                }
            }
            this.map.put(key, value);
        }
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.OBJECT;
    }

    private void checkNull(OracleJsonValue v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public OracleJsonValue get(Object key) {
        return this.map.get(key);
    }

    @Override
    public OracleJsonValue put(String key, OracleJsonValue value) {
        this.checkNull(value);
        return this.map.put(key, value);
    }

    @Override
    public OracleJsonValue remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends OracleJsonValue> m4) {
        for (Map.Entry<? extends String, ? extends OracleJsonValue> e : m4.entrySet()) {
            this.checkNull(e.getValue());
            this.map.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<OracleJsonValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, OracleJsonValue>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String getString(String name) {
        return this.map.get(name).asJsonString().getString();
    }

    @Override
    public String getString(String name, String defaultValue) {
        OracleJsonValue v = this.map.get(name);
        return v == null || v.getOracleJsonType() != OracleJsonValue.OracleJsonType.STRING ? defaultValue : v.asJsonString().getString();
    }

    @Override
    public int getInt(String name) {
        return ((OracleJsonNumber)this.map.get(name)).intValue();
    }

    @Override
    public int getInt(String name, int defaultValue) {
        OracleJsonValue v = this.map.get(name);
        return v instanceof OracleJsonNumber ? ((OracleJsonNumber)v).intValue() : defaultValue;
    }

    @Override
    public double getDouble(String name) {
        return ((OracleJsonNumber)this.map.get(name)).doubleValue();
    }

    @Override
    public long getLong(String key) {
        return ((OracleJsonNumber)this.map.get(key)).longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return ((OracleJsonNumber)this.map.get(key)).bigDecimalValue();
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        OracleJsonValue v = this.map.get(name);
        return v instanceof OracleJsonNumber ? ((OracleJsonNumber)v).doubleValue() : defaultValue;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        OracleJsonValue v = this.map.get(key);
        return v instanceof OracleJsonNumber ? ((OracleJsonNumber)v).longValue() : defaultValue;
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        OracleJsonValue v = this.map.get(key);
        return v instanceof OracleJsonNumber ? ((OracleJsonNumber)v).bigDecimalValue() : defaultValue;
    }

    @Override
    public boolean getBoolean(String name) {
        OracleJsonValue v = this.map.get(name);
        if (v.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (v.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        OracleJsonValue v = this.map.get(name);
        if (v == null) {
            return defaultValue;
        }
        if (v.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (v.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public boolean isNull(String name) {
        return this.map.get(name).equals(OracleJsonValue.NULL);
    }

    @Override
    public LocalDateTime getLocalDateTime(String key) {
        OracleJsonValue v = this.map.get(key);
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return v.asJsonDate().getLocalDateTime();
        }
        return v.asJsonTimestamp().getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key) {
        OracleJsonValue v = this.map.get(key);
        return v.asJsonTimestampTZ().getOffsetDateTime();
    }

    @Override
    public LocalDateTime getLocalDateTime(String key, LocalDateTime defaultValue) {
        OracleJsonValue v = this.map.get(key);
        if (v == null) {
            return defaultValue;
        }
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return v.asJsonDate().getLocalDateTime();
        }
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return v.asJsonTimestamp().getLocalDateTime();
        }
        return defaultValue;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key, OffsetDateTime defaultValue) {
        OracleJsonValue v = this.map.get(key);
        if (v == null) {
            return defaultValue;
        }
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMPTZ) {
            return v.asJsonTimestampTZ().getOffsetDateTime();
        }
        return defaultValue;
    }

    @Override
    public byte[] getBytes(String name) {
        return this.get(name).asJsonBinary().getBytes();
    }

    @Override
    public byte[] getBytes(String name, byte[] defaultValue) {
        OracleJsonValue v = this.map.get(name);
        if (v == null) {
            return defaultValue;
        }
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.BINARY) {
            return v.asJsonBinary().getBytes();
        }
        return defaultValue;
    }

    @Override
    public OracleJsonValue put(String name, byte[] value) {
        return this.map.put(name, new OracleJsonBinaryImpl(value, false));
    }

    @Override
    public OracleJsonValue put(String name, String value) {
        return this.put(name, new OracleJsonStringImpl(value));
    }

    @Override
    public OracleJsonValue put(String name, int value) {
        return this.put(name, new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.INT));
    }

    @Override
    public OracleJsonValue put(String name, long value) {
        return this.put(name, new OracleJsonDecimalImpl(value, OracleJsonDecimal.TargetType.LONG));
    }

    @Override
    public OracleJsonValue put(String name, BigDecimal value) {
        return this.put(name, new OracleJsonDecimalImpl(value));
    }

    @Override
    public OracleJsonValue put(String name, double value) {
        return this.put(name, new OracleJsonDoubleImpl(value));
    }

    @Override
    public OracleJsonValue put(String name, boolean value) {
        return this.put(name, value ? OracleJsonValue.TRUE : OracleJsonValue.FALSE);
    }

    @Override
    public OracleJsonValue putNull(String name) {
        return this.put(name, OracleJsonValue.NULL);
    }

    @Override
    public OracleJsonValue put(String key, OffsetDateTime value) {
        return this.put(key, new OracleJsonTimestampTZImpl(value));
    }

    @Override
    public OracleJsonValue put(String key, LocalDateTime value) {
        return this.put(key, new OracleJsonTimestampImpl(value));
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        JsonSerializerImpl ser = new JsonSerializerImpl(writer);
        ser.write(this);
        ser.close();
        return writer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.map.equals(other);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public <T> T wrap(Class<T> c) {
        if (Jsonp.isJakartaJson(c)) {
            return c.cast(new JakartaObjectImpl(this));
        }
        return c.cast(new JsonpObjectImpl(this));
    }
}

