/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.jdbc.driver.parser.Earley;
import oracle.jdbc.driver.parser.LexerToken;
import oracle.jdbc.driver.parser.Matrix;
import oracle.jdbc.driver.parser.ParseNode;
import oracle.jdbc.driver.parser.Parseable;
import oracle.jdbc.driver.parser.Parser;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.Token;
import oracle.jdbc.driver.parser.UnifiedRules;
import oracle.jdbc.driver.parser.util.Array;
import oracle.jdbc.driver.parser.util.Service;

public class SqlEarley
extends Earley
implements Parseable {
    private static SqlEarley instance = null;
    private static RuleTuple[] origRules = null;
    private int as;
    private int aliased_dml_table_expression_clause;
    private int basic_decl_item;
    private int begin;
    private int body;
    private int boolean_primary;
    private int compound_expression;
    private int condition;
    public int CONNECT;
    private int dotted_name;
    public int decl_id;
    private int distinct;
    private int ELSE;
    private int expr;
    private int grouping_expression_list;
    private int json_object_arg_list;
    private int model_expression;
    private int arg_list;
    public int multiset_except;
    private int pkg_spec;
    private int pls_expr;
    public int query_block;
    public int REPLACE;
    public int select;
    public int simple_expression;
    public int sim_stmt;
    public int sql_statement;
    public int sql_statements;
    public int sqlplus_lexeme;
    private int start;
    public int stmt;
    public int subquery;
    public int table_reference;
    private int unlabeled_nonblock_stmt;
    private int user_defined_types;
    private int where_gby_hier;
    private int HEX_LITERAL;
    private int RegExpLiteral;
    private int StringLiteral;
    private int TemplateLiteral;
    private int[] whatToRecognize = new int[0];
    int END = this.getSymbol("'END'");
    int RPAREN = this.getSymbol("')'");
    int semi = this.getSymbol("';'");
    private int[] notOptimizableHeadSymbols = null;
    boolean isAsc = false;
    public static String[] keywords = new String[]{"'WITH'", "'SELECT'", "'FROM'", "'WHERE'", "'AND'", "'OR'", "'NOT'", "'DISTINCT'", "'UNION'", "'ALL'", "'NATURAL'", "'ON'", "'INSERT'", "'UPDATE'", "'CREATE'", "'ALTER'", "'TABLE'", "'VALUES'", "'VARCHAR2'", "'INTEGER'", "'WHEN'"};
    private Set<Integer> _keywords = new TreeSet<Integer>();
    private Set<Integer> _JSkeywords = new TreeSet<Integer>();

    public static SqlEarley newPartialRecognizer() {
        return SqlEarley.newPartialRecognizer(new String[]{"sql_statements", "subprg_body", "expr"});
    }

    public static SqlEarley newPartialRecognizer(String[] what2Recognize) {
        SqlEarley ret = new SqlEarley(){

            @Override
            protected boolean lookaheadOK(Parser.Tuple t2, int pos, Matrix matrix) {
                return true;
            }

            @Override
            protected void merge(Parser.EarleyCell cell, long[] ls, Matrix matrix) {
                cell.merge(ls);
            }

            @Override
            protected boolean scan(Matrix matrix, List<LexerToken> src) {
                boolean ret = super.scan(matrix, src);
                matrix.LAsuspect = null;
                return ret;
            }
        };
        for (String symbol : what2Recognize) {
            ret.addSymbol2Recognize(symbol);
        }
        return ret;
    }

    public static SqlEarley getInstance() {
        return instance;
    }

    static RuleTuple[] getRules() {
        return origRules;
    }

    private SqlEarley() {
        this(SqlEarley.getRules());
    }

    private SqlEarley(RuleTuple[] rules) {
        super(rules, false);
        this.initKeywords();
        this.as = this.getSymbol("'AS'");
        this.aliased_dml_table_expression_clause = this.getSymbol("aliased_dml_table_expression_clause");
        this.basic_decl_item = this.getSymbol("basic_decl_item");
        this.begin = this.getSymbol("'BEGIN'");
        this.body = this.getSymbol("'BODY'");
        this.boolean_primary = this.getSymbol("boolean_primary");
        this.compound_expression = this.getSymbol("compound_expression");
        this.condition = this.getSymbol("condition");
        this.CONNECT = this.getSymbol("CONNECT");
        this.dotted_name = this.getSymbol("dotted_name");
        this.decl_id = this.getSymbol("decl_id");
        this.distinct = this.getSymbol("'DISTINCT'");
        this.ELSE = this.getSymbol("'ELSE'");
        this.expr = this.getSymbol("expr");
        this.grouping_expression_list = this.getSymbol("grouping_expression_list");
        this.json_object_arg_list = this.getSymbol("json_object_arg_list");
        this.model_expression = this.getSymbol("model_expression");
        this.arg_list = this.getSymbol("arg_list");
        this.multiset_except = this.getSymbol("multiset_except");
        this.pkg_spec = this.getSymbol("pkg_spec");
        this.pls_expr = this.getSymbol("pls_expr");
        this.query_block = this.getSymbol("query_block");
        this.REPLACE = this.getSymbol("'REPLACE'");
        this.select = this.getSymbol("select");
        this.simple_expression = this.getSymbol("simple_expression");
        this.sim_stmt = this.getSymbol("sim_stmt");
        this.sql_statement = this.getSymbol("sql_statement");
        this.sql_statements = this.getSymbol("sql_statements");
        this.sqlplus_lexeme = this.getSymbol("sqlplus_lexeme");
        this.start = this.getSymbol("'START'");
        this.stmt = this.getSymbol("stmt");
        this.subquery = this.getSymbol("subquery");
        this.table_reference = this.getSymbol("table_reference");
        this.unlabeled_nonblock_stmt = this.getSymbol("unlabeled_nonblock_stmt");
        this.user_defined_types = this.getSymbol("user_defined_types");
        this.where_gby_hier = this.getSymbol("\"where,gby,hier\"");
        this.HEX_LITERAL = this.getSymbol("HEX_LITERAL");
        this.RegExpLiteral = this.getSymbol("RegExpLiteral");
        this.StringLiteral = this.getSymbol("string_literal");
        this.TemplateLiteral = this.getSymbol("TemplateLiteral");
        this.prioritizeRules();
        this.precomputePredictions();
    }

    private void prioritizeRules() {
        this.prioritizeRules(this.getSymbol("adt_field"), new int[]{this.getSymbol("method_specification"), this.getSymbol("field")});
        this.prioritizeRules(this.getSymbol("\"alter_pluggable_database_clause\""), new int[]{this.getSymbol("pdb_datafile_clause"), this.getSymbol("pdb_change_state_from_root")});
        this.prioritizeRules(this.getSymbol("alter_table___0#"), new int[]{this.getSymbol("constraint_clauses"), this.getSymbol("column_clauses"), this.getSymbol("alter_external_table")});
        this.prioritizeRules(this.getSymbol("analytic_function"), new int[]{this.getSymbol("count"), this.getSymbol("nth_value"), this.getSymbol("first_last_value"), this.getSymbol("listagg"), this.getSymbol("lag"), this.getSymbol("lead"), this.getSymbol("sum"), this.getSymbol("min"), this.getSymbol("max"), this.getSymbol("a_f")});
        String plsRule = "assoc_arg:  assoc_name_list  '='  '>'  pls_expr;";
        String sqlRule = "assoc_arg:  sim_expr  '='  '>'  expr;";
        this.swapRules(plsRule, sqlRule);
        this.prioritizeRules(this.getSymbol("basic_d"), new int[]{this.getSymbol("subprg_i"), this.getSymbol("object_d")});
        this.prioritizeRules(this.basic_decl_item, new int[]{this.getSymbol("pragma"), this.getSymbol("basic_d")});
        this.prioritizeRules(this.boolean_primary, new int[]{this.getSymbol("'TRUE'"), this.getSymbol("'FALSE'"), this.getSymbol("sim_expr"), this.condition, this.getSymbol("function_expression")});
        String simExprRule = "boolean_primary:  sim_expr;";
        String boolPriRule = "boolean_primary:  condition;";
        this.swapRules(simExprRule, boolPriRule);
        this.prioritizeRules(this.getSymbol("cell_assignment___0"), new int[]{this.getSymbol("multi_column_for_loop"), this.getSymbol("cell_assignment___1")});
        this.prioritizeRules(this.getSymbol("col_properties"), new int[]{this.getSymbol("out_of_line_ref_constraint"), this.getSymbol("out_of_line_constraint"), this.getSymbol("column_definition")});
        this.prioritizeRules(this.getSymbol("column_definition___2"), new int[]{this.getSymbol("inline_ref_constraint"), this.getSymbol("inline_constraint")});
        String condExprRule = "\"cond_or_expr\":  expr;";
        String condModelRule = "\"cond_or_expr\":  model_condition;";
        this.swapRules(condExprRule, condModelRule);
        String rule2 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause;";
        String rule3 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause  insert_into_clause___0;";
        this.swapRules(rule2, rule3);
        this.prioritizeRules(this.getSymbol("comparison_condition"), new int[]{this.getSymbol("between_condition"), this.getSymbol("group_comparison_condition"), this.getSymbol("simple_comparison_condition")});
        this.prioritizeRules(this.compound_expression, new int[]{this.getSymbol("expr"), this.getSymbol("compound_expression___1")});
        this.prioritizeRules(this.condition, new int[]{this.getSymbol("compound_condition"), this.getSymbol("comparison_condition"), this.getSymbol("null_condition"), this.getSymbol("JSON_condition"), this.getSymbol("simple_expression"), this.getSymbol("function_expression")});
        this.prioritizeRules(this.getSymbol("datetime_expression___1"), new int[]{this.getSymbol("'DBTIMEZONE'"), this.getSymbol("string_literal"), this.expr});
        this.prioritizeRules(this.getSymbol("expr#"), new int[]{this.simple_expression, this.compound_expression, this.getSymbol("function_expression"), this.getSymbol("object_access_expression"), this.getSymbol("type_constructor_expression"), this.getSymbol("JSON_object_access_expr"), this.getSymbol("model_expression"), this.getSymbol("compound_condition")});
        this.prioritizeRules(this.getSymbol("function_expression"), new int[]{this.getSymbol("function"), this.getSymbol("function_call")});
        this.prioritizeRules(this.getSymbol("function"), new int[]{this.getSymbol("aggregate_function"), this.getSymbol("analytic_function"), this.getSymbol("single_row_function"), this.getSymbol("user_defined_function"), this.getSymbol("object_reference_function")});
        this.prioritizeRules(this.getSymbol("group_by_col"), new int[]{this.getSymbol("rollup_cube_clause"), this.getSymbol("expr")});
        this.prioritizeRules(this.getSymbol("modify_column_clauses___1"), new int[]{this.getSymbol("modify_col_visibility"), this.getSymbol("modify_col_properties"), this.getSymbol("virtual_column_definition")});
        this.prioritizeRules(this.getSymbol("pdb_change_state"), new int[]{this.getSymbol("pdb_change_state___0"), this.identifier});
        this.prioritizeRules(this.pls_expr, new int[]{this.getSymbol("pls_expr"), this.getSymbol("and_expr")});
        this.prioritizeRules(this.getSymbol("query_table_expression"), new int[]{this.getSymbol("xmltable"), this.getSymbol("table_collection_expression"), this.getSymbol("function_expression")});
        this.prioritizeRules(this.getSymbol("select_term"), new int[]{this.expr, this.getSymbol("\"aliased_expr\"")});
        this.prioritizeRules(this.simple_expression, new int[]{this.getSymbol("literal"), this.getSymbol("'NULL'"), this.getSymbol("'CONNECT_BY_ROOT'"), this.getSymbol("'ROWID'"), this.getSymbol("'ROWNUM'"), this.getSymbol("'CONNECT_BY_ISCYCLE'"), this.getSymbol("'CONNECT_BY_ISLEAF'"), this.getSymbol("identifier"), this.getSymbol("column")});
        this.prioritizeRules(this.sim_stmt, new int[]{this.getSymbol("null_stmt"), this.getSymbol("exit_stmt"), this.getSymbol("continue_stmt"), this.getSymbol("raise_stmt"), this.getSymbol("return_stmt"), this.getSymbol("procedure_call")});
        this.prioritizeRules(this.getSymbol("ty_def"), new int[]{this.getSymbol("array_ty_def"), this.getSymbol("tbl_ty_def")});
        this.prioritizeRules(this.getSymbol("unconstrained_type_wo_datetime_wo_national"), new int[]{this.getSymbol("pls_number_datatypes"), this.getSymbol("link_expanded_n")});
        this.prioritizeRules(this.unlabeled_nonblock_stmt, new int[]{this.getSymbol("sql_stmt"), this.sim_stmt});
        this.prioritizeRules(this.getSymbol("values_clause___0"), new int[]{this.getSymbol("par_expr_list"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause___3"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause___6"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
    }

    private void prioritizeRules(int head, int[] symbols) {
        int[] ruleNumbers = new int[symbols.length];
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Parser.Tuple t2 = this.rules[i];
            if (t2.head != head || t2.rhs.length != 1 && t2.head != this.boolean_primary && t2.head != this.basic_decl_item && t2.head != this.compound_expression && t2.head != this.simple_expression && t2.head != this.pls_expr && t2.head != this.unlabeled_nonblock_stmt && t2.head != this.sim_stmt) continue;
            for (int j = 0; j < symbols.length; ++j) {
                if (t2.rhs[0] != symbols[j]) continue;
                ruleNumbers[j] = i;
                continue block0;
            }
        }
        Parser.Tuple[] tuples = new Parser.Tuple[symbols.length];
        for (int j = 0; j < symbols.length; ++j) {
            tuples[j] = this.rules[ruleNumbers[j]];
        }
        Arrays.sort(ruleNumbers);
        for (int i = 0; i < ruleNumbers.length; ++i) {
            this.rules[ruleNumbers[i]] = tuples[i];
        }
    }

    public void addSymbol2Recognize(String additionalSymbol) {
        this.addSymbol2Recognize(this.getSymbol(additionalSymbol));
    }

    public void addSymbol2Recognize(int additionalSymbol) {
        int[] tmp = new int[this.whatToRecognize.length + 1];
        for (int i = 0; i < this.whatToRecognize.length; ++i) {
            if (this.whatToRecognize[i] == additionalSymbol) {
                return;
            }
            tmp[i] = this.whatToRecognize[i];
        }
        tmp[this.whatToRecognize.length] = additionalSymbol;
        this.whatToRecognize = tmp;
    }

    @Override
    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        long t1 = 0L;
        matrix.initCells(src.size());
        if (src.size() == 0) {
            return;
        }
        this.initCell(matrix, this.whatToRecognize, 0);
        LexerToken LAtoken = src.get(0);
        matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
    }

    protected boolean scan(Matrix matrix, List<LexerToken> src, long[] deletedXs) {
        int x;
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        if (deletedXs != null) {
            for (long range : deletedXs) {
                for (x = Service.lX(range); x < Service.lY(range); ++x) {
                    matrix.allXs = Array.delete(matrix.allXs, x);
                }
            }
            deletedXs = null;
        }
        LexerToken token = src.get(y);
        String tokUpper = token.content.toUpperCase();
        Integer suspect = (Integer)this.symbolIndexes.get("'" + tokUpper + "'");
        matrix.LAsuspect = null;
        if (y + 1 < src.size()) {
            LexerToken LAtoken = src.get(y + 1);
            matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
        }
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect, deletedXs)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect, deletedXs)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect, long[] deletedXs) {
        long t1 = 0L;
        long[] content = null;
        Parser.EarleyCell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Parser.Tuple t2 = this.rules[ruleNo];
            if (t2.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t2, suspect) || !this.lookaheadOK(t2, pos + 1, matrix)) continue;
            long cellElem = SqlEarley.makeMatrixCellElem(ruleNo, pos + 1, t2);
            content = Array.insert(content, cellElem);
            if (t2.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t2.head));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new Parser.EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        return true;
    }

    @Override
    protected boolean lookaheadOK(Parser.Tuple t2, int pos, Matrix matrix) {
        if (pos > t2.size() - 1) {
            return true;
        }
        int nextInTuple = t2.content(pos);
        if (this.isTerminal(nextInTuple)) {
            return matrix.LAsuspect != null && nextInTuple == matrix.LAsuspect;
        }
        Earley.PredictedTerminals terminal = this.terminalPredictions[nextInTuple];
        if (terminal != null) {
            return terminal.matches(matrix.LAsuspect);
        }
        return true;
    }

    @Override
    protected void merge(Parser.EarleyCell cell, long[] ls, Matrix matrix) {
        if (ls != null) {
            for (long l : ls) {
                Parser.Tuple t2 = this.rules[SqlEarley.ruleFromEarleyCell(l)];
                if (!this.lookaheadOK(t2, 0, matrix)) continue;
                cell.insertContent(l);
            }
        }
    }

    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect, boolean isJsRule) {
        LexerToken next;
        LexerToken token = src.get(y);
        if (symbol == this.RegExpLiteral && token.type == Token.REGEXP) {
            return true;
        }
        if (symbol != this.identifier) {
            return false;
        }
        LexerToken prior = null;
        if (!isJsRule && suspect != null && this._keywords.contains(suspect)) {
            if (0 < y) {
                prior = src.get(y - 1);
            }
            if (prior == null || !":".equals(prior.content)) {
                return false;
            }
        }
        if (isJsRule && suspect != null && this._JSkeywords.contains(suspect)) {
            return false;
        }
        if (!isJsRule && token.type == Token.DQUOTED_STRING) {
            return true;
        }
        if (token.type != Token.IDENTIFIER) {
            return false;
        }
        if (suspect == null) {
            return true;
        }
        if (prior == null && 0 < y) {
            prior = src.get(y - 1);
        }
        if ("TO".equalsIgnoreCase(token.content) && prior != null && ("YEAR".equalsIgnoreCase(prior.content) || "HOUR".equalsIgnoreCase(prior.content) || "MINUTE".equalsIgnoreCase(prior.content))) {
            return false;
        }
        if ("IF".equalsIgnoreCase(token.content) && prior != null && "TABLE".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("BY".equalsIgnoreCase(token.content) && prior != null && "CONNECT".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("CASE".equalsIgnoreCase(token.content) && y + 1 < src.size() && "WHEN".equalsIgnoreCase(src.get((int)(y + 1)).content)) {
            return false;
        }
        if (("LEFT".equalsIgnoreCase(token.content) || "CROSS".equalsIgnoreCase(token.content)) && y < src.size() - 1) {
            LexerToken next2 = src.get(y + 1);
            return !"JOIN".equalsIgnoreCase(next2.content);
        }
        if ("INNER".equalsIgnoreCase(token.content) && y < src.size() - 1) {
            LexerToken next3 = src.get(y + 1);
            if ("JOIN".equalsIgnoreCase(next3.content)) {
                return false;
            }
            return prior == null || !"NATURAL".equalsIgnoreCase(prior.content);
        }
        if (prior != null && "FROM".equalsIgnoreCase(prior.content) && ("FIRST".equalsIgnoreCase(token.content) || "LAST".equalsIgnoreCase(token.content))) {
            next = null;
            if (y + 1 < src.size()) {
                next = src.get(y + 1);
            }
            if (next != null && ("OVER".equalsIgnoreCase(next.content) || "IGNORE".equalsIgnoreCase(next.content) || "RESPECT".equalsIgnoreCase(next.content))) {
                return false;
            }
        }
        if ("AS".equalsIgnoreCase(token.content) && prior != null && "@".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("BETWEEN".equalsIgnoreCase(token.content)) {
            next = null;
            if (y < src.size()) {
                next = src.get(y + 1);
            }
            if (next != null && "-".equalsIgnoreCase(next.content)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Parser.Tuple t2, Integer suspect) {
        boolean isJsRule;
        LexerToken token = src.get(y);
        int symbol = t2.content(pos);
        if (symbol == this.digits && token.type == Token.DIGITS) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.BQUOTED_STRING) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.QUOTED_STRING) {
            return true;
        }
        if (symbol == this.sqlplus_lexeme && token.type == Token.SQLPLUS_COMMAND) {
            return true;
        }
        String head = this.allSymbols[t2.head];
        boolean bl = isJsRule = 3 < head.length() && Character.isUpperCase(head.charAt(0)) && Character.isLowerCase(head.charAt(1));
        if (isJsRule && symbol == this.string_literal && token.type == Token.DQUOTED_STRING) {
            return true;
        }
        return suspect != null && suspect == symbol || this.isIdentifier(y, src, symbol, suspect, isJsRule) && (suspect == null || this.notConfusedAsId(suspect, t2.head, pos));
    }

    @Override
    protected boolean notConfusedAsId(int suspect, int head, int pos) {
        return !(suspect == this.begin && (head == this.dotted_name || head == this.decl_id) && pos == 0 || suspect == this.start && head == this.table_reference && pos == 1 || suspect == this.distinct && head == this.multiset_except && pos == 3 || suspect == this.body && head == this.pkg_spec && pos == 1 || suspect == this.as && head == this.table_reference && pos == 1 || suspect == this.ELSE && head == this.aliased_dml_table_expression_clause && pos == 1 || suspect == this.REPLACE && head == this.user_defined_types && pos == 0);
    }

    @Override
    protected boolean isOptimizable(Parser.Tuple tuple, int preSym, int mid, int y) {
        int headSym;
        int i;
        if (preSym == this.sql_statement && y < mid + 3) {
            return false;
        }
        if (this.notOptimizableHeadSymbols == null) {
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.grouping_expression_list);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.json_object_arg_list);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.model_expression);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.arg_list);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.compound_expression);
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("column"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("dotted_expr"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("object_access_expression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("pivot_clause___0#"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("elsif_clause_opt"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("table_properties___0"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("physical_properties"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("alter_system___0"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("LabeledStatement"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("MemberExpression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("FunctionExpression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("AssignmentExpression"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("IfStatement"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("Statement_List1"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("MethodDefinition_List1"));
            this.notOptimizableHeadSymbols = Array.insert(this.notOptimizableHeadSymbols, this.getSymbol("BinaryExpression"));
        }
        if (this.notOptimizableHeadSymbols[i = Array.indexOf(this.notOptimizableHeadSymbols, headSym = tuple.head)] == headSym) {
            return false;
        }
        if (this.subquery == headSym && tuple.rhs.length == 2 && tuple.rhs[1] == this.getSymbol("row_limiting_clause")) {
            return false;
        }
        return super.isOptimizable(headSym, preSym, mid, y);
    }

    @Override
    public void parse(List<LexerToken> src, Matrix matrix) {
        try {
            this.parse(src, matrix, null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.skipRanges = true;
    }

    @Override
    protected boolean isAsc(int ruleHead) {
        return ruleHead == this.getSymbol("sql_statements") || ruleHead == this.getSymbol("subquery");
    }

    public int recognize(List<LexerToken> src) {
        Matrix matrix = new Matrix(SqlEarley.getInstance());
        this.parse(src, matrix);
        for (int i = src.size(); 0 < i; --i) {
            Parser.EarleyCell top = matrix.get(0, i);
            if (top == null) continue;
            return i;
        }
        throw new AssertionError((Object)"all empty cells?");
    }

    void initKeywords() {
        for (String k : keywords) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    public void reInitKeywords(String[] replacement) {
        this._keywords.clear();
        for (String k : replacement) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    @Override
    protected ParseNode tree(List<LexerToken> src, Matrix m4, int x, int y, int rule, int pos) {
        ParseNode ret = super.tree(src, m4, x, y, rule, pos);
        if (ret.contains(this.subquery) && !ret.contains(this.query_block)) {
            for (ParseNode child : ret.children()) {
                if (!child.contains(this.query_block)) continue;
                child.deleteContent(this.query_block);
            }
            ret.addContent(this.query_block);
        }
        return ret;
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m4, Parser.EarleyCell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            Parser.Tuple t2 = this.rules[rule];
            if (t2.head != this.sql_statements && t2.head != this.select || this.rules[rule].rhs.length != (pos = cell.getPosition(i))) continue;
            return this.tree(src, m4, x, y, rule, pos);
        }
        return super.treeForACell(src, m4, cell, x, y);
    }

    public void parse(List<LexerToken> src, Matrix matrix, InterruptedException interrupted) throws InterruptedException {
        long[] skipRanges = null;
        this.initCell00(src, matrix);
        this.predict(matrix);
        while (this.scan(matrix, src, skipRanges)) {
            this.complete(matrix, src.size());
            this.predict(matrix);
        }
    }

    @Override
    public boolean isAuxNode(int symbol) {
        return this.where_gby_hier == symbol;
    }

    static {
        try {
            origRules = UnifiedRules.getRules();
            instance = SqlEarley.newPartialRecognizer();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize SQL parser", e);
        }
    }
}

