/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Random;
import oracle.jdbc.driver.utils.ThrowingConsumer;
import oracle.jdbc.driver.utils.ThrowingFunction;

public final class OpaqueString
implements Serializable {
    public static final OpaqueString NULL = new OpaqueString((CharSequence)null);
    public static final OpaqueString EMPTY = new OpaqueString("");
    private char[] c;

    public static OpaqueString newOpaqueString(char[] ch) {
        if (ch == null) {
            return NULL;
        }
        if (ch.length == 0) {
            return EMPTY;
        }
        return new OpaqueString(ch);
    }

    public static OpaqueString newOpaqueString(CharSequence charSequence) {
        if (charSequence == null) {
            return NULL;
        }
        if (charSequence.length() == 0) {
            return EMPTY;
        }
        return new OpaqueString(charSequence);
    }

    private OpaqueString(CharSequence charSequence) {
        if (charSequence == null) {
            this.c = null;
        } else {
            this.c = new char[charSequence.length()];
            for (int i = 0; i < charSequence.length(); ++i) {
                this.c[i] = charSequence.charAt(i);
            }
            OpaqueString.xor(this.c, this.c, super.hashCode() + this.getClass().hashCode());
        }
    }

    private OpaqueString(char[] ch) {
        if (ch == null) {
            this.c = null;
        } else {
            try {
                this.c = new char[ch.length];
                OpaqueString.xor(ch, this.c, super.hashCode() + this.getClass().hashCode());
            }
            finally {
                Arrays.fill(ch, '\u0000');
            }
        }
    }

    public String get() {
        if (this.c == null) {
            return null;
        }
        return this.map(String::new);
    }

    public char[] getChars() {
        if (this.c == null) {
            return null;
        }
        char[] clearText = new char[this.c.length];
        this.copyTo(CharBuffer.wrap(clearText));
        return clearText;
    }

    public void copyTo(CharBuffer charBuffer) {
        if (this.c == null) {
            return;
        }
        OpaqueString.xor(this.c, charBuffer, super.hashCode() + this.getClass().hashCode());
    }

    public boolean isNull() {
        return this.c == null;
    }

    public boolean isEmpty() {
        return this.c != null && this.c.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T map(ThrowingFunction<char[], T, E> mapper) throws E {
        if (this.c == null) {
            return mapper.applyOrThrow(null);
        }
        char[] clearText = new char[this.c.length];
        try {
            OpaqueString.xor(this.c, clearText, super.hashCode() + this.getClass().hashCode());
            T t2 = mapper.applyOrThrow(clearText);
            return t2;
        }
        finally {
            Arrays.fill(clearText, '\u0000');
        }
    }

    public <E extends Throwable> void peek(ThrowingConsumer<char[], E> consumer) throws E {
        this.map(clearText -> {
            consumer.acceptOrThrow((char[])clearText);
            return null;
        });
    }

    public int length() {
        return this.c == null ? 0 : this.c.length;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        short[] sh;
        if (this.c == null) {
            sh = null;
        } else {
            sh = new short[this.c.length * 2];
            for (int i = 0; i < this.c.length; ++i) {
                sh[i] = (short)this.c[i];
            }
            Random rand = new Random(super.hashCode() + this.getClass().hashCode());
            for (int i = this.c.length; i < sh.length; ++i) {
                sh[i] = (short)rand.nextInt();
            }
        }
        oos.writeObject(sh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        short[] sh = (short[])ois.readObject();
        if (sh == null) {
            this.c = null;
        } else {
            char[] clearText = new char[sh.length / 2];
            try {
                for (int i = 0; i < clearText.length; ++i) {
                    clearText[i] = (char)(sh[i] ^ sh[i + clearText.length]);
                }
                this.c = new char[clearText.length];
                OpaqueString.xor(clearText, this.c, super.hashCode() + this.getClass().hashCode());
            }
            finally {
                Arrays.fill(clearText, '\u0000');
            }
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpaqueString)) {
            return false;
        }
        OpaqueString other = (OpaqueString)obj;
        if (this.c == null || other.c == null) {
            return this.c == other.c;
        }
        if (this.c.length != other.c.length) {
            return false;
        }
        Random rand = new Random(super.hashCode() + this.getClass().hashCode());
        Random otherRand = new Random(System.identityHashCode(other) + other.getClass().hashCode());
        for (int i = 0; i < this.c.length; ++i) {
            char otherChar;
            char thisChar = (char)(this.c[i] ^ rand.nextInt());
            if (thisChar == (otherChar = (char)(other.c[i] ^ otherRand.nextInt()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.c == null || this.c.length == 0) {
            return 0;
        }
        return this.map(clearText -> {
            int hash = 0;
            for (int i = 0; i < ((char[])clearText).length; ++i) {
                hash = 31 * hash + clearText[i];
            }
            return hash;
        });
    }

    private static void xor(char[] input, char[] output, int seed) {
        assert (input.length == output.length) : "Input and output are different lengths. input.length: " + input.length + " output.length: " + output.length;
        OpaqueString.xor(input, CharBuffer.wrap(output), seed);
    }

    private static void xor(char[] input, CharBuffer output, int seed) {
        Random rand = new Random(seed);
        for (int i = 0; i < input.length; ++i) {
            output.put((char)(input[i] ^ rand.nextInt()));
        }
    }

    public static boolean isNull(OpaqueString opaqueString) {
        return opaqueString == null || opaqueString.isNull();
    }
}

