/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.util.HashSet;
import java.util.logging.Level;
import oracle.jdbc.AdditionalDatabaseMetaData;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={DatabaseMetaData.class, ParameterMetaData.class, ResultSetMetaData.class, RowId.class, SQLData.class, SQLInput.class, SQLXML.class, AdditionalDatabaseMetaData.class, OracleParameterMetaData.class, OracleResultSetMetaData.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, oracle.jdbc.internal.OracleResultSetMetaData.class})
public abstract class NonTxnReplayableBase
implements Replayable,
InvocationHandler,
Monitor,
Diagnosable {
    protected FailoverManagerImpl failoverMngr;
    protected FailoverManagerImpl.CallHistoryEntry headSameProxy = null;
    protected FailoverManagerImpl.CallHistoryEntry tailSameProxy = null;
    protected FailoverManagerImpl.CallHistoryEntry replayingCallEntry = null;
    protected SQLRecoverableException originalError = null;
    protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE1 = 603;
    protected static final int SVR_TXN_IN_REPLAY_ERROR_CODE2 = 29791;
    protected boolean isClosedAndNoReplay = false;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.failoverMngr.record(this, m4, args, "started");
                break;
            }
        }
    }

    @Post
    protected void postForAll(Method m4) {
        this.postForAll(m4, null);
    }

    @Post
    protected Object postForAll(Method m4, Object result) {
        if (result instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecording(m4, result, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplaying(m4, result, null);
            }
        }
        return result;
    }

    protected void doPostWhenRecording(Method m4, Object result, SQLException sqlexc) {
        long checksum = 0L;
        long SCN = -1L;
        this.failoverMngr.update(this, null, result, "completed", 0L, -1L, sqlexc);
    }

    protected void doPostWhenReplaying(Method m4, Object result, SQLException sqlexc) {
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        this.onErrorForAll(m4, error);
    }

    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw error;
        }
        if (error instanceof SQLRecoverableException) {
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: {
                    return this.failoverMngr.replayAll((SQLRecoverableException)error);
                }
            }
            throw error;
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecording(m4, null, error);
                break;
            }
        }
        throw error;
    }

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry entry) throws SQLException {
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) throws SQLException {
        Object result = null;
        try {
            FailoverManagerImpl.ReplayLifecycle _lifecycle;
            Object newResult;
            ((Replayable)entry.jdbcProxy).setReplayingCallContext(entry, origError);
            result = newResult = entry.method.invoke(entry.jdbcProxy, entry.args);
            if (newResult instanceof NonTxnReplayableBase && (_lifecycle = this.failoverMngr.getReplayLifecycle()) == FailoverManagerImpl.ReplayLifecycle.REPLAYING && newResult != null && entry.result != null) {
                Object newDelegate = ((NonTxnReplayableBase)newResult).getDelegate();
                ((NonTxnReplayableBase)entry.result).setDelegate(newDelegate);
                result = entry.result;
            }
        }
        catch (InvocationTargetException targetException) {
            Throwable throwable = targetException.getCause();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBase", "replayOneCall", "On {0}, replaying {1} got InvocationTargetException with cause: {2}", (String)null, (Throwable)null, new Object[]{entry.jdbcProxy, entry.method, throwable});
            if (throwable instanceof SQLRecoverableException) {
                SQLRecoverableException sqlrexc = (SQLRecoverableException)throwable;
                throw sqlrexc;
            }
            if (throwable instanceof SQLException) {
                SQLException sqlexc = (SQLException)throwable;
                int errCode = sqlexc.getErrorCode();
                if (errCode == 29791) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBase", "replayOneCall", "On {0}, replaying {1} receives ORA-29791", (String)null, (Throwable)null, new Object[]{entry.jdbcProxy, entry.method});
                    this.failoverMngr.disableReplayAndThrowException(entry.method, 390, "Replay failed because of active transaction during replay", origError);
                } else if (entry.callException == null || errCode != entry.callException.getErrorCode()) {
                    this.failoverMngr.disableReplayAndThrowException(entry.method, 389, "Replay failed because of error code or message mismatch", origError);
                }
            } else {
                this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", origError);
            }
        }
        catch (Throwable otherThrowable) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBase", "replayOneCall", "On {0}, replaying {1} caught throwable: {2}", (String)null, (Throwable)null, new Object[]{entry.jdbcProxy, entry.method, otherThrowable});
            otherThrowable.printStackTrace();
            this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", origError);
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case INTERNALLY_FAILED: 
            case INTERNALLY_DISABLED: {
                this.failoverMngr.throwReplayExceptionInternal(0, null, null);
            }
        }
        return result;
    }

    @Override
    public void addToSameProxyList(FailoverManagerImpl.CallHistoryEntry entry) {
        entry.prevEntrySameProxy = this.tailSameProxy;
        entry.nextEntrySameProxy = null;
        if (this.tailSameProxy != null) {
            this.tailSameProxy.nextEntrySameProxy = entry;
        }
        this.tailSameProxy = entry;
        if (this.headSameProxy == null) {
            this.headSameProxy = entry;
        }
    }

    @Override
    public void removeFromSameProxyList(FailoverManagerImpl.CallHistoryEntry entry) {
        if (entry.nextEntrySameProxy != null) {
            entry.nextEntrySameProxy.prevEntrySameProxy = entry.prevEntrySameProxy;
        }
        if (entry.prevEntrySameProxy != null) {
            entry.prevEntrySameProxy.nextEntrySameProxy = entry.nextEntrySameProxy;
        }
        if (this.headSameProxy == entry) {
            this.headSameProxy = entry.nextEntrySameProxy;
        }
        if (this.tailSameProxy == entry) {
            this.tailSameProxy = entry.prevEntrySameProxy;
        }
    }

    @Override
    public void purgeSameProxyList() {
        if (this.failoverMngr != null) {
            HashSet<Object> visitedProxies = new HashSet<Object>();
            for (Object ancestor = this; ancestor != null && ancestor instanceof NonTxnReplayableBase && !(ancestor instanceof ReplayableConnection); ancestor = ((NonTxnReplayableBase)ancestor).getCreator()) {
                visitedProxies.add(ancestor);
            }
            this.failoverMngr.purgeForSameProxy(visitedProxies, this.headSameProxy);
        }
    }

    @Override
    public void setReplayingCallContext(FailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) {
        this.replayingCallEntry = entry;
        this.originalError = origError;
    }

    @Override
    public void setFailoverManager(FailoverManagerImpl mngr) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.failoverMngr = mngr;
        }
    }

    @Override
    public FailoverManagerImpl getFailoverManager() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            FailoverManagerImpl failoverManagerImpl = this.failoverMngr;
            return failoverManagerImpl;
        }
    }

    private boolean isReplayFailure(Throwable t2) {
        int errCode;
        boolean result = false;
        if (t2 instanceof SQLException && (errCode = ((SQLException)t2).getErrorCode()) >= 370 && errCode < 400) {
            result = true;
        }
        return result;
    }

    protected boolean assertThrowablesMatch(Throwable currentT, Throwable originalT) {
        boolean doThrowablesMatch;
        boolean areSameType = originalT == null ? false : currentT.getClass().getName().equals(originalT.getClass().getName());
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBase", "assertThrowablesMatch", "Errors at original execution and replay are of same type: {0}", (String)null, (Throwable)null, (Object)areSameType);
        if (currentT instanceof SQLException && areSameType) {
            doThrowablesMatch = ((SQLException)currentT).getErrorCode() == ((SQLException)originalT).getErrorCode();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBase", "assertThrowablesMatch", "Errors at original execution and replay are SQLException, error codes match: {0}", (String)null, (Throwable)null, (Object)doThrowablesMatch);
        } else if (areSameType) {
            String currentMesg = currentT.getMessage();
            String originalMesg = originalT.getMessage();
            doThrowablesMatch = currentMesg == null && originalMesg == null || currentMesg != null && originalMesg != null && currentT.getMessage().equals(originalT.getMessage());
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBase", "assertThrowablesMatch", "Errors at original execution and replay are same type but not SQLException, error messages match: {0}", (String)null, (Throwable)null, (Object)doThrowablesMatch);
        } else {
            doThrowablesMatch = false;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBase", "assertThrowablesMatch", "Errors at original execution and replay match: {0}", (String)null, (Throwable)null, (Object)doThrowablesMatch);
        return doThrowablesMatch;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

