/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.Datum;

public class BINARY_DOUBLE
extends Datum {
    static final long serialVersionUID = 6718338151847341754L;

    public BINARY_DOUBLE() {
    }

    public BINARY_DOUBLE(byte[] _bytes) {
        super(_bytes);
    }

    public BINARY_DOUBLE(double d) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(d));
    }

    public BINARY_DOUBLE(Double d) {
        super(BINARY_DOUBLE.doubleToCanonicalFormatBytes(d));
    }

    public BINARY_DOUBLE(String s2) throws SQLException {
        this(BINARY_DOUBLE.stringToDouble(s2));
    }

    public BINARY_DOUBLE(Boolean b) {
        this(b != false ? 1 : 0);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return new Double(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.lang.String") == 0 || class_name.compareTo("java.lang.Double") == 0;
    }

    @Override
    public String stringValue() {
        String ret = Double.toString(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
        return ret;
    }

    @Override
    public double doubleValue() throws SQLException {
        return BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes());
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(BINARY_DOUBLE.canonicalFormatBytesToDouble(this.getBytes()));
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new Double[arraySize];
    }

    private static double stringToDouble(String s2) throws SQLException {
        try {
            return Double.valueOf(s2);
        }
        catch (NumberFormatException ex) {
            throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
        }
    }

    static byte[] doubleToCanonicalFormatBytes(double _d) {
        double d = _d;
        if (d == 0.0) {
            d = 0.0;
        } else if (d != d) {
            d = Double.NaN;
        }
        long longBits = Double.doubleToLongBits(d);
        byte[] b = new byte[8];
        int lowInt = (int)longBits;
        int highInt = (int)(longBits >> 32);
        int b7 = lowInt;
        int b6 = lowInt >>= 8;
        int b5 = lowInt >>= 8;
        int b4 = lowInt >>= 8;
        int b3 = highInt;
        int b2 = highInt >>= 8;
        int b1 = highInt >>= 8;
        int b0 = highInt >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
            b4 ^= 0xFFFFFFFF;
            b5 ^= 0xFFFFFFFF;
            b6 ^= 0xFFFFFFFF;
            b7 ^= 0xFFFFFFFF;
        }
        b[7] = (byte)b7;
        b[6] = (byte)b6;
        b[5] = (byte)b5;
        b[4] = (byte)b4;
        b[3] = (byte)b3;
        b[2] = (byte)b2;
        b[1] = (byte)b1;
        b[0] = (byte)b0;
        return b;
    }

    static double canonicalFormatBytesToDouble(byte[] b) {
        int b0 = b[0];
        int b1 = b[1];
        int b2 = b[2];
        int b3 = b[3];
        int b4 = b[4];
        int b5 = b[5];
        int b6 = b[6];
        int b7 = b[7];
        if ((b0 & 0x80) != 0) {
            b0 &= 0x7F;
            b1 &= 0xFF;
            b2 &= 0xFF;
            b3 &= 0xFF;
            b4 &= 0xFF;
            b5 &= 0xFF;
            b6 &= 0xFF;
            b7 &= 0xFF;
        } else {
            b0 = ~b0 & 0xFF;
            b1 = ~b1 & 0xFF;
            b2 = ~b2 & 0xFF;
            b3 = ~b3 & 0xFF;
            b4 = ~b4 & 0xFF;
            b5 = ~b5 & 0xFF;
            b6 = ~b6 & 0xFF;
            b7 = ~b7 & 0xFF;
        }
        int hiBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        int loBits = b4 << 24 | b5 << 16 | b6 << 8 | b7;
        long longBits = (long)hiBits << 32 | (long)loBits & 0xFFFFFFFFL;
        return Double.longBitsToDouble(longBits);
    }
}

