/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import com.google.common.primitives.SignedBytes;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.util.ChunkedArrayList;

public class SnapshotDiffReportGenerator {
    public static final Comparator<SnapshotDiffReportListing.DiffReportListingEntry> INODE_COMPARATOR = new Comparator<SnapshotDiffReportListing.DiffReportListingEntry>(){

        @Override
        public int compare(SnapshotDiffReportListing.DiffReportListingEntry left, SnapshotDiffReportListing.DiffReportListingEntry right) {
            Comparator<byte[]> cmp = SignedBytes.lexicographicalComparator();
            byte[][] l = left.getSourcePath();
            byte[][] r = right.getSourcePath();
            if (l.length == 1 && l[0] == null) {
                return -1;
            }
            if (r.length == 1 && r[0] == null) {
                return 1;
            }
            for (int i = 0; i < l.length && i < r.length; ++i) {
                int diff = cmp.compare(l[i], r[i]);
                if (diff == 0) continue;
                return diff;
            }
            return l.length == r.length ? 0 : (l.length > r.length ? 1 : -1);
        }
    };
    private final String snapshotRoot;
    private final String fromSnapshot;
    private final String toSnapshot;
    private final boolean isFromEarlier;
    private final Map<Long, ChildrenDiff> dirDiffMap = new HashMap<Long, ChildrenDiff>();
    private final Map<Long, RenameEntry> renameMap = new HashMap<Long, RenameEntry>();
    private List<SnapshotDiffReportListing.DiffReportListingEntry> mlist = null;
    private List<SnapshotDiffReportListing.DiffReportListingEntry> clist = null;
    private List<SnapshotDiffReportListing.DiffReportListingEntry> dlist = null;

    public SnapshotDiffReportGenerator(String snapshotRoot, String fromSnapshot, String toSnapshot, boolean isFromEarlier, List<SnapshotDiffReportListing.DiffReportListingEntry> mlist, List<SnapshotDiffReportListing.DiffReportListingEntry> clist, List<SnapshotDiffReportListing.DiffReportListingEntry> dlist) {
        this.snapshotRoot = snapshotRoot;
        this.fromSnapshot = fromSnapshot;
        this.toSnapshot = toSnapshot;
        this.isFromEarlier = isFromEarlier;
        this.mlist = mlist != null ? mlist : Collections.emptyList();
        this.clist = clist != null ? clist : Collections.emptyList();
        this.dlist = dlist != null ? dlist : Collections.emptyList();
    }

    private RenameEntry getEntry(long inodeId) {
        RenameEntry entry = this.renameMap.get(inodeId);
        if (entry == null) {
            entry = new RenameEntry();
            this.renameMap.put(inodeId, entry);
        }
        return entry;
    }

    public void generateReportList() {
        RenameEntry renameEntry;
        ChildrenDiff entry;
        this.mlist.sort(INODE_COMPARATOR);
        for (SnapshotDiffReportListing.DiffReportListingEntry created : this.clist) {
            entry = this.dirDiffMap.get(created.getDirId());
            if (entry == null) {
                ChunkedArrayList createdList = new ChunkedArrayList();
                createdList.add(created);
                ChildrenDiff list = new ChildrenDiff((List<SnapshotDiffReportListing.DiffReportListingEntry>)createdList, null);
                this.dirDiffMap.put(created.getDirId(), list);
            } else {
                this.dirDiffMap.get(created.getDirId()).getCreatedList().add(created);
            }
            if (!created.isReference() || (renameEntry = this.getEntry(created.getFileId())).getTargetPath() == null) continue;
            renameEntry.setTarget(created.getSourcePath());
        }
        for (SnapshotDiffReportListing.DiffReportListingEntry deleted : this.dlist) {
            entry = this.dirDiffMap.get(deleted.getDirId());
            if (entry == null || entry.getDeletedList().isEmpty()) {
                ChunkedArrayList deletedList = new ChunkedArrayList();
                deletedList.add(deleted);
                ChildrenDiff list = entry == null ? new ChildrenDiff(null, (List<SnapshotDiffReportListing.DiffReportListingEntry>)deletedList) : new ChildrenDiff(entry.getCreatedList(), (List<SnapshotDiffReportListing.DiffReportListingEntry>)deletedList);
                this.dirDiffMap.put(deleted.getDirId(), list);
            } else {
                entry.getDeletedList().add(deleted);
            }
            if (!deleted.isReference()) continue;
            renameEntry = this.getEntry(deleted.getFileId());
            renameEntry.setTarget(deleted.getTargetPath());
            renameEntry.setSource(deleted.getSourcePath());
        }
    }

    public SnapshotDiffReport generateReport() {
        ChunkedArrayList diffReportList = new ChunkedArrayList();
        this.generateReportList();
        for (SnapshotDiffReportListing.DiffReportListingEntry modified : this.mlist) {
            diffReportList.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, modified.getSourcePath(), (byte[][])null));
            if (!modified.isReference() || this.dirDiffMap.get(modified.getDirId()) == null) continue;
            List<SnapshotDiffReport.DiffReportEntry> subList = this.generateReport(modified);
            diffReportList.addAll(subList);
        }
        return new SnapshotDiffReport(this.snapshotRoot, this.fromSnapshot, this.toSnapshot, (List<SnapshotDiffReport.DiffReportEntry>)diffReportList);
    }

    private List<SnapshotDiffReport.DiffReportEntry> generateReport(SnapshotDiffReportListing.DiffReportListingEntry modified) {
        RenameEntry entry;
        ChunkedArrayList diffReportList = new ChunkedArrayList();
        ChildrenDiff list = this.dirDiffMap.get(modified.getDirId());
        for (SnapshotDiffReportListing.DiffReportListingEntry created : list.getCreatedList()) {
            entry = this.renameMap.get(created.getFileId());
            if (entry != null && entry.isRename()) continue;
            diffReportList.add(new SnapshotDiffReport.DiffReportEntry(this.isFromEarlier ? SnapshotDiffReport.DiffType.CREATE : SnapshotDiffReport.DiffType.DELETE, created.getSourcePath()));
        }
        for (SnapshotDiffReportListing.DiffReportListingEntry deleted : list.getDeletedList()) {
            entry = this.renameMap.get(deleted.getFileId());
            if (entry != null && entry.isRename()) {
                diffReportList.add(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, this.isFromEarlier ? entry.getSourcePath() : entry.getTargetPath(), this.isFromEarlier ? entry.getTargetPath() : entry.getSourcePath()));
                continue;
            }
            diffReportList.add(new SnapshotDiffReport.DiffReportEntry(this.isFromEarlier ? SnapshotDiffReport.DiffType.DELETE : SnapshotDiffReport.DiffType.CREATE, deleted.getSourcePath()));
        }
        return diffReportList;
    }

    static class ChildrenDiff {
        private final List<SnapshotDiffReportListing.DiffReportListingEntry> createdList;
        private final List<SnapshotDiffReportListing.DiffReportListingEntry> deletedList;

        ChildrenDiff(List<SnapshotDiffReportListing.DiffReportListingEntry> createdList, List<SnapshotDiffReportListing.DiffReportListingEntry> deletedList) {
            this.createdList = createdList != null ? createdList : Collections.emptyList();
            this.deletedList = deletedList != null ? deletedList : Collections.emptyList();
        }

        public List<SnapshotDiffReportListing.DiffReportListingEntry> getCreatedList() {
            return this.createdList;
        }

        public List<SnapshotDiffReportListing.DiffReportListingEntry> getDeletedList() {
            return this.deletedList;
        }
    }

    static class RenameEntry {
        private byte[][] sourcePath;
        private byte[][] targetPath;

        RenameEntry() {
        }

        void setSource(byte[][] srcPath) {
            this.sourcePath = srcPath;
        }

        void setTarget(byte[][] target) {
            this.targetPath = target;
        }

        boolean isRename() {
            return this.sourcePath != null && this.targetPath != null;
        }

        byte[][] getSourcePath() {
            return this.sourcePath;
        }

        byte[][] getTargetPath() {
            return this.targetPath;
        }
    }
}

