/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.configuration.configurators.AbstractXMLConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.deployers.ServerDeploymentInterface;
import org.jahia.configuration.logging.AbstractLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;

public class JBossConfigurator
extends AbstractXMLConfigurator {
    private static final String BACKGROUND_VALIDATION_MILLIS = "600000";
    private static final Namespace DS_NS_62 = Namespace.getNamespace("urn:jboss:domain:datasources:1.1");
    private static final Namespace DS_NS_63 = Namespace.getNamespace("urn:jboss:domain:datasources:1.2");
    private static final Map<String, String> EXCEPTION_SORTERS;
    private static final String IDLE_TIMEOUT_MINUTES = "30";
    private static final String MAX_POOL_SIZE = "200";
    private static final String MIN_POOL_SIZE = "10";
    private static final Namespace WEB_NS_62;
    private static final Namespace WEB_NS_63;
    private static final Namespace WEB_NS_64;
    private String dbType;
    private ServerDeploymentInterface deployer;
    private boolean isJBoss63;
    private boolean isJBoss64;
    private Namespace webNs;

    public JBossConfigurator(Map<?, ?> dbProperties, JahiaConfigInterface jahiaConfigInterface, ServerDeploymentInterface deployer, AbstractLogger logger) {
        super(dbProperties, jahiaConfigInterface, logger);
        this.dbType = jahiaConfigInterface.getDatabaseType();
        this.deployer = deployer;
    }

    private void configureConnector(Element profile) {
        Namespace ns = WEB_NS_62;
        Element web = profile.getChild("subsystem", ns);
        if (web == null) {
            ns = WEB_NS_63;
            web = profile.getChild("subsystem", ns);
        }
        if (web == null) {
            ns = WEB_NS_64;
            web = profile.getChild("subsystem", ns);
        }
        if (web != null) {
            for (Element child : web.getChildren("connector", ns)) {
                Element connector = child;
                Attribute name = connector.getAttribute("name");
                if (name == null || !"http".equals(name.getValue())) continue;
                connector.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
            }
        }
    }

    private void configureDatasource(Element datasources) throws JDOMException {
        Element ds = this.getElement(datasources, "//datasource[@jndi-name=\"java:/jahiaDS\"]", null);
        if (ds == null) {
            ds = new Element("datasource").setAttribute("jndi-name", "java:/jahiaDS").setAttribute("pool-name", "jahiaDS").setAttribute("enabled", "true").setAttribute("use-java-context", "true");
            datasources.addContent(0, ds);
        }
        this.getChildCreate(ds, "connection-url").setText(JBossConfigurator.getValue(this.dbProperties, "jahia.database.url"));
        this.getChildCreate(ds, "driver").setText("jahia." + this.dbType);
        Element pool = this.getChildCreate(ds, "pool");
        this.getChildCreate(pool, "min-pool-size").setText(MIN_POOL_SIZE);
        this.getChildCreate(pool, "max-pool-size").setText(MAX_POOL_SIZE);
        Element security = this.getChildCreate(ds, "security");
        this.getChildCreate(security, "user-name").setText(JBossConfigurator.getValue(this.dbProperties, "jahia.database.user"));
        this.getChildCreate(security, "password").setText(JBossConfigurator.getValue(this.dbProperties, "jahia.database.pass"));
        Element validation = this.getChildCreate(ds, "validation");
        this.getChildCreate(validation, "valid-connection-checker").setAttribute("class-name", "org.jboss.jca.adapters.jdbc.extensions.novendor.JDBC4ValidConnectionChecker");
        this.getChildCreate(validation, "validate-on-match").setText("false");
        this.getChildCreate(validation, "background-validation").setText("true");
        this.getChildCreate(validation, "background-validation-millis").setText(BACKGROUND_VALIDATION_MILLIS);
        this.getChildCreate(validation, "exception-sorter").setAttribute("class-name", EXCEPTION_SORTERS.get(this.dbType));
        this.getChildCreate(this.getChildCreate(ds, "timeout"), "idle-timeout-minutes").setText(IDLE_TIMEOUT_MINUTES);
    }

    private void configureDriver(Element datasources) throws JDOMException {
        Element drivers = this.getChildCreate(datasources, "drivers");
        Element driver = this.getElement(drivers, "driver[@name='jahia." + this.dbType + "']", null);
        if (driver == null) {
            driver = new Element("driver").setAttribute("name", "jahia." + this.dbType).setAttribute("module", "org.jahia.jdbc." + this.dbType);
            Element driverClazz = new Element("driver-class");
            driverClazz.addContent(this.getDBProperty("jahia.database.driver"));
            driver.addContent(driverClazz);
            drivers.addContent(driver);
        }
    }

    private void disableDefaultWelcomeWebApp(Element profile) {
        Element virtualServer;
        Element web = profile.getChild("subsystem", this.webNs);
        if (web != null && (virtualServer = web.getChild("virtual-server", this.webNs)) != null) {
            virtualServer.setAttribute("enable-welcome-root", "false");
        }
    }

    private Element getChildCreate(Element parent, String childName) {
        Element child = parent.getChild(childName);
        if (child == null) {
            child = new Element(childName);
            parent.addContent(child);
        }
        return child;
    }

    private String getDbPropForCLI(String prop) {
        return StringUtils.replace(JBossConfigurator.getValue(this.dbProperties, prop), "=", "\\=");
    }

    private Element getProfile(Element root, ConfigFile sourceConfigFile) {
        Element profile = root.getChild("profile", root.getNamespace());
        if (profile == null) {
            throw new IllegalArgumentException("Cannot find <profile> element in the file" + sourceConfigFile);
        }
        return profile;
    }

    private boolean isRootContext() {
        String moduleList = this.jahiaConfigInterface.getJeeApplicationModuleList();
        if (moduleList == null || moduleList.length() == 0) {
            return true;
        }
        boolean isRoot = false;
        for (String moduleConfig : moduleList.split(",")) {
            if (!moduleConfig.contains("jahia.war")) continue;
            String[] moduleParams = moduleConfig.split(":");
            isRoot = moduleParams.length < 4 || StringUtils.isEmpty(moduleParams[3]);
            break;
        }
        return isRoot;
    }

    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        this.getLogger().info("Processing file " + sourceConfigFile.getURI());
        Writer out = null;
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            InputStreamReader fileReader = new InputStreamReader(sourceConfigFile.getInputStream());
            Document jdomDocument = saxBuilder.build(fileReader);
            Element root = jdomDocument.getRootElement();
            this.isJBoss63 = root.getNamespace().getURI().equals("urn:jboss:domain:1.6");
            this.isJBoss64 = root.getNamespace().getURI().equals("urn:jboss:domain:1.7");
            if (this.isJBoss63) {
                this.getLogger().info("Detected JBoss EAP version 6.3.x");
            } else {
                this.getLogger().info("Detected JBoss EAP version " + (this.isJBoss64 ? "6.4.x" : "6.2.x"));
            }
            this.webNs = this.isJBoss63 ? WEB_NS_63 : (this.isJBoss64 ? WEB_NS_64 : WEB_NS_62);
            Element profile = this.getProfile(root, sourceConfigFile);
            Element datasources = this.getChildCreate(this.getChildCreate(profile, "subsystem"), "datasources");
            this.configureDriver(datasources);
            this.configureDatasource(datasources);
            if (this.jahiaConfigInterface.getWebAppDirName().equals("ROOT")) {
                this.disableDefaultWelcomeWebApp(profile);
            }
            this.configureConnector(profile);
            this.getLogger().info("Writing output to " + destFileName);
            this.write(jdomDocument, new File(destFileName), Format.getPrettyFormat().setIndent("    ").setLineSeparator(System.getProperty("line.separator")));
        }
        catch (JDOMException jdome) {
            throw new Exception("Error while updating configuration file " + sourceConfigFile, jdome);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public void updateDriverModule() throws IOException {
        if (this.deployer == null) {
            this.getLogger().info("No deployer provided. Skipping driver module update.");
            return;
        }
        this.getLogger().info("Updating driver module");
        File targetDir = new File(this.jahiaConfigInterface.getTargetServerDirectory(), "modules/org/jahia/jdbc/" + this.dbType + "/main");
        if (!targetDir.isDirectory()) {
            this.getLogger().info("Target driver module directory " + targetDir + " cannot be found. Skipping driver module update.");
            return;
        }
        File moduleXml = new File(targetDir, "module.xml");
        if (moduleXml.isFile()) {
            this.getLogger().info(moduleXml + " is already present. Skipping driver module update.");
            return;
        }
        for (File driver : FileUtils.listFiles(targetDir, new String[]{"jar"}, false)) {
            this.getLogger().info("Deploying JDBC driver " + driver);
            this.deployer.deployJdbcDriver(driver);
        }
    }

    public void writeCLIConfiguration(File dest, String profile) throws Exception {
        Object profilePath = profile != null ? "/profile=" + profile : "";
        StringBuilder cli = new StringBuilder(512);
        cli.append("connect\n");
        cli.append("\n");
        cli.append((String)profilePath);
        cli.append("/subsystem=datasources/jdbc-driver=jahia.");
        cli.append(this.dbType);
        cli.append(":add(driver-module-name=org.jahia.jdbc.");
        cli.append(this.dbType);
        cli.append(", driver-name=jahia.");
        cli.append(this.dbType);
        cli.append(", driver-class-name=");
        cli.append(this.getDbPropForCLI("jahia.database.driver"));
        cli.append(")\n");
        cli.append("\n");
        cli.append("data-source add");
        if (profile != null) {
            cli.append(" --profile=").append(profile);
        }
        cli.append(" --name=jahiaDS --jndi-name=java:/jahiaDS --enabled=true --use-java-context=true \\\n");
        cli.append("--driver-name=jahia.").append(this.dbType).append(" \\\n");
        cli.append("--connection-url=\"").append(this.getDbPropForCLI("jahia.database.url")).append("\" \\\n");
        String v = this.getDbPropForCLI("jahia.database.user");
        if (v != null && v.length() > 0) {
            cli.append("--user-name=\"").append(v).append("\" \\\n");
        }
        if ((v = this.getDbPropForCLI("jahia.database.pass")) != null && v.length() > 0) {
            cli.append("--password=\"").append(v).append("\" \\\n");
        }
        cli.append("--min-pool-size=10 \\\n");
        cli.append("--max-pool-size=200 \\\n");
        cli.append("--validate-on-match=false \\\n");
        cli.append("--background-validation=true \\\n");
        cli.append("--background-validation-millis=600000 \\\n");
        cli.append("--valid-connection-checker-class-name=org.jboss.jca.adapters.jdbc.extensions.novendor.JDBC4ValidConnectionChecker \\\n");
        cli.append("--exception-sorter-class-name=").append(EXCEPTION_SORTERS.get(this.dbType)).append(" \\\n");
        cli.append("--idle-timeout-minutes=30\n");
        cli.append("\n");
        if (this.isRootContext()) {
            cli.append((String)profilePath);
            cli.append("/subsystem=web/virtual-server=default-host:write-attribute(name=enable-welcome-root,value=false)\n");
            cli.append("\n");
        }
        cli.append((String)profilePath);
        cli.append("/subsystem=web/connector=http:write-attribute(name=protocol,value=org.apache.coyote.http11.Http11NioProtocol)\n\n");
        if (profile == null) {
            cli.append("reload\n");
        }
        this.getLogger().info("Writing output to " + dest);
        FileUtils.writeStringToFile(dest, cli.toString(), StandardCharsets.UTF_8);
    }

    static {
        WEB_NS_62 = Namespace.getNamespace("urn:jboss:domain:web:1.5");
        WEB_NS_63 = Namespace.getNamespace("urn:jboss:domain:web:2.1");
        WEB_NS_64 = Namespace.getNamespace("urn:jboss:domain:web:2.2");
        EXCEPTION_SORTERS = new HashMap<String, String>(6);
        EXCEPTION_SORTERS.put("derby", "org.jboss.jca.adapters.jdbc.extensions.novendor.NullExceptionSorter");
        EXCEPTION_SORTERS.put("derby_embedded", "org.jboss.jca.adapters.jdbc.extensions.novendor.NullExceptionSorter");
        EXCEPTION_SORTERS.put("mariadb", "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLExceptionSorter");
        EXCEPTION_SORTERS.put("mssql", "org.jboss.jca.adapters.jdbc.extensions.mssql.MSSQLValidConnectionChecker");
        EXCEPTION_SORTERS.put("mysql", "org.jboss.jca.adapters.jdbc.extensions.mysql.MySQLExceptionSorter");
        EXCEPTION_SORTERS.put("oracle", "org.jboss.jca.adapters.jdbc.extensions.oracle.OracleExceptionSorter");
        EXCEPTION_SORTERS.put("postgresql", "org.jboss.jca.adapters.jdbc.extensions.postgres.PostgreSQLExceptionSorter");
    }
}

