/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.commons.encryption.EncryptionUtils;
import org.jahia.configuration.configurators.AbstractConfigurator;
import org.jahia.configuration.configurators.ApplicationXmlConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.DatabaseConnection;
import org.jahia.configuration.configurators.DatabaseScripts;
import org.jahia.configuration.configurators.JBossConfigurator;
import org.jahia.configuration.configurators.JackrabbitConfigurator;
import org.jahia.configuration.configurators.JahiaConfigBean;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.configurators.JahiaNodePropertiesConfigurator;
import org.jahia.configuration.configurators.JahiaPropertiesConfigurator;
import org.jahia.configuration.configurators.LDAPConfigurator;
import org.jahia.configuration.configurators.MailServerConfigurator;
import org.jahia.configuration.configurators.RootUserConfigurator;
import org.jahia.configuration.configurators.TomcatContextXmlConfigurator;
import org.jahia.configuration.configurators.VFSConfigFile;
import org.jahia.configuration.deployers.ServerDeploymentFactory;
import org.jahia.configuration.deployers.ServerDeploymentInterface;
import org.jahia.configuration.logging.AbstractLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class JahiaGlobalConfigurator {
    private static final ConvertUtilsBean CONVERTER_UTILS_BEAN = new ConvertUtilsBean();
    public static final String DB_SCRIPT = "db_script";
    public static final String DERBY = "derby";
    public static final String DERBY_EMBEDDED = "derby_embedded";
    public static final String MYSQL = "mysql";
    public static final String MARIADB = "mariadb";
    public static final String POSTGRESQL = "postgresql";
    public static final String JAHIA_DATABASE_DRIVER = "jahia.database.driver";
    public static final String IF_NECESSARY = "if-necessary";
    JahiaConfigInterface jahiaConfig;
    DatabaseConnection db;
    File webappDir;
    Properties dbProps;
    File databaseScript;
    List<AbstractConfigurator> configurators = new ArrayList<AbstractConfigurator>();
    String externalizedConfigTempPath = null;
    File jahiaConfigDir;
    AbstractLogger logger;
    private ServerDeploymentInterface deployer;
    private File dataDir;

    public static Map<String, String> fromJSON(String json) {
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            JSONObject obj = new JSONObject((String)(json.contains("{") ? StringUtils.replace(json, "\\", "\\\\") : "{" + StringUtils.replace(json, "\\", "\\\\") + "}"));
            Iterator<String> iterator = obj.keys();
            while (iterator.hasNext()) {
                String key = iterator.next();
                values.put(key, obj.getString(key));
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return values;
    }

    public static List<String> fromString(String value) {
        LinkedList<String> valueList = new LinkedList<String>();
        if (value != null && value.length() > 0) {
            for (String singleValue : StringUtils.split(value, " ,;:")) {
                valueList.add(singleValue.trim());
            }
        }
        return valueList;
    }

    public static File resolveDataDir(String dataDirPath, String targetWebappDirPath) {
        return JahiaGlobalConfigurator.resolveDataDir(dataDirPath, targetWebappDirPath, true);
    }

    public static File resolveDataDir(String dataDirPath, String targetWebappDirPath, boolean doCreate) {
        File dataDir = null;
        if (dataDirPath.indexOf(36) != -1) {
            HashMap<String, String> sysProps = new HashMap<String, String>();
            String webappPath = targetWebappDirPath;
            sysProps.put("jahiaWebAppRoot", webappPath);
            if (dataDirPath.contains("$context")) {
                sysProps.put("context", webappPath);
            }
            for (Map.Entry<Object, Object> el : System.getProperties().entrySet()) {
                sysProps.put(String.valueOf(el.getKey()), String.valueOf(el.getValue()));
            }
            dataDirPath = StringUtils.interpolate(dataDirPath, sysProps);
        }
        try {
            dataDir = new File(dataDirPath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (doCreate && !dataDir.exists() && !dataDir.mkdirs()) {
            throw new RuntimeException("Unable to create target directory: " + dataDir);
        }
        return dataDir;
    }

    public JahiaGlobalConfigurator(AbstractLogger logger, JahiaConfigInterface jahiaConfig) {
        this.jahiaConfig = jahiaConfig;
        this.logger = logger;
    }

    public AbstractLogger getLogger() {
        return this.logger;
    }

    public void execute() throws Exception {
        if (this.jahiaConfig.isExternalizedConfigActivated() && !StringUtils.isBlank(this.jahiaConfig.getExternalizedConfigTargetPath())) {
            File tempDirectory = FileUtils.getTempDirectory();
            this.jahiaConfigDir = new File(tempDirectory, "jahia-config");
            File jahiaConfigConfigDir = new File(this.jahiaConfigDir, "jahia");
            jahiaConfigConfigDir.mkdirs();
            this.externalizedConfigTempPath = jahiaConfigConfigDir.getPath();
        }
        this.db = new DatabaseConnection(this.logger);
        this.getLogger().info("Configuring for server " + this.jahiaConfig.getTargetServerType() + (String)(StringUtils.isNotEmpty(this.jahiaConfig.getTargetServerVersion()) ? " version " + this.jahiaConfig.getTargetServerVersion() : "") + " with database type " + this.jahiaConfig.getDatabaseType());
        try {
            this.setProperties();
        }
        finally {
            VFSConfigFile.closeAllOpened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigurationFiles(String sourceWebAppPath, String webappPath, Properties dbProps, JahiaConfigInterface jahiaConfigInterface) throws Exception {
        boolean jeeLocationSpecified;
        String mailServerTemplate;
        this.getLogger().info("Configuring file using source " + sourceWebAppPath + " to target " + webappPath);
        FileSystemManager fsManager = VFS.getManager();
        new JackrabbitConfigurator(dbProps, jahiaConfigInterface, this.getLogger()).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath + "/WEB-INF/etc/repository/jackrabbit/repository.xml"), webappPath + "/WEB-INF/etc/repository/jackrabbit/repository.xml");
        new TomcatContextXmlConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath + "/META-INF/context.xml"), webappPath + "/META-INF/context.xml");
        String rootUserTemplate = sourceWebAppPath + "/WEB-INF/etc/repository/template-root-user.xml";
        FileObject rootUserTemplateFile = fsManager.resolveFile(rootUserTemplate);
        if (rootUserTemplateFile.exists()) {
            if (Boolean.parseBoolean(jahiaConfigInterface.getProcessingServer())) {
                new RootUserConfigurator((Map)dbProps, jahiaConfigInterface, JahiaGlobalConfigurator.encryptPassword(jahiaConfigInterface.getJahiaRootPassword())).updateConfiguration(new VFSConfigFile(fsManager, rootUserTemplate), webappPath + "/WEB-INF/etc/repository/root-user.xml");
            }
        } else {
            new RootUserConfigurator((Map)dbProps, jahiaConfigInterface, JahiaGlobalConfigurator.encryptPassword(jahiaConfigInterface.getJahiaRootPassword())).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath + "/WEB-INF/etc/repository/root.xml"), webappPath + "/WEB-INF/etc/repository/root.xml");
        }
        if (fsManager.resolveFile(mailServerTemplate = sourceWebAppPath + "/WEB-INF/etc/repository/template-root-mail-server.xml").exists() && Boolean.parseBoolean(jahiaConfigInterface.getProcessingServer())) {
            new MailServerConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(new VFSConfigFile(fsManager, mailServerTemplate), webappPath + "/WEB-INF/etc/repository/root-mail-server.xml");
        }
        if ("jboss".equalsIgnoreCase(jahiaConfigInterface.getTargetServerType())) {
            this.updateForJBoss(dbProps, jahiaConfigInterface, fsManager);
        }
        Object targetConfigPath = webappPath + "/WEB-INF/etc/config";
        Object jahiaPropertiesFileName = "jahia.properties";
        Object jahiaNodePropertiesFileName = "jahia.node.properties";
        if (this.externalizedConfigTempPath != null) {
            targetConfigPath = this.externalizedConfigTempPath;
            if (!StringUtils.isBlank(jahiaConfigInterface.getExternalizedConfigClassifier())) {
                jahiaPropertiesFileName = "jahia." + jahiaConfigInterface.getExternalizedConfigClassifier() + ".properties";
                jahiaNodePropertiesFileName = "jahia.node." + jahiaConfigInterface.getExternalizedConfigClassifier() + ".properties";
            }
        }
        ConfigFile jahiaPropertiesConfigFile = this.readJahiaProperties(sourceWebAppPath, fsManager);
        new JahiaPropertiesConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(jahiaPropertiesConfigFile, (String)targetConfigPath + "/" + (String)jahiaPropertiesFileName);
        try {
            ConfigFile jahiaNodePropertiesConfigFile = this.readJahiaNodeProperties(sourceWebAppPath, fsManager);
            if (jahiaNodePropertiesConfigFile != null) {
                new JahiaNodePropertiesConfigurator(this.logger, jahiaConfigInterface).updateConfiguration(jahiaNodePropertiesConfigFile, (String)targetConfigPath + "/" + (String)jahiaNodePropertiesFileName);
            }
        }
        catch (FileSystemException jahiaNodePropertiesConfigFile) {
            // empty catch block
        }
        InputStream is = this.getClass().getResourceAsStream("/applicationcontext-custom.xml");
        FileOutputStream os = new FileOutputStream(new File((String)targetConfigPath, "applicationcontext-custom.xml"));
        try {
            IOUtils.copy(is, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
        String ldapTargetFile = new File(this.getDataDir(), "karaf/etc").getAbsolutePath();
        new LDAPConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath), ldapTargetFile);
        String jeeApplicationLocation = jahiaConfigInterface.getJeeApplicationLocation();
        boolean bl = jeeLocationSpecified = !StringUtils.isEmpty(jeeApplicationLocation);
        if (jeeLocationSpecified || this.getDeployer().isEarDeployment()) {
            String jeeApplicationModuleList;
            if (!jeeLocationSpecified) {
                jeeApplicationLocation = this.getDeployer().getDeploymentFilePath("digitalfactory", "ear").getAbsolutePath();
            }
            if (StringUtils.isEmpty(jeeApplicationModuleList = jahiaConfigInterface.getJeeApplicationModuleList())) {
                jeeApplicationModuleList = "ROOT".equals(jahiaConfigInterface.getWebAppDirName()) ? "jahia-war:web:jahia.war:" : "jahia-war:web:jahia.war:" + jahiaConfigInterface.getWebAppDirName();
            }
            new ApplicationXmlConfigurator(jahiaConfigInterface, jeeApplicationModuleList).updateConfiguration(new VFSConfigFile(fsManager, jeeApplicationLocation + "/META-INF/application.xml"), jeeApplicationLocation + "/META-INF/application.xml");
        }
    }

    private ConfigFile readJahiaNodeProperties(String sourceWebAppPath, FileSystemManager fsManager) throws FileSystemException {
        VFSConfigFile file = null;
        FileObject jahiaImplFileObject = this.findVFSFile(sourceWebAppPath + "/WEB-INF/lib", "jahia\\-impl\\-.*\\.jar");
        FileObject jahiaEEImplFileObject = this.findVFSFile(sourceWebAppPath + "/WEB-INF/lib", "jahia\\-ee\\-impl.*\\.jar");
        if (jahiaEEImplFileObject != null) {
            file = this.getFileInJar(fsManager, jahiaEEImplFileObject.getURL(), "org/jahia/defaults/config/properties/jahia.node.properties");
        }
        if (jahiaImplFileObject != null && file == null) {
            file = this.getFileInJar(fsManager, jahiaImplFileObject.getURL(), "org/jahia/defaults/config/properties/jahia.node.properties");
        }
        if (file == null) {
            file = this.getFileInJar(fsManager, this.getClass().getClassLoader().getResource("jahia-default-config.jar"), "org/jahia/defaults/config/properties/jahia.node.properties");
        }
        return file;
    }

    private VFSConfigFile getFileInJar(FileSystemManager fsManager, URL jarUrl, String path) {
        try {
            VFSConfigFile vfsConfigFile = new VFSConfigFile(fsManager.resolveFile("jar:" + jarUrl.toExternalForm()), path);
            vfsConfigFile.getInputStream();
            return vfsConfigFile;
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    private ConfigFile readJahiaProperties(String sourceWebAppPath, FileSystemManager fsManager) throws IOException {
        ConfigFile cfg = null;
        FileObject jahiaImplFileObject = this.findVFSFile(sourceWebAppPath + "/WEB-INF/lib", "jahia\\-impl\\-.*\\.jar");
        URL jahiaDefaultConfigJARURL = this.getClass().getClassLoader().getResource("jahia-default-config.jar");
        if (jahiaImplFileObject != null) {
            jahiaDefaultConfigJARURL = jahiaImplFileObject.getURL();
        }
        try (VFSConfigFile jahiaPropertiesConfigFile = new VFSConfigFile(fsManager.resolveFile("jar:" + jahiaDefaultConfigJARURL.toExternalForm()), "org/jahia/defaults/config/properties/jahia.properties");){
            cfg = jahiaPropertiesConfigFile;
            FileObject jahiaEEImplFileObject = this.findVFSFile(sourceWebAppPath + "/WEB-INF/lib", "jahia\\-ee\\-impl.*\\.jar");
            if (jahiaEEImplFileObject != null) {
                jahiaDefaultConfigJARURL = jahiaEEImplFileObject.getURL();
            }
            try (VFSConfigFile jahiaAdvancedPropertiesConfigFile = new VFSConfigFile(fsManager.resolveFile("jar:" + jahiaDefaultConfigJARURL.toExternalForm()), "org/jahia/defaults/config/properties/jahia.advanced.properties");
                 InputStream is1 = jahiaPropertiesConfigFile.getInputStream();
                 InputStream is2 = jahiaAdvancedPropertiesConfigFile.getInputStream();){
                final String content = IOUtils.toString(is1) + "\n" + IOUtils.toString(is2);
                cfg = new ConfigFile(){

                    @Override
                    public URI getURI() throws IOException, URISyntaxException {
                        return null;
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return IOUtils.toInputStream(content);
                    }
                };
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return cfg;
    }

    private void updateForJBoss(Properties dbProps, JahiaConfigInterface jahiaConfigInterface, FileSystemManager fsManager) throws Exception, FileSystemException, IOException {
        JBossConfigurator configurator = new JBossConfigurator(dbProps, jahiaConfigInterface, this.getDeployer(), this.getLogger());
        File datasourcePath = new File(jahiaConfigInterface.getTargetServerDirectory(), "standalone/configuration/standalone.xml");
        if (datasourcePath.exists()) {
            configurator.updateConfiguration(new VFSConfigFile(fsManager, datasourcePath.getPath()), datasourcePath.getPath());
        } else {
            File cliFile;
            File fragmentFile = new File(jahiaConfigInterface.getTargetServerDirectory(), "standalone/configuration/standalone.xml.fragment");
            if (fragmentFile.exists()) {
                configurator.updateConfiguration(new VFSConfigFile(fsManager, fragmentFile.getPath()), fragmentFile.getPath());
            }
            if ((cliFile = new File(jahiaConfigInterface.getTargetServerDirectory(), "bin/jahia-config.cli")).exists()) {
                configurator.writeCLIConfiguration(cliFile, null);
                configurator.writeCLIConfiguration(new File(jahiaConfigInterface.getTargetServerDirectory(), "bin/jahia-config-domain.cli"), "default");
            }
        }
        configurator.updateDriverModule();
    }

    public FileObject findVFSFile(String parentPath, String fileMatchingPattern) {
        Pattern matchingPattern = Pattern.compile(fileMatchingPattern);
        try {
            FileObject[] children;
            FileSystemManager fsManager = VFS.getManager();
            FileObject parentFileObject = fsManager.resolveFile(parentPath);
            for (FileObject child : children = parentFileObject.getChildren()) {
                Matcher matcher = matchingPattern.matcher(child.getName().getBaseName());
                if (!matcher.matches()) continue;
                return child;
            }
        }
        catch (FileSystemException e) {
            this.logger.debug("Couldn't find file matching pattern " + fileMatchingPattern + " at path " + parentPath);
        }
        return null;
    }

    private void setProperties() throws Exception {
        this.webappDir = this.getWebappDeploymentDir();
        String sourceWebappPath = this.webappDir.toString();
        String databaseType = this.jahiaConfig.getDatabaseType();
        this.getLogger().info("Deployed in standalone for server in " + this.webappDir);
        String dbUrl = this.jahiaConfig.getDatabaseUrl();
        boolean isEmbeddedDerby = databaseType.equals(DERBY_EMBEDDED);
        if (isEmbeddedDerby) {
            if (this.jahiaConfig.getDatabaseUrl().contains("$context")) {
                dbUrl = StringUtils.replace(dbUrl, "$context", StringUtils.replace(sourceWebappPath, "\\", "/"));
            } else {
                System.setProperty("derby.system.home", StringUtils.replace(new File(this.getDataDir(), "dbdata").getAbsolutePath(), "\\", "/"));
            }
        }
        this.dbProps = new Properties();
        this.databaseScript = new File(this.getDataDir(), "db/" + databaseType + ".script");
        try (FileInputStream is = new FileInputStream(this.databaseScript);){
            this.dbProps.load(is);
            this.dbProps.put("storeFilesInDB", this.jahiaConfig.getStoreFilesInDB());
            this.dbProps.put("storeFilesInAWS", this.jahiaConfig.getStoreFilesInAWS());
            this.dbProps.put("fileDataStorePath", this.jahiaConfig.getFileDataStorePath() != null ? this.jahiaConfig.getFileDataStorePath() : "");
            this.dbProps.put("jahia.database.url", dbUrl);
            this.dbProps.put("jahia.database.user", this.jahiaConfig.getDatabaseUsername());
            this.dbProps.put("jahia.database.pass", this.jahiaConfig.getDatabasePassword());
        }
        catch (IOException e) {
            this.getLogger().error("Error in loading database settings because of " + e);
        }
        this.getLogger().info("Updating configuration files...");
        this.updateConfigurationFiles(sourceWebappPath, this.webappDir.getPath(), this.dbProps, this.jahiaConfig);
        this.getLogger().info("Copying license file...");
        Object targetConfigPath = this.webappDir.getPath() + "/WEB-INF/etc/config";
        if (this.externalizedConfigTempPath != null) {
            targetConfigPath = this.externalizedConfigTempPath;
        }
        try {
            String existingLicense = this.jahiaConfig.getLicenseFile();
            this.copyLicense((String)(existingLicense != null && existingLicense.length() > 0 ? existingLicense : sourceWebappPath + "/WEB-INF/etc/config/licenses/license-free.xml"), (String)targetConfigPath + "/license.xml");
            if (this.jahiaConfig.getOverwritedb().equals("true") || this.jahiaConfig.getOverwritedb().equals(IF_NECESSARY)) {
                this.getLogger().info("driver: " + this.dbProps.getProperty(JAHIA_DATABASE_DRIVER));
                this.getLogger().info("url: " + this.jahiaConfig.getDatabaseUrl());
                this.getLogger().info("user: " + this.jahiaConfig.getDatabaseUsername());
                if (!this.databaseScript.exists()) {
                    this.getLogger().info("cannot find script in " + this.databaseScript.getPath());
                    throw new Exception("Cannot find script for database " + databaseType);
                }
                if (this.cleanDatabase(databaseType, dbUrl)) {
                    this.getLogger().info("Creating tables");
                    this.db.databaseOpen(this.dbProps.getProperty(JAHIA_DATABASE_DRIVER), dbUrl, this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
                    this.createDBTables(this.databaseScript);
                }
                if (isEmbeddedDerby) {
                    this.shutdownDerby();
                }
            }
            if (this.jahiaConfig.getDeleteFiles().equals("true")) {
                this.deleteRepositoryAndIndexes();
                if ("tomcat".equals(this.jahiaConfig.getTargetServerType())) {
                    this.deleteTomcatFiles();
                }
            }
            if (this.jahiaConfig.getSiteImportLocation() != null) {
                File importsFolder = new File(this.getDataDir(), "imports");
                this.getLogger().info("Copying site Export to the " + importsFolder);
                this.copyImports(importsFolder.getAbsolutePath());
            } else {
                this.getLogger().info("No site import found, no import needed.");
            }
            if (this.jahiaConfigDir != null && this.externalizedConfigTempPath != null) {
                this.copyExternalizedConfig();
            }
        }
        catch (Exception e) {
            this.getLogger().error("exception in setting the properties because of " + e, e);
        }
    }

    private void shutdownDerby() {
        this.getLogger().info("Shutting down embedded Derby...");
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true", this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
        }
        catch (Exception e) {
            if (!(e instanceof SQLException) || e.getMessage() == null || !e.getMessage().contains("Derby system shutdown")) {
                this.logger.warn(e.getMessage(), e);
            }
            this.getLogger().info("...done shutting down Derby.");
        }
    }

    private boolean cleanDatabase(String databaseType, String dbUrl) throws ClassNotFoundException, SQLException {
        boolean shouldCreateTables = true;
        try {
            if (databaseType.contains(DERBY) && !((String)dbUrl).contains("create=true")) {
                if (this.jahiaConfig.getOverwritedb().equals(IF_NECESSARY)) {
                    try {
                        this.db.databaseOpen(this.dbProps.getProperty(JAHIA_DATABASE_DRIVER), (String)dbUrl, this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
                        return false;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                dbUrl = (String)dbUrl + ";create=true";
                this.db.databaseOpen(this.dbProps.getProperty(JAHIA_DATABASE_DRIVER), (String)dbUrl, this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
            } else if (databaseType.equals(MYSQL) || databaseType.equals(MARIADB) || databaseType.equals(POSTGRESQL)) {
                URI dbSubURI = URI.create(((String)dbUrl).substring(5));
                String databaseName = dbSubURI.getPath().substring(1);
                String emptyUrl = null;
                String defaultPath = "/";
                if (POSTGRESQL.equals(databaseType)) {
                    defaultPath = "/postgres";
                }
                emptyUrl = dbSubURI.getPort() != -1 ? new URI(dbSubURI.getScheme(), null, dbSubURI.getHost(), dbSubURI.getPort(), defaultPath, null, dbSubURI.getFragment()).toString() : new URI(dbSubURI.getScheme(), dbSubURI.getHost(), defaultPath, dbSubURI.getFragment()).toString();
                this.db.databaseOpen(this.dbProps.getProperty(JAHIA_DATABASE_DRIVER), "jdbc:" + emptyUrl, this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
                if (this.jahiaConfig.getOverwritedb().equals(IF_NECESSARY) && this.exists(databaseName)) {
                    this.getLogger().info("Database already exist");
                    try {
                        this.db.databaseOpen(this.dbProps.getProperty(JAHIA_DATABASE_DRIVER), (String)dbUrl, this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
                        this.db.getStatement().execute("select count(*) from JR_DEFAULT_BINVAL");
                        shouldCreateTables = false;
                    }
                    catch (SQLException sQLException) {}
                } else {
                    this.getLogger().info("Database is " + databaseType + " trying to drop it and create a new one");
                    this.cleanDatabase(databaseName);
                }
            }
        }
        catch (Exception t2) {
            this.getLogger().error("Error when recreating db", t2);
        }
        this.db.databaseClose();
        return shouldCreateTables;
    }

    private boolean exists(String dbName) throws SQLException {
        ResultSet rs;
        switch (this.jahiaConfig.getDatabaseType()) {
            case "mysql": 
            case "mariadb": {
                rs = this.db.getConnection().getMetaData().getCatalogs();
                break;
            }
            case "postgresql": {
                rs = this.db.getStatement().executeQuery("SELECT datname FROM pg_catalog.pg_database");
                break;
            }
            default: {
                return false;
            }
        }
        while (rs.next()) {
            if (!dbName.equals(rs.getString(1))) continue;
            return true;
        }
        return false;
    }

    private void cleanDatabase(String databaseName) throws SQLException {
        switch (this.jahiaConfig.getDatabaseType()) {
            case "mysql": 
            case "mariadb": {
                this.db.query("drop database if exists `" + databaseName + "`");
                this.db.query("create database `" + databaseName + "`");
                this.db.query("alter database `" + databaseName + "` charset utf8");
                break;
            }
            case "postgresql": {
                this.db.query("drop database if exists \"" + databaseName + "\"");
                this.db.query("create database \"" + databaseName + "\"");
            }
        }
    }

    private void copyExternalizedConfig() throws IOException, ArchiverException {
        if (this.jahiaConfig.isExternalizedConfigExploded()) {
            File target = new File(this.jahiaConfig.getExternalizedConfigTargetPath());
            File targetCfgDir = new File(target, "jahia");
            File srcDir = new File(this.jahiaConfigDir, "jahia");
            if (targetCfgDir.isDirectory()) {
                Properties p;
                File jahiaPropsFile = new File(targetCfgDir, "jahia.properties");
                if (jahiaPropsFile.exists() && ((p = PropertyUtils.loadProperties(jahiaPropsFile)).containsKey(DB_SCRIPT) && !this.jahiaConfig.getDatabaseType().equals(p.getProperty(DB_SCRIPT)) || !p.containsKey(DB_SCRIPT) && !this.jahiaConfig.getDatabaseType().equals(DERBY_EMBEDDED))) {
                    this.getLogger().info("Deleting existing " + jahiaPropsFile + " file as the target database type has changed");
                    jahiaPropsFile.delete();
                }
                FileUtils.copyDirectory(srcDir, targetCfgDir, pathname -> !pathname.isFile() || !new File(targetCfgDir, pathname.getAbsolutePath().substring(srcDir.getAbsolutePath().length())).exists());
            } else {
                FileUtils.copyDirectoryToDirectory(srcDir, target);
            }
        } else {
            JarArchiver archiver = new JarArchiver();
            Object jarFileName = "jahia-config.jar";
            if (!StringUtils.isBlank(this.jahiaConfig.getExternalizedConfigFinalName())) {
                jarFileName = this.jahiaConfig.getExternalizedConfigFinalName();
                if (!StringUtils.isBlank(this.jahiaConfig.getExternalizedConfigClassifier())) {
                    jarFileName = (String)jarFileName + "-" + this.jahiaConfig.getExternalizedConfigClassifier();
                }
                jarFileName = (String)jarFileName + ".jar";
            }
            File targetFile = new File(this.jahiaConfig.getExternalizedConfigTargetPath(), (String)jarFileName);
            archiver.setDestFile(targetFile);
            archiver.addDirectory(this.jahiaConfigDir, null, null);
            archiver.createArchive();
        }
        FileUtils.deleteDirectory(this.jahiaConfigDir);
    }

    private void copyImports(String importsFolder) {
        for (int i = 0; i < this.jahiaConfig.getSiteImportLocation().size(); ++i) {
            try {
                this.copy(this.jahiaConfig.getSiteImportLocation().get(i), importsFolder);
                continue;
            }
            catch (IOException e) {
                this.getLogger().error("error in copying siteImport file " + e);
            }
        }
    }

    private void cleanDirectory(File toDelete) {
        if (toDelete.exists()) {
            try {
                FileUtils.cleanDirectory(toDelete);
            }
            catch (IOException e) {
                this.getLogger().error("Error deleting content of the folder '" + toDelete + "'. Cause: " + e.getMessage(), e);
            }
        }
    }

    private void deleteDirectory(File toDelete) {
        if (toDelete.exists()) {
            try {
                FileUtils.deleteDirectory(toDelete);
            }
            catch (IOException e) {
                this.getLogger().error("Error deleting content of the folder '" + toDelete + "'. Cause: " + e.getMessage(), e);
            }
        }
    }

    private void deleteTomcatFiles() {
        File toDelete1 = new File(this.jahiaConfig.getTargetServerDirectory() + "/temp");
        this.cleanDirectory(toDelete1);
        File toDelete2 = new File(this.jahiaConfig.getTargetServerDirectory() + "/work");
        this.cleanDirectory(toDelete2);
        this.getLogger().info("Finished deleting content of Tomcat's " + toDelete1 + " and " + toDelete2 + " folders");
    }

    private void deleteRepositoryAndIndexes() {
        try {
            File[] files = new File(this.getDataDir(), "repository").listFiles((dir, name) -> name == null || !name.startsWith("indexing_configuration") || !name.endsWith(".xml"));
            if (files != null) {
                for (File file : files) {
                    FileUtils.forceDelete(file);
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Error deleting content of the Jahia's /repository folder. Cause: " + e.getMessage(), e);
        }
        this.deleteDirectory(new File(this.getDataDir(), "bundles-deployed"));
        this.deleteDirectory(new File(this.getDataDir(), "compiledRules"));
        this.deleteDirectory(new File(this.getDataDir(), "content"));
        this.deleteDirectory(new File(this.getDataDir(), "generated-resources"));
        this.deleteDirectory(new File(new File(this.getDataDir(), "karaf"), "instances"));
        this.cleanDirectory(new File(new File(this.getDataDir(), "karaf"), "data"));
        this.cleanDirectory(new File(new File(this.getDataDir(), "karaf"), "deploy"));
        this.getLogger().info("Finished deleting content of the data and cache related folders");
    }

    private void copyLicense(String fromFileName, String toFileName) throws IOException {
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        if (toFile.exists() && !this.jahiaConfig.getDeleteFiles().equals("true")) {
            return;
        }
        if (!fromFile.exists()) {
            return;
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFileName);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFileName);
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        try (FileInputStream from = new FileInputStream(fromFile);
             FileOutputStream to = new FileOutputStream(toFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
    }

    private void copy(String fromFileName, String toFileName) throws IOException {
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + fromFileName);
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFileName);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFileName);
        }
        toFile.mkdir();
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        try (FileInputStream from = new FileInputStream(fromFile);
             FileOutputStream to = new FileOutputStream(toFile);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
    }

    private void createDBTables(File dbScript) throws Exception {
        List<String> sqlStatements = DatabaseScripts.getSchemaSQL(dbScript);
        org.jahia.commons.DatabaseScripts.executeStatements(sqlStatements, this.db.getConnection());
    }

    public static String encryptPassword(String password) {
        return EncryptionUtils.pbkdf2Digest(password, true);
    }

    protected String getWebappDeploymentDirName() {
        return this.jahiaConfig.getWebAppDirName() != null ? this.jahiaConfig.getWebAppDirName() : "jahia";
    }

    protected File getWebappDeploymentDir() {
        if (StringUtils.isNotEmpty(this.jahiaConfig.getTargetConfigurationDirectory())) {
            return new File(this.jahiaConfig.getTargetConfigurationDirectory());
        }
        String jeeApplicationLocation = this.jahiaConfig.getJeeApplicationLocation();
        if (!StringUtils.isEmpty(jeeApplicationLocation)) {
            return new File(jeeApplicationLocation, "jahia.war");
        }
        return this.getDeployer().getDeploymentDirPath(StringUtils.defaultString(this.getDeployer().getWebappDeploymentDirNameOverride(), this.getWebappDeploymentDirName()), "war");
    }

    private ServerDeploymentInterface getDeployer() {
        if (this.deployer == null) {
            this.deployer = ServerDeploymentFactory.getImplementation(this.jahiaConfig.getTargetServerType(), this.jahiaConfig.getTargetServerVersion(), new File(this.jahiaConfig.getTargetServerDirectory()), null, null);
        }
        return this.deployer;
    }

    public static JahiaConfigInterface getConfiguration(File configFile, AbstractLogger logger) throws IOException, IllegalAccessException, InvocationTargetException {
        JahiaConfigBean config = new JahiaConfigBean();
        Properties props = null;
        if (configFile != null) {
            try (FileInputStream is = new FileInputStream(configFile);){
                props = new Properties();
                props.load(is);
            }
        }
        if (props != null && !props.isEmpty()) {
            Properties map = props;
            new BeanUtilsBean(CONVERTER_UTILS_BEAN, new PropertyUtilsBean()).populate(config, map);
        }
        if (logger != null) {
            if (props != null) {
                props.put("databasePassword", "***");
                props.put("jahiaRootPassword", "***");
                props.put("mailServer", "***");
            }
            logger.info("Loaded configuration from file " + configFile + ":\n" + props);
        }
        return config;
    }

    private File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = JahiaGlobalConfigurator.resolveDataDir(this.jahiaConfig.getJahiaVarDiskPath(), this.getWebappDeploymentDir().getAbsolutePath());
            this.getLogger().info("Data directory resolved to folder: " + this.dataDir);
        }
        return this.dataDir;
    }

    static {
        CONVERTER_UTILS_BEAN.register(new Converter(){

            public Object convert(Class type, Object value) {
                return JahiaGlobalConfigurator.fromString(value != null ? value.toString() : null);
            }
        }, List.class);
        CONVERTER_UTILS_BEAN.register(new Converter(){

            public Object convert(Class type, Object value) {
                return value != null ? JahiaGlobalConfigurator.fromJSON(value.toString()) : new HashMap();
            }
        }, Map.class);
    }
}

