/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.configuration.configurators.AbstractConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.configurators.PropertiesManager;

public class JahiaPropertiesConfigurator
extends AbstractConfigurator {
    private PropertiesManager properties;

    public JahiaPropertiesConfigurator(Map dbProperties, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProperties, jahiaConfigInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateConfiguration(ConfigFile sourceJahiaPath, String targetJahiaPath) throws IOException {
        String fileDataStorePath;
        this.properties = new PropertiesManager(sourceJahiaPath.getInputStream());
        this.properties.setUnmodifiedCommentingActivated(true);
        File targetJahiaFile = new File(targetJahiaPath);
        Properties existingProperties = new Properties();
        if (targetJahiaFile.exists()) {
            existingProperties.putAll((Map<?, ?>)PropertyUtils.loadProperties(targetJahiaFile));
            for (Object object : existingProperties.keySet()) {
                String propertyName = String.valueOf(object);
                this.properties.setProperty(propertyName, existingProperties.getProperty(propertyName));
            }
        }
        this.properties.setProperty("jahiaVarDiskPath", this.jahiaConfigInterface.getJahiaVarDiskPath());
        this.properties.setProperty("jahiaModulesDiskPath", this.jahiaConfigInterface.getJahiaModulesDiskPath());
        this.properties.setProperty("jahiaWebAppsDeployerBaseURL", this.jahiaConfigInterface.getJahiaWebAppsDeployerBaseURL());
        this.properties.setProperty("jahiaImportsDiskPath", this.jahiaConfigInterface.getJahiaImportsDiskPath());
        this.properties.setProperty("db_script", this.jahiaConfigInterface.getDb_script());
        this.properties.setProperty("operatingMode", this.jahiaConfigInterface.getOperatingMode());
        this.properties.setProperty("hibernate.dialect", this.getDBProperty("jahia.database.hibernate.dialect"));
        if (this.jahiaConfigInterface.getJahiaProperties() != null) {
            for (Map.Entry entry : this.jahiaConfigInterface.getJahiaProperties().entrySet()) {
                this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.configureScheduler();
        if (this.jahiaConfigInterface.getJahiaAdvancedProperties() != null) {
            for (Map.Entry entry : this.jahiaConfigInterface.getJahiaAdvancedProperties().entrySet()) {
                this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (StringUtils.isNotEmpty(fileDataStorePath = JahiaPropertiesConfigurator.getValue(this.dbProperties, "fileDataStorePath"))) {
            void var6_13;
            String string = "jackrabbit.datastore.path";
            InputStream is = sourceJahiaPath.getInputStream();
            try {
                if (IOUtils.toString(is).contains("jahia.jackrabbit.datastore.path")) {
                    String string2 = "jahia.jackrabbit.datastore.path";
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
            this.properties.setProperty((String)var6_13, fileDataStorePath);
        }
        this.properties.storeProperties(sourceJahiaPath.getInputStream(), targetJahiaPath);
    }

    private void configureScheduler() {
        String delegate = (String)this.dbProperties.get("jahia.quartz.jdbcDelegate");
        if (delegate == null || delegate.length() == 0) {
            delegate = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        }
        if (this.jahiaConfigInterface.getTargetServerType().startsWith("weblogic")) {
            delegate = "org.quartz.impl.jdbcjobstore.WebLogicDelegate";
            if (this.jahiaConfigInterface.getDatabaseType().equals("oracle")) {
                delegate = "org.quartz.impl.jdbcjobstore.oracle.weblogic.WebLogicOracleDelegate";
            }
        }
        if (this.jahiaConfigInterface.getTargetServerType().startsWith("was") && this.jahiaConfigInterface.getDatabaseType().equals("oracle")) {
            delegate = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        }
        this.properties.setProperty("org.quartz.driverDelegateClass", delegate);
    }
}

