/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.deployers.jboss;

import java.io.File;
import java.io.IOException;
import org.jahia.configuration.deployers.AbstractServerDeploymentImpl;
import org.jahia.configuration.deployers.jboss.DriverDeploymentHelper;

public class JBossServerDeploymentImpl
extends AbstractServerDeploymentImpl {
    private static final String JAHIA_EAR_DIR_NAME = "digitalfactory.ear";
    private static final String JAHIA_WAR_DIR_NAME = "jahia.war";

    public JBossServerDeploymentImpl(String id, String name, File targetServerDirectory) {
        super(id, name, targetServerDirectory);
    }

    @Override
    public boolean deployJdbcDriver(File driverJar) throws IOException {
        return DriverDeploymentHelper.deploy(this.getTargetServerDirectory(), driverJar);
    }

    @Override
    public File getDeploymentBaseDir() {
        return new File(this.getTargetServerDirectory(), "standalone/deployments");
    }

    @Override
    public File getDeploymentDirPath(String name, String type) {
        String ext = "." + type;
        return this.getDeploymentFilePath(name.endsWith(ext) ? name.substring(0, name.length() - ext.length()) : name, type);
    }

    @Override
    public File getDeploymentFilePath(String name, String type) {
        return new File(this.getDeploymentBaseDir(), "war".equals(type) ? "digitalfactory.ear/" + name + "." + type : name + "." + type);
    }

    @Override
    protected File getSharedLibraryDirectory() {
        return new File(this.getTargetServerDirectory(), "standalone/deployments/digitalfactory.ear/lib");
    }

    @Override
    public String getWebappDeploymentDirNameOverride() {
        return JAHIA_WAR_DIR_NAME;
    }

    @Override
    public boolean isEarDeployment() {
        return true;
    }

    @Override
    public boolean validateInstallationDirectory() {
        return new File(this.getTargetServerDirectory(), "jboss-modules.jar").exists();
    }
}

