/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.modules;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.jahia.configuration.logging.AbstractLogger;

public class ModuleDeployer {
    private AbstractLogger logger;
    private File output;

    public ModuleDeployer(File output, AbstractLogger logger) {
        this.output = output;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDbScripts(File warFile, File targetDir) {
        block15: {
            JarFile war = null;
            try {
                war = new JarFile(warFile);
                if (war.getJarEntry("META-INF/db") == null) break block15;
                war.close();
                ZipUnArchiver unarch = new ZipUnArchiver(warFile);
                File tmp = new File(FileUtils.getTempDirectory(), String.valueOf(System.currentTimeMillis()));
                tmp.mkdirs();
                File destDir = new File(targetDir, "db/sql/schema");
                try {
                    unarch.extract("META-INF/db", tmp);
                    FileUtils.copyDirectory(new File(tmp, "META-INF/db"), destDir);
                }
                finally {
                    FileUtils.deleteQuietly(tmp);
                }
                this.logger.info("Copied database scripts from " + warFile.getName() + " to " + destDir);
            }
            catch (Exception e) {
                this.logger.error("Error copying database scripts for module " + warFile, e);
            }
            finally {
                if (war != null) {
                    try {
                        war.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unable to close the JAR file " + warFile, e);
                    }
                }
            }
        }
    }

    public void deployModule(File file) throws IOException {
        FileUtils.copyFileToDirectory(file, this.output);
        this.logger.info("Copied " + file + " to " + this.output);
        File targetDir = new File(this.output, "../");
        this.copyDbScripts(file, targetDir);
    }
}

