/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.configuration.configurators.AbstractXMLConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.logging.AbstractLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class JackrabbitConfigurator
extends AbstractXMLConfigurator {
    public JackrabbitConfigurator(Map dbProperties, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProperties, jahiaConfigInterface);
    }

    public JackrabbitConfigurator(Map dbProperties, JahiaConfigInterface jahiaConfigInterface, AbstractLogger logger) {
        super(dbProperties, jahiaConfigInterface, logger);
    }

    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", true);
            saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxBuilder.setExpandEntities(false);
            InputStreamReader fileReader = new InputStreamReader(sourceConfigFile.getInputStream());
            Document jdomDocument = saxBuilder.build((Reader)fileReader);
            Element repositoryElement = jdomDocument.getRootElement();
            Namespace namespace = repositoryElement.getNamespace();
            String schema = JackrabbitConfigurator.getValue(this.dbProperties, "jahia.jackrabbit.schema");
            XPathFactory xPathFactory = XPathFactory.instance();
            XPathExpression databaseTypeXPath = xPathFactory.compile("//Repository/DataSources/DataSource/param[@name=\"databaseType\"]", Filters.element());
            for (Element paramElement : databaseTypeXPath.evaluate((Object)jdomDocument)) {
                paramElement.setAttribute("value", schema);
            }
            XPathExpression clusterXPath = xPathFactory.compile("//Cluster", Filters.element());
            Element clusterElement = (Element)clusterXPath.evaluateFirst((Object)jdomDocument);
            if (clusterElement != null) {
                Element journalElement = clusterElement.getChild("Journal");
                journalElement.setAttribute("class", JackrabbitConfigurator.getValue(this.dbProperties, "jahia.jackrabbit.journal"));
            }
            this.configureBinaryStorage(repositoryElement, namespace, this.dbProperties);
            this.setElementAttribute(repositoryElement, "/Repository/FileSystem", "class", JackrabbitConfigurator.getValue(this.dbProperties, "jahia.jackrabbit.filesystem"));
            this.setElementAttribute(repositoryElement, "//PersistenceManager", "class", JackrabbitConfigurator.getValue(this.dbProperties, "jahia.jackrabbit.persistence"));
            Element fs = this.getElement(repositoryElement, "//Workspace/FileSystem");
            if (fs != null && fs.getAttributeValue("class").equals("@FILESYSTEM_CLASS@")) {
                fs.setAttribute("class", "org.apache.jackrabbit.core.fs.local.LocalFileSystem");
                this.removeElementIfExists(repositoryElement, "//Workspace/FileSystem/param[@name=\"dataSourceName\"]");
                this.removeElementIfExists(repositoryElement, "//Workspace/FileSystem/param[@name=\"schemaObjectPrefix\"]");
                this.removeElementIfExists(repositoryElement, "//Workspace/FileSystem/param[@name=\"schemaCheckEnabled\"]");
                fs.addContent((Content)new Element("param", namespace).setAttribute("name", "path").setAttribute("value", "${wsp.home}"));
            }
            if ((fs = (Element)xPathFactory.compile("//Versioning/FileSystem", Filters.element()).evaluateFirst((Object)jdomDocument)) != null && fs.getAttributeValue("class").equals("@FILESYSTEM_CLASS@")) {
                fs.setAttribute("class", "org.apache.jackrabbit.core.fs.local.LocalFileSystem");
                this.removeElementIfExists(repositoryElement, "//Versioning/FileSystem/param[@name=\"dataSourceName\"]");
                this.removeElementIfExists(repositoryElement, "//Versioning/FileSystem/param[@name=\"schemaObjectPrefix\"]");
                this.removeElementIfExists(repositoryElement, "//Versioning/FileSystem/param[@name=\"schemaCheckEnabled\"]");
                fs.addContent((Content)new Element("param", namespace).setAttribute("name", "path").setAttribute("value", "${rep.home}/version"));
            }
            this.write(jdomDocument, new File(destFileName));
        }
        catch (JDOMException jdome) {
            throw new Exception("Error while updating configuration file " + sourceConfigFile, jdome);
        }
    }

    protected void configureBinaryStorage(Element repositoryElement, Namespace namespace, Map dbProperties) throws JDOMException {
        boolean storeFilesInDB = Boolean.valueOf(JackrabbitConfigurator.getValue(dbProperties, "storeFilesInDB"));
        boolean storeFilesInAWS = Boolean.valueOf(JackrabbitConfigurator.getValue(dbProperties, "storeFilesInAWS"));
        String fileDataStorePath = JackrabbitConfigurator.getValue(dbProperties, "fileDataStorePath");
        this.getLogger().info("Configuring Jackrabbit binary storage using data store. Store files in DB: " + storeFilesInDB + "." + (String)(!storeFilesInDB ? " File data store path: " + (StringUtils.isNotEmpty((String)fileDataStorePath) ? fileDataStorePath : "${jahia.jackrabbit.datastore.path}") + "." : ""));
        if (storeFilesInAWS) {
            this.removeAllElements(repositoryElement, "//Repository/DataStore[@class=\"org.apache.jackrabbit.core.data.FileDataStore\"]");
            this.removeAllElements(repositoryElement, "//Repository/DataStore[@class=\"org.apache.jackrabbit.core.data.db.DbDataStore\"]");
        } else if (storeFilesInDB) {
            this.removeAllElements(repositoryElement, "//Repository/DataStore[@class=\"org.apache.jackrabbit.core.data.FileDataStore\"]");
            this.removeAllElements(repositoryElement, "//Repository/DataStore[@class=\"org.jahia.services.content.impl.jackrabbit.S3DataStore\"]");
            Element store = this.getElement(repositoryElement, "//Repository/DataStore[@class=\"org.apache.jackrabbit.core.data.db.DbDataStore\"]");
            if (store == null) {
                store = new Element("DataStore", namespace);
                store.setAttribute("class", "org.apache.jackrabbit.core.data.db.DbDataStore");
                store.addContent((Content)new Element("param").setAttribute("name", "dataSourceName").setAttribute("value", "jahiaDS"));
                store.addContent((Content)new Element("param").setAttribute("name", "schemaObjectPrefix").setAttribute("value", "JR_"));
                store.addContent((Content)new Element("param").setAttribute("name", "schemaCheckEnabled").setAttribute("value", "false"));
                store.addContent((Content)new Element("param").setAttribute("name", "copyWhenReading").setAttribute("value", "true"));
                store.addContent((Content)new Element("param").setAttribute("name", "minRecordLength").setAttribute("value", "1024"));
                repositoryElement.addContent((Content)store);
            }
        } else {
            this.removeAllElements(repositoryElement, "//Repository/DataStore[@class=\"org.apache.jackrabbit.core.data.db.DbDataStore\"]");
            this.removeAllElements(repositoryElement, "//Repository/DataStore[@class=\"org.jahia.services.content.impl.jackrabbit.S3DataStore\"]");
            Element store = this.getElement(repositoryElement, "//Repository/DataStore[@class=\"org.apache.jackrabbit.core.data.FileDataStore\"]");
            Element pathParam = null;
            if (store == null) {
                store = new Element("DataStore", namespace);
                store.setAttribute("class", "org.apache.jackrabbit.core.data.FileDataStore");
                store.addContent((Content)new Element("param").setAttribute("name", "minRecordLength").setAttribute("value", "1024"));
                pathParam = new Element("param").setAttribute("name", "path").setAttribute("value", "");
                store.addContent((Content)pathParam);
                repositoryElement.addContent((Content)store);
            } else {
                pathParam = this.getElement(store, "//DataStore/param[@name=\"path\"]");
            }
            pathParam.setAttribute("value", "${jahia.jackrabbit.datastore.path}");
        }
    }
}

