/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.logging;

import org.jahia.configuration.logging.AbstractLogger;

public class ConsoleLogger
implements AbstractLogger {
    public static final byte LEVEL_DEBUG = 0;
    public static final byte LEVEL_INFO = 1;
    public static final byte LEVEL_WARN = 2;
    public static final byte LEVEL_ERROR = 3;
    private byte level = 0;

    public ConsoleLogger() {
        this(0);
    }

    public ConsoleLogger(byte level) {
        this.level = level;
    }

    @Override
    public void debug(String message) {
        this.out((byte)0, message, null);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.out((byte)0, message, t);
    }

    @Override
    public void error(String message) {
        this.out((byte)3, message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.out((byte)3, message, t);
    }

    @Override
    public void info(String message) {
        this.out((byte)1, message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= 0;
    }

    @Override
    public void warn(String message) {
        this.out((byte)2, message, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.out((byte)2, message, t);
    }

    private void out(byte level, String message, Throwable t) {
        if (level < this.level) {
            return;
        }
        System.out.println(message);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }
}

