/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerFMTQuery;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import com.microsoft.sqlserver.jdbc.SQLServerTokenIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.antlr.v4.runtime.Token;

final class SQLServerParser {
    private static final List<Integer> SELECT_DELIMITING_WORDS = Arrays.asList(8, 10, 9, 11, 12);
    private static final List<Integer> INSERT_DELIMITING_WORDS = Arrays.asList(14, 15, 71, 1, 7, 17, 19);
    private static final List<Integer> DELETE_DELIMITING_WORDS = Arrays.asList(12, 8, 15, 5);
    private static final List<Integer> UPDATE_DELIMITING_WORDS = Arrays.asList(20, 15, 8, 12);
    private static final List<Integer> FROM_DELIMITING_WORDS = Arrays.asList(8, 10, 9, 11, 12, 35);
    private static final List<Integer> OPERATORS = Arrays.asList(50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63, 64, 80, 81, 82, 83, 84, 30, 31, 34);

    SQLServerParser() {
    }

    static void parseQuery(SQLServerTokenIterator iter, SQLServerFMTQuery query) throws SQLServerException {
        Token t2 = null;
        block8: while (iter.hasNext()) {
            t2 = iter.next();
            switch (t2.getType()) {
                case 1: {
                    t2 = SQLServerParser.skipTop(iter);
                    while (t2.getType() != 78) {
                        if (t2.getType() == 89) {
                            String columnName = SQLServerParser.findColumnAroundParameter(iter);
                            query.getColumns().add(columnName);
                        }
                        if (t2.getType() == 5) {
                            query.getTableTarget().add(SQLServerParser.getTableTargetChunk(iter, query.getAliases(), SELECT_DELIMITING_WORDS));
                            continue block8;
                        }
                        if (!iter.hasNext()) continue block8;
                        t2 = iter.next();
                    }
                    continue block8;
                }
                case 2: {
                    t2 = SQLServerParser.skipTop(iter);
                    if (t2.getType() != 6) {
                        t2 = iter.previous();
                    }
                    query.getTableTarget().add(SQLServerParser.getTableTargetChunk(iter, query.getAliases(), INSERT_DELIMITING_WORDS));
                    if (!iter.hasNext()) continue block8;
                    List<String> tableValues = SQLServerParser.getValuesList(iter);
                    boolean valuesFound = false;
                    int valuesMarker = iter.nextIndex();
                    while (!valuesFound && iter.hasNext()) {
                        t2 = iter.next();
                        if (t2.getType() != 14) continue;
                        valuesFound = true;
                        do {
                            query.getValuesList().add(SQLServerParser.getValuesList(iter));
                        } while (iter.hasNext() && iter.next().getType() == 77);
                        iter.previous();
                    }
                    if (!valuesFound) {
                        SQLServerParser.resetIteratorIndex(iter, valuesMarker);
                    }
                    if (query.getValuesList().isEmpty()) continue block8;
                    for (List<String> ls : query.getValuesList()) {
                        if (tableValues.isEmpty()) {
                            query.getColumns().add("*");
                        }
                        for (int i2 = 0; i2 < ls.size(); ++i2) {
                            if (!"?".equalsIgnoreCase(ls.get(i2))) continue;
                            if (0 == tableValues.size()) {
                                query.getColumns().add("?");
                                continue;
                            }
                            if (i2 < tableValues.size()) {
                                query.getColumns().add(tableValues.get(i2));
                                continue;
                            }
                            SQLServerException.makeFromDriverError(null, null, SQLServerResource.getResource("R_invalidInsertValuesQuery"), null, false);
                        }
                    }
                    continue block8;
                }
                case 3: {
                    t2 = SQLServerParser.skipTop(iter);
                    if (t2.getType() != 5) {
                        t2 = iter.previous();
                    }
                    query.getTableTarget().add(SQLServerParser.getTableTargetChunk(iter, query.getAliases(), DELETE_DELIMITING_WORDS));
                    continue block8;
                }
                case 4: {
                    SQLServerParser.skipTop(iter);
                    t2 = iter.previous();
                    query.getTableTarget().add(SQLServerParser.getTableTargetChunk(iter, query.getAliases(), UPDATE_DELIMITING_WORDS));
                    continue block8;
                }
                case 5: {
                    query.getTableTarget().add(SQLServerParser.getTableTargetChunk(iter, query.getAliases(), FROM_DELIMITING_WORDS));
                    continue block8;
                }
                case 89: {
                    int parameterIndex = iter.nextIndex();
                    String columnName = SQLServerParser.findColumnAroundParameter(iter);
                    query.getColumns().add(columnName);
                    SQLServerParser.resetIteratorIndex(iter, parameterIndex);
                    continue block8;
                }
            }
        }
    }

    static void resetIteratorIndex(SQLServerTokenIterator iter, int index) {
        block3: {
            block2: {
                if (iter.nextIndex() >= index) break block2;
                while (iter.nextIndex() != index) {
                    iter.next();
                }
                break block3;
            }
            if (iter.nextIndex() <= index) break block3;
            while (iter.nextIndex() != index) {
                iter.previous();
            }
        }
    }

    private static String getRoundBracketChunk(SQLServerTokenIterator iter) throws SQLServerException {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Stack<String> s2 = new Stack<String>();
        s2.push("(");
        while (!s2.empty() && iter.hasNext()) {
            Token t2 = iter.next();
            if (t2.getType() == 72) {
                sb.append(")");
                s2.pop();
                continue;
            }
            if (t2.getType() == 71) {
                sb.append("(");
                s2.push("(");
                continue;
            }
            sb.append(t2.getText()).append(" ");
        }
        return sb.toString();
    }

    private static String getRoundBracketChunkBefore(SQLServerTokenIterator iter) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Stack<String> s2 = new Stack<String>();
        s2.push(")");
        while (!s2.empty()) {
            Token t2 = iter.previous();
            if (t2.getType() == 72) {
                sb.append("(");
                s2.push(")");
                continue;
            }
            if (t2.getType() == 71) {
                sb.append(")");
                s2.pop();
                continue;
            }
            sb.append(t2.getText()).append(" ");
        }
        return sb.toString();
    }

    static String findColumnAroundParameter(SQLServerTokenIterator iter) throws SQLServerException {
        int index = iter.nextIndex();
        iter.previous();
        String value = SQLServerParser.findColumnBeforeParameter(iter);
        SQLServerParser.resetIteratorIndex(iter, index);
        if ("".equalsIgnoreCase(value)) {
            value = SQLServerParser.findColumnAfterParameter(iter);
            SQLServerParser.resetIteratorIndex(iter, index);
        }
        return value;
    }

    private static String findColumnAfterParameter(SQLServerTokenIterator iter) throws SQLServerException {
        StringBuilder sb = new StringBuilder();
        while (0 == sb.length() && iter.hasNext()) {
            Token t2 = iter.next();
            if (t2.getType() == 33 && iter.hasNext()) {
                t2 = iter.next();
            }
            if (OPERATORS.contains(t2.getType()) && iter.hasNext()) {
                t2 = iter.next();
                if (t2.getType() == 89) continue;
                if (t2.getType() == 71) {
                    sb.append(SQLServerParser.getRoundBracketChunk(iter));
                } else {
                    sb.append(t2.getText());
                }
                for (int i2 = 0; i2 < 3 && iter.hasNext(); ++i2) {
                    t2 = iter.next();
                    if (t2.getType() != 66) continue;
                    sb.append(".");
                    if (!iter.hasNext()) continue;
                    t2 = iter.next();
                    sb.append(t2.getText());
                }
                continue;
            }
            return "";
        }
        return sb.toString();
    }

    private static String findColumnBeforeParameter(SQLServerTokenIterator iter) {
        StringBuilder sb = new StringBuilder();
        while (0 == sb.length() && iter.hasPrevious()) {
            Token t2 = iter.previous();
            if (t2.getType() == 70 && iter.hasPrevious()) {
                t2 = iter.previous();
            }
            if (t2.getType() == 35 && iter.hasPrevious()) {
                t2 = iter.previous();
                if (iter.hasPrevious()) {
                    t2 = iter.previous();
                    if (t2.getType() == 34 && iter.hasNext()) {
                        iter.next();
                        continue;
                    }
                    return "";
                }
            }
            if (OPERATORS.contains(t2.getType()) && iter.hasPrevious()) {
                t2 = iter.previous();
                if (t2.getType() == 33) {
                    t2 = iter.previous();
                }
                if (t2.getType() == 89) continue;
                ArrayDeque<String> d2 = new ArrayDeque<String>();
                if (t2.getType() == 72) {
                    d2.push(SQLServerParser.getRoundBracketChunkBefore(iter));
                } else {
                    d2.push(t2.getText());
                }
                for (int i2 = 0; i2 < 3 && iter.hasPrevious(); ++i2) {
                    t2 = iter.previous();
                    if (t2.getType() != 66) continue;
                    d2.push(".");
                    if (!iter.hasPrevious()) continue;
                    t2 = iter.previous();
                    d2.push(t2.getText());
                }
                d2.stream().forEach(sb::append);
                continue;
            }
            return "";
        }
        return sb.toString();
    }

    static List<String> getValuesList(SQLServerTokenIterator iter) throws SQLServerException {
        Token t2 = iter.next();
        if (t2.getType() == 71) {
            ArrayList<String> parameterColumns = new ArrayList<String>();
            ArrayDeque<Integer> d2 = new ArrayDeque<Integer>();
            StringBuilder sb = new StringBuilder();
            do {
                switch (t2.getType()) {
                    case 71: {
                        if (!d2.isEmpty()) {
                            sb.append('(');
                        }
                        d2.push(71);
                        break;
                    }
                    case 72: {
                        if ((Integer)d2.peek() == 71) {
                            d2.pop();
                        }
                        if (!d2.isEmpty()) {
                            sb.append(')');
                            break;
                        }
                        parameterColumns.add(sb.toString().trim());
                        break;
                    }
                    case 77: {
                        if (d2.size() == 1) {
                            parameterColumns.add(sb.toString().trim());
                            sb = new StringBuilder();
                            break;
                        }
                        sb.append(',');
                        break;
                    }
                    default: {
                        sb.append(t2.getText());
                    }
                }
                if (iter.hasNext() && !d2.isEmpty()) {
                    t2 = iter.next();
                    continue;
                }
                if (iter.hasNext() || d2.isEmpty()) continue;
                SQLServerException.makeFromDriverError(null, null, SQLServerResource.getResource("R_invalidValuesList"), null, false);
            } while (!d2.isEmpty());
            return parameterColumns;
        }
        iter.previous();
        return new ArrayList<String>();
    }

    static Token skipTop(SQLServerTokenIterator iter) throws SQLServerException {
        Token t2;
        if (!iter.hasNext()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerResource.getResource("R_invalidUserSQL"), null, false);
        }
        if ((t2 = iter.next()).getType() == 26) {
            t2 = iter.next();
            if (t2.getType() == 71) {
                SQLServerParser.getRoundBracketChunk(iter);
            }
            if ((t2 = iter.next()).getType() == 28) {
                t2 = iter.next();
            }
            if (t2.getType() == 17) {
                t2 = iter.next();
                t2 = t2.getType() == 29 ? iter.next() : iter.previous();
            }
        }
        return t2;
    }

    static String getCTE(SQLServerTokenIterator iter) throws SQLServerException {
        if (iter.hasNext()) {
            Token t2 = iter.next();
            if (t2.getType() == 17) {
                StringBuilder sb = new StringBuilder("WITH ");
                SQLServerParser.getCTESegment(iter, sb);
                return sb.toString();
            }
            iter.previous();
        }
        return "";
    }

    static void getCTESegment(SQLServerTokenIterator iter, StringBuilder sb) throws SQLServerException {
        try {
            sb.append(SQLServerParser.getTableTargetChunk(iter, null, Arrays.asList(18)));
            iter.next();
            Token t2 = iter.next();
            sb.append(" AS ");
            if (t2.getType() != 71) {
                SQLServerException.makeFromDriverError(null, null, SQLServerResource.getResource("R_invalidCTEFormat"), null, false);
            }
            int leftRoundBracketCount = 0;
            do {
                sb.append(t2.getText()).append(' ');
                if (t2.getType() == 71) {
                    ++leftRoundBracketCount;
                } else if (t2.getType() == 72) {
                    --leftRoundBracketCount;
                }
                t2 = iter.next();
            } while (leftRoundBracketCount > 0);
            if (t2.getType() == 77) {
                sb.append(", ");
                SQLServerParser.getCTESegment(iter, sb);
            } else {
                iter.previous();
            }
        }
        catch (NoSuchElementException e2) {
            SQLServerException.makeFromDriverError(null, null, SQLServerResource.getResource("R_invalidCTEFormat"), null, false);
        }
    }

    private static String getTableTargetChunk(SQLServerTokenIterator iter, List<String> possibleAliases, List<Integer> delimiters) throws SQLServerException {
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            Token t2 = iter.next();
            do {
                switch (t2.getType()) {
                    case 71: {
                        sb.append(SQLServerParser.getRoundBracketChunk(iter));
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        sb.append(t2.getText());
                        t2 = iter.next();
                        if (t2.getType() != 71) {
                            SQLServerException.makeFromDriverError(null, null, SQLServerResource.getResource("R_invalidOpenqueryCall"), null, false);
                        }
                        sb.append(SQLServerParser.getRoundBracketChunk(iter));
                        break;
                    }
                    case 18: {
                        sb.append(t2.getText());
                        if (!iter.hasNext()) break;
                        String s2 = iter.next().getText();
                        if (possibleAliases != null) {
                            possibleAliases.add(s2);
                        } else {
                            SQLServerException.makeFromDriverError(null, null, SQLServerResource.getResource("R_invalidCTEFormat"), null, false);
                        }
                        sb.append(" ").append(s2);
                        break;
                    }
                    default: {
                        sb.append(t2.getText());
                    }
                }
                if (!iter.hasNext()) break;
                sb.append(' ');
            } while (!delimiters.contains((t2 = iter.next()).getType()) && t2.getType() != 78);
            if (iter.hasNext()) {
                iter.previous();
            }
        }
        return sb.toString().trim();
    }
}

