/*
 * Decompiled with CFR 0.152.
 */
package mssql.googlecode.cityhash;

public final class CityHash {
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final long k3 = -3942382747735136937L;
    private static final long kMul = -7070675565921424023L;

    private static long toLongLE(byte[] b2, int i2) {
        return ((long)b2[i2 + 7] << 56) + ((long)(b2[i2 + 6] & 0xFF) << 48) + ((long)(b2[i2 + 5] & 0xFF) << 40) + ((long)(b2[i2 + 4] & 0xFF) << 32) + ((long)(b2[i2 + 3] & 0xFF) << 24) + (long)((b2[i2 + 2] & 0xFF) << 16) + (long)((b2[i2 + 1] & 0xFF) << 8) + (long)((b2[i2 + 0] & 0xFF) << 0);
    }

    private static int toIntLE(byte[] b2, int i2) {
        return ((b2[i2 + 3] & 0xFF) << 24) + ((b2[i2 + 2] & 0xFF) << 16) + ((b2[i2 + 1] & 0xFF) << 8) + ((b2[i2 + 0] & 0xFF) << 0);
    }

    private static long fetch64(byte[] s2, int pos) {
        return CityHash.toLongLE(s2, pos);
    }

    private static int fetch32(byte[] s2, int pos) {
        return CityHash.toIntLE(s2, pos);
    }

    private static long rotate(long val, int shift) {
        return shift == 0 ? val : val >>> shift | val << 64 - shift;
    }

    private static long rotateByAtLeast1(long val, int shift) {
        return val >>> shift | val << 64 - shift;
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hash128to64(long u2, long v2) {
        long a2 = (u2 ^ v2) * -7070675565921424023L;
        a2 ^= a2 >>> 47;
        long b2 = (v2 ^ a2) * -7070675565921424023L;
        b2 ^= b2 >>> 47;
        return b2 *= -7070675565921424023L;
    }

    private static long hashLen16(long u2, long v2) {
        return CityHash.hash128to64(u2, v2);
    }

    private static long hashLen0to16(byte[] s2, int pos, int len) {
        if (len > 8) {
            long a2 = CityHash.fetch64(s2, pos + 0);
            long b2 = CityHash.fetch64(s2, pos + len - 8);
            return CityHash.hashLen16(a2, CityHash.rotateByAtLeast1(b2 + (long)len, len)) ^ b2;
        }
        if (len >= 4) {
            long a3 = 0xFFFFFFFFL & (long)CityHash.fetch32(s2, pos + 0);
            return CityHash.hashLen16((a3 << 3) + (long)len, 0xFFFFFFFFL & (long)CityHash.fetch32(s2, pos + len - 4));
        }
        if (len > 0) {
            int a4 = s2[pos + 0] & 0xFF;
            int b3 = s2[pos + (len >>> 1)] & 0xFF;
            int c2 = s2[pos + len - 1] & 0xFF;
            int y2 = a4 + (b3 << 8);
            int z2 = len + (c2 << 2);
            return CityHash.shiftMix((long)y2 * -7286425919675154353L ^ (long)z2 * -3942382747735136937L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLen17to32(byte[] s2, int pos, int len) {
        long a2 = CityHash.fetch64(s2, pos + 0) * -5435081209227447693L;
        long b2 = CityHash.fetch64(s2, pos + 8);
        long c2 = CityHash.fetch64(s2, pos + len - 8) * -7286425919675154353L;
        long d2 = CityHash.fetch64(s2, pos + len - 16) * -4348849565147123417L;
        return CityHash.hashLen16(CityHash.rotate(a2 - b2, 43) + CityHash.rotate(c2, 30) + d2, a2 + CityHash.rotate(b2 ^ 0xC949D7C7509E6557L, 20) - c2 + (long)len);
    }

    private static long[] weakHashLen32WithSeeds(long w2, long x2, long y2, long z2, long a2, long b2) {
        b2 = CityHash.rotate(b2 + (a2 += w2) + z2, 21);
        long c2 = a2;
        a2 += x2;
        return new long[]{a2 + z2, (b2 += CityHash.rotate(a2 += y2, 44)) + c2};
    }

    private static long[] weakHashLen32WithSeeds(byte[] s2, int pos, long a2, long b2) {
        return CityHash.weakHashLen32WithSeeds(CityHash.fetch64(s2, pos + 0), CityHash.fetch64(s2, pos + 8), CityHash.fetch64(s2, pos + 16), CityHash.fetch64(s2, pos + 24), a2, b2);
    }

    private static long hashLen33to64(byte[] s2, int pos, int len) {
        long z2 = CityHash.fetch64(s2, pos + 24);
        long a2 = CityHash.fetch64(s2, pos + 0) + (CityHash.fetch64(s2, pos + len - 16) + (long)len) * -4348849565147123417L;
        long b2 = CityHash.rotate(a2 + z2, 52);
        long c2 = CityHash.rotate(a2, 37);
        long vf = (a2 += CityHash.fetch64(s2, pos + 16)) + z2;
        long vs = b2 + CityHash.rotate(a2, 31) + (c2 += CityHash.rotate(a2 += CityHash.fetch64(s2, pos + 8), 7));
        a2 = CityHash.fetch64(s2, pos + 16) + CityHash.fetch64(s2, pos + len - 32);
        z2 = CityHash.fetch64(s2, pos + len - 8);
        b2 = CityHash.rotate(a2 + z2, 52);
        c2 = CityHash.rotate(a2, 37);
        long wf = (a2 += CityHash.fetch64(s2, pos + len - 16)) + z2;
        long ws = b2 + CityHash.rotate(a2, 31) + (c2 += CityHash.rotate(a2 += CityHash.fetch64(s2, pos + len - 24), 7));
        long r2 = CityHash.shiftMix((vf + ws) * -7286425919675154353L + (wf + vs) * -4348849565147123417L);
        return CityHash.shiftMix(r2 * -4348849565147123417L + vs) * -7286425919675154353L;
    }

    static long cityHash64(byte[] s2, int pos, int len) {
        if (len <= 32) {
            if (len <= 16) {
                return CityHash.hashLen0to16(s2, pos, len);
            }
            return CityHash.hashLen17to32(s2, pos, len);
        }
        if (len <= 64) {
            return CityHash.hashLen33to64(s2, pos, len);
        }
        long x2 = CityHash.fetch64(s2, pos + len - 40);
        long y2 = CityHash.fetch64(s2, pos + len - 16) + CityHash.fetch64(s2, pos + len - 56);
        long z2 = CityHash.hashLen16(CityHash.fetch64(s2, pos + len - 48) + (long)len, CityHash.fetch64(s2, pos + len - 24));
        long[] v2 = CityHash.weakHashLen32WithSeeds(s2, pos + len - 64, len, z2);
        long[] w2 = CityHash.weakHashLen32WithSeeds(s2, pos + len - 32, y2 + -5435081209227447693L, x2);
        x2 = x2 * -5435081209227447693L + CityHash.fetch64(s2, pos + 0);
        len = len - 1 & 0xFFFFFFC0;
        do {
            x2 = CityHash.rotate(x2 + y2 + v2[0] + CityHash.fetch64(s2, pos + 8), 37) * -5435081209227447693L;
            y2 = CityHash.rotate(y2 + v2[1] + CityHash.fetch64(s2, pos + 48), 42) * -5435081209227447693L;
            z2 = CityHash.rotate(z2 + w2[0], 33) * -5435081209227447693L;
            v2 = CityHash.weakHashLen32WithSeeds(s2, pos + 0, v2[1] * -5435081209227447693L, (x2 ^= w2[1]) + w2[0]);
            w2 = CityHash.weakHashLen32WithSeeds(s2, pos + 32, z2 + w2[1], (y2 += v2[0] + CityHash.fetch64(s2, pos + 40)) + CityHash.fetch64(s2, pos + 16));
            long swap = z2;
            z2 = x2;
            x2 = swap;
            pos += 64;
        } while ((len -= 64) != 0);
        return CityHash.hashLen16(CityHash.hashLen16(v2[0], w2[0]) + CityHash.shiftMix(y2) * -5435081209227447693L + z2, CityHash.hashLen16(v2[1], w2[1]) + x2);
    }

    static long cityHash64WithSeed(byte[] s2, int pos, int len, long seed) {
        return CityHash.cityHash64WithSeeds(s2, pos, len, -7286425919675154353L, seed);
    }

    static long cityHash64WithSeeds(byte[] s2, int pos, int len, long seed0, long seed1) {
        return CityHash.hashLen16(CityHash.cityHash64(s2, pos, len) - seed0, seed1);
    }

    static long[] cityMurmur(byte[] s2, int pos, int len, long seed0, long seed1) {
        long a2 = seed0;
        long b2 = seed1;
        long c2 = 0L;
        long d2 = 0L;
        int l2 = len - 16;
        if (l2 <= 0) {
            a2 = CityHash.shiftMix(a2 * -5435081209227447693L) * -5435081209227447693L;
            c2 = b2 * -5435081209227447693L + CityHash.hashLen0to16(s2, pos, len);
            d2 = CityHash.shiftMix(a2 + (len >= 8 ? CityHash.fetch64(s2, pos + 0) : c2));
        } else {
            c2 = CityHash.hashLen16(CityHash.fetch64(s2, pos + len - 8) + -5435081209227447693L, a2);
            d2 = CityHash.hashLen16(b2 + (long)len, c2 + CityHash.fetch64(s2, pos + len - 16));
            a2 += d2;
            do {
                a2 ^= CityHash.shiftMix(CityHash.fetch64(s2, pos + 0) * -5435081209227447693L) * -5435081209227447693L;
                b2 ^= (a2 *= -5435081209227447693L);
                c2 ^= CityHash.shiftMix(CityHash.fetch64(s2, pos + 8) * -5435081209227447693L) * -5435081209227447693L;
                d2 ^= (c2 *= -5435081209227447693L);
                pos += 16;
            } while ((l2 -= 16) > 0);
        }
        a2 = CityHash.hashLen16(a2, c2);
        b2 = CityHash.hashLen16(d2, b2);
        return new long[]{a2 ^ b2, CityHash.hashLen16(b2, a2)};
    }

    static long[] cityHash128WithSeed(byte[] s2, int pos, int len, long seed0, long seed1) {
        if (len < 128) {
            return CityHash.cityMurmur(s2, pos, len, seed0, seed1);
        }
        long[] v2 = new long[2];
        long[] w2 = new long[2];
        long x2 = seed0;
        long y2 = seed1;
        long z2 = -5435081209227447693L * (long)len;
        v2[0] = CityHash.rotate(y2 ^ 0xB492B66FBE98F273L, 49) * -5435081209227447693L + CityHash.fetch64(s2, pos);
        v2[1] = CityHash.rotate(v2[0], 42) * -5435081209227447693L + CityHash.fetch64(s2, pos + 8);
        w2[0] = CityHash.rotate(y2 + z2, 35) * -5435081209227447693L + x2;
        w2[1] = CityHash.rotate(x2 + CityHash.fetch64(s2, pos + 88), 53) * -5435081209227447693L;
        do {
            x2 = CityHash.rotate(x2 + y2 + v2[0] + CityHash.fetch64(s2, pos + 8), 37) * -5435081209227447693L;
            y2 = CityHash.rotate(y2 + v2[1] + CityHash.fetch64(s2, pos + 48), 42) * -5435081209227447693L;
            y2 += v2[0] + CityHash.fetch64(s2, pos + 40);
            z2 = CityHash.rotate(z2 + w2[0], 33) * -5435081209227447693L;
            v2 = CityHash.weakHashLen32WithSeeds(s2, pos + 0, v2[1] * -5435081209227447693L, (x2 ^= w2[1]) + w2[0]);
            w2 = CityHash.weakHashLen32WithSeeds(s2, pos + 32, z2 + w2[1], y2 + CityHash.fetch64(s2, pos + 16));
            long swap = z2;
            z2 = x2;
            x2 = swap;
            x2 = CityHash.rotate(x2 + y2 + v2[0] + CityHash.fetch64(s2, (pos += 64) + 8), 37) * -5435081209227447693L;
            y2 = CityHash.rotate(y2 + v2[1] + CityHash.fetch64(s2, pos + 48), 42) * -5435081209227447693L;
            y2 += v2[0] + CityHash.fetch64(s2, pos + 40);
            z2 = CityHash.rotate(z2 + w2[0], 33) * -5435081209227447693L;
            v2 = CityHash.weakHashLen32WithSeeds(s2, pos, v2[1] * -5435081209227447693L, (x2 ^= w2[1]) + w2[0]);
            w2 = CityHash.weakHashLen32WithSeeds(s2, pos + 32, z2 + w2[1], y2 + CityHash.fetch64(s2, pos + 16));
            swap = z2;
            z2 = x2;
            x2 = swap;
            pos += 64;
        } while ((len -= 128) >= 128);
        x2 += CityHash.rotate(v2[0] + z2, 49) * -4348849565147123417L;
        z2 += CityHash.rotate(w2[0], 37) * -4348849565147123417L;
        int tail_done = 0;
        while (tail_done < len) {
            y2 = CityHash.rotate(x2 + y2, 42) * -4348849565147123417L + v2[1];
            w2[0] = w2[0] + CityHash.fetch64(s2, pos + len - (tail_done += 32) + 16);
            x2 = x2 * -4348849565147123417L + w2[0];
            w2[1] = w2[1] + v2[0];
            v2 = CityHash.weakHashLen32WithSeeds(s2, pos + len - tail_done, v2[0] + (z2 += w2[1] + CityHash.fetch64(s2, pos + len - tail_done)), v2[1]);
        }
        x2 = CityHash.hashLen16(x2, v2[0]);
        y2 = CityHash.hashLen16(y2 + z2, w2[0]);
        return new long[]{CityHash.hashLen16(x2 + v2[1], w2[1]) + y2, CityHash.hashLen16(x2 + w2[1], y2 + v2[1])};
    }

    public static long[] cityHash128(byte[] s2, int pos, int len) {
        if (len >= 16) {
            return CityHash.cityHash128WithSeed(s2, pos + 16, len - 16, CityHash.fetch64(s2, pos + 0) ^ 0xC949D7C7509E6557L, CityHash.fetch64(s2, pos + 8));
        }
        if (len >= 8) {
            return CityHash.cityHash128WithSeed(new byte[0], 0, 0, CityHash.fetch64(s2, pos + 0) ^ (long)len * -4348849565147123417L, CityHash.fetch64(s2, pos + len - 8) ^ 0xB492B66FBE98F273L);
        }
        return CityHash.cityHash128WithSeed(s2, pos, len, -4348849565147123417L, -5435081209227447693L);
    }
}

