/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;
import oracle.i18n.text.converter.GDKMessage;

public class OraCharsetISO2022JP
extends OraCharset {
    static final byte REPLACEMENT_CHAR_IN_BYTE = 63;
    static final byte[] REPLACEMENT_CHAR_IN_BYTES = new byte[]{63};
    static final int ASCII_JISROMAN = 0;
    static final int JISX0208 = 1;
    static final int JISX0212 = 2;
    static final int HALF_WIDTH_KATAKANA = 3;
    static final int BUCKETSIZE = 200;

    OraCharsetISO2022JP(String string, int n2) {
        super(string, n2);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 0.5f, 1.0f);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 10.0f, 10.0f, REPLACEMENT_CHAR_IN_BYTES);
    }

    @Override
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            return this.ISO2022JPToJavaChars(byArray, n2, n3, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
    }

    @Override
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            return this.ISO2022JPToJavaChars(byArray, n2, n3, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private int getNextEscpSeq(byte[] byArray, int n2) {
        while (n2 < byArray.length) {
            if (byArray[n2] == 27) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int convertToEUCJP(byte[] byArray, ArrayList arrayList, int n2, int n3, int n4, CharacterConverterBehavior characterConverterBehavior) throws MalformedInputException {
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = null;
        if (n3 < n2) {
            throw new MalformedInputException(n2);
        }
        switch (n4) {
            case 0: {
                byArray2 = new byte[n3 - n2 + 1];
                arrayList.add(byArray2);
                n6 = n3 - n2 + 1;
                n5 = 0;
                while (n2 <= n3) {
                    if ((byArray[n2] < 32 || byArray[n2] > 126) && byArray[n2] != 13 && byArray[n2] != 10) {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = 63;
                        characterConverterBehavior.onFailConversion(n2);
                    } else {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = byArray[n2];
                    }
                    ++n2;
                    ++n5;
                }
                break;
            }
            case 1: {
                if ((n3 - n2) % 2 == 0) {
                    --n3;
                    characterConverterBehavior.onFailConversion(n2);
                }
                byArray2 = new byte[n3 - n2 + 1];
                arrayList.add(byArray2);
                n6 = n3 - n2 + 1;
                n5 = 0;
                while (n2 <= n3) {
                    if (byArray[n2] < 33 || byArray[n2] > 126) {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = -65;
                        characterConverterBehavior.onFailConversion(n2);
                    } else {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = (byte)(byArray[n2] | 0x80);
                    }
                    ++n2;
                    ++n5;
                }
                break;
            }
            case 2: {
                if ((n3 - n2) % 2 == 0) {
                    --n3;
                }
                byArray2 = new byte[(int)((double)(n3 - n2 + 1) * 1.5)];
                arrayList.add(byArray2);
                n6 = (int)((double)(n3 - n2 + 1) * 1.5);
                n5 = 0;
                while (n2 <= n3) {
                    if (n5 % 3 == 0) {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5++] = -113;
                    }
                    if (byArray[n2] < 33 || byArray[n2] > 126) {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = -65;
                        characterConverterBehavior.onFailConversion(n2);
                    } else {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = (byte)(byArray[n2] | 0x80);
                    }
                    ++n2;
                    ++n5;
                }
                break;
            }
            case 3: {
                byArray2 = new byte[(n3 - n2 + 1) * 2];
                arrayList.add(byArray2);
                n6 = (n3 - n2 + 1) * 2;
                n5 = 0;
                while (n2 <= n3) {
                    if (n5 % 2 == 0) {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5++] = -114;
                    }
                    if (byArray[n2] < 33 || byArray[n2] > 126) {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = -65;
                        characterConverterBehavior.onFailConversion(n2);
                    } else {
                        ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n5] = (byte)(byArray[n2] | 0x80);
                    }
                    ++n2;
                    ++n5;
                }
                break;
            }
        }
        return n6;
    }

    private int checkEscpSeq(byte[] byArray, int n2) throws MalformedInputException {
        if (n2 + 2 >= byArray.length) {
            return -1;
        }
        if (byArray[n2 + 1] == 40) {
            if (byArray[n2 + 2] == 66 || byArray[n2 + 2] == 74) {
                return 0;
            }
            if (byArray[n2 + 2] == 73) {
                return 3;
            }
        } else if (byArray[n2 + 1] == 36) {
            if (byArray[n2 + 2] == 64 || byArray[n2 + 2] == 66) {
                return 1;
            }
            if (byArray[n2 + 2] == 40 && byArray[n2 + 3] == 68) {
                return 2;
            }
        }
        return -1;
    }

    private String ISO2022JPToJavaChars(byte[] byArray, int n2, int n3, CharacterConverterBehavior characterConverterBehavior) throws MalformedInputException {
        int n4 = n2;
        int n5 = n2;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList(0);
        n5 = this.getNextEscpSeq(byArray, n4);
        if (n5 == -1) {
            n6 += this.convertToEUCJP(byArray, arrayList, 0, byArray.length - 1, 0, characterConverterBehavior);
            bl = true;
        } else if (n5 != 0) {
            n6 += this.convertToEUCJP(byArray, arrayList, 0, n5 - 1, 0, characterConverterBehavior);
        }
        while (!bl) {
            int n10;
            n4 = n5;
            if ((n5 = this.getNextEscpSeq(byArray, n5 + 1)) == -1) {
                n5 = byArray.length;
                bl = true;
            }
            if ((n10 = this.checkEscpSeq(byArray, n4)) == 0 || n10 == 1 || n10 == 3) {
                if (n4 + 3 == n5) continue;
                n6 += this.convertToEUCJP(byArray, arrayList, n4 + 3, n5 - 1, n10, characterConverterBehavior);
                continue;
            }
            if (n10 == 2) {
                if (n4 + 4 == n5) continue;
                n6 += this.convertToEUCJP(byArray, arrayList, n4 + 4, n5 - 1, n10, characterConverterBehavior);
                continue;
            }
            characterConverterBehavior.onFailConversion(n4);
        }
        byte[] byArray2 = new byte[n6];
        for (n7 = 0; n7 < arrayList.size(); ++n7) {
            n8 = 0;
            while (n8 < ((byte[])arrayList.get(n7)).length) {
                byArray2[n9] = ((byte[])arrayList.get(n7))[n8];
                ++n8;
                ++n9;
            }
        }
        try {
            return new String(byArray2, "EUCJP");
        }
        catch (Exception exception) {
            characterConverterBehavior.onFailConversion(0);
            return new String("");
        }
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        try {
            return this.JavaCharsToISO2022JP(string, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        try {
            return this.JavaCharsToISO2022JP(string, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    private static int insertToBucket(int n2, ArrayList arrayList, byte[] byArray) {
        if (n2 + byArray.length - 1 >= 200) {
            int n3 = 0;
            while (n3 < byArray.length) {
                if (n2 >= 200) {
                    byte[] byArray2 = new byte[200];
                    arrayList.add(byArray2);
                    n2 = 0;
                }
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n2] = byArray[n3];
                ++n3;
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < byArray.length) {
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n2] = byArray[n4];
                ++n4;
                ++n2;
            }
        }
        return n2;
    }

    private static int insertEscSeq(int n2, ArrayList arrayList, int n3) {
        byte[] byArray = null;
        if (n3 == 0) {
            byArray = new byte[]{27, 40, 66};
        } else if (n3 == 1) {
            byArray = new byte[]{27, 36, 66};
        } else if (n3 == 2) {
            byArray = new byte[]{27, 36, 40, 68};
        } else if (n3 == 3) {
            byArray = new byte[]{27, 40, 73};
        }
        return OraCharsetISO2022JP.insertToBucket(n2, arrayList, byArray);
    }

    private byte[] JavaCharsToISO2022JP(String string, CharacterConverterBehavior characterConverterBehavior) throws MalformedInputException {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(0);
        byte[] byArray = null;
        byte[] byArray2 = new byte[200];
        arrayList.add(byArray2);
        try {
            byArray = string.getBytes("X-ORACLE-JA16EUC");
        }
        catch (Exception exception) {
            characterConverterBehavior.onFailConversion(n4);
            return new byte[0];
        }
        n4 = 0;
        while (n4 < byArray.length) {
            if (byArray[n4] >= 32 && byArray[n4] <= 126 || byArray[n4] == 10 || byArray[n4] == 13) {
                if (n2 != 0) {
                    if (n4 != 0) {
                        n3 = OraCharsetISO2022JP.insertEscSeq(n3, arrayList, 0);
                        n5 += 3;
                    }
                    n2 = 0;
                }
                n3 = OraCharsetISO2022JP.insertToBucket(n3, arrayList, new byte[]{byArray[n4]});
                ++n4;
                ++n5;
                continue;
            }
            if (byArray[n4] >= -95 && byArray[n4] <= -2) {
                if (n2 != 1) {
                    n3 = OraCharsetISO2022JP.insertEscSeq(n3, arrayList, 1);
                    n2 = 1;
                    n5 += 3;
                }
                n3 = OraCharsetISO2022JP.insertToBucket(n3, arrayList, new byte[]{(byte)(byArray[n4] & 0x7F), (byte)(byArray[n4 + 1] & 0x7F)});
                n4 += 2;
                n5 += 2;
                continue;
            }
            if (byArray[n4] == -114) {
                if (n2 != 3) {
                    n3 = OraCharsetISO2022JP.insertEscSeq(n3, arrayList, 3);
                    n2 = 3;
                    n5 += 3;
                }
                n3 = OraCharsetISO2022JP.insertToBucket(n3, arrayList, new byte[]{(byte)(byArray[n4 + 1] & 0x7F)});
                n4 += 2;
                ++n5;
                continue;
            }
            if (byArray[n4] == -113) {
                if (n2 != 2) {
                    n3 = OraCharsetISO2022JP.insertEscSeq(n3, arrayList, 2);
                    n2 = 2;
                    n5 += 4;
                }
                n3 = OraCharsetISO2022JP.insertToBucket(n3, arrayList, new byte[]{(byte)(byArray[n4 + 1] & 0x7F), (byte)(byArray[n4 + 2] & 0x7F)});
                n4 += 3;
                n5 += 2;
                continue;
            }
            characterConverterBehavior.onFailConversion(n4);
            ++n4;
        }
        if (n2 != 0) {
            n3 = OraCharsetISO2022JP.insertEscSeq(n3, arrayList, 0);
            n5 += 3;
        }
        byte[] byArray3 = new byte[n5];
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            int n9 = (n5 - n8) / 200 > 0 ? 200 : n5 % 200;
            n7 = 0;
            while (n7 < n9) {
                byArray3[n8] = ((byte[])arrayList.get(n6))[n7];
                ++n7;
                ++n8;
            }
        }
        return byArray3;
    }

    private static abstract class CharacterConverterBehavior {
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior(){

            @Override
            public void onFailConversion(int n2) throws MalformedInputException {
                throw new MalformedInputException(n2);
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior(){

            @Override
            public void onFailConversion(int n2) throws MalformedInputException {
            }
        };

        public abstract void onFailConversion(int var1) throws MalformedInputException;
    }
}

