/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverter12Byte
extends CharacterConverterOGS {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int BYTEWIDTH = 8;
    static final short MAX_7BIT = 127;
    protected static int MAXLIMIT = 42000;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public char[] m_displayWidthLevel1 = null;
    public byte[] m_displayWidthLevel2 = null;
    public int[] m_oraCharLevel1 = null;
    public int[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';

    public CharacterConverter12Byte() {
        this.m_groupId = 1;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 2.0f;
    }

    int toUnicode(int n2) throws SQLException {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        if (this.m_ucsCharLevel1[n3] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n5 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4];
        return n5;
    }

    int toUnicodeWithReplacement(int n2) {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = this.m_ucsCharLevel1[n3] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] : this.m_ucsCharReplacement;
        return n5;
    }

    private int toUnicodeNoException(int n2) {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        if (this.m_ucsCharLevel1[n3] != '\uffff') {
            return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4];
        }
        return -1;
    }

    @Override
    public int getDisplayWidth(int n2, boolean bl) throws UnsupportedEncodingException, SQLException {
        byte by;
        char[] cArray = this.parseUnicodeCodePoint(n2);
        char c2 = bl ? this.toOracleCharacterWithReplacement(cArray[0], cArray[1]) : this.toOracleCharacter(cArray[0], cArray[1]);
        if (this.m_displayWidthLevel1 == null || this.m_displayWidthLevel2 == null) {
            return this.getDefaultDisplayWidth(c2);
        }
        int n3 = c2 >> 8 & 0xFF;
        int n4 = c2 & 0xFF;
        if (this.m_displayWidthLevel1[n3] != '\uffff' && (by = this.m_displayWidthLevel2[this.m_displayWidthLevel1[n3] + n4]) != -1) {
            return by;
        }
        return this.getDefaultDisplayWidth(c2);
    }

    char toOracleCharacter(char c2, char c3) throws SQLException {
        char c4 = '\uffff';
        if (c3 != '\u0000') {
            int n2 = c2 >>> 8 & 0xFF;
            int n3 = c2 & 0xFF;
            int n4 = c3 >>> 8 & 0xFF;
            int n5 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c2 >>> 8 & 0xFF;
            int n7 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n6] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (c4 == '\uffff') {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        return c4;
    }

    char toOracleCharacterWithReplacement(char c2, char c3) {
        char c4 = '\uffff';
        if (c3 != '\u0000') {
            int n2 = c2 >>> 8 & 0xFF;
            int n3 = c2 & 0xFF;
            int n4 = c3 >>> 8 & 0xFF;
            int n5 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c2 >>> 8 & 0xFF;
            int n7 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n6] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (c4 == '\uffff') {
            if (c2 > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return c4;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        char[] cArray = new char[n3 * 2];
        int n5 = 0;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n6;
            int n7 = byArray[i2] & 0xFF;
            if (n7 > 127) {
                if (i2 < n4 - 1) {
                    n7 = byArray[i2] << 8 & 0xFF00 | byArray[i2 + 1] & 0xFF;
                    ++i2;
                } else {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
            }
            if (((long)(n6 = this.toUnicode(n7)) & 0xFFFFFFFFL) > 65535L) {
                cArray[n5++] = (char)(n6 >>> 16);
                cArray[n5++] = (char)(n6 & 0xFFFF);
                continue;
            }
            cArray[n5++] = (char)n6;
        }
        return new String(cArray, 0, n5);
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        char[] cArray = new char[n3 * 2];
        int n5 = 0;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n6;
            int n7 = byArray[i2] & 0xFF;
            if (n7 > 127) {
                if (n4 - i2 < 2) break;
                n7 = byArray[i2] << 8 & 0xFF00 | byArray[i2 + 1] & 0xFF;
                ++i2;
            }
            if (((long)(n6 = this.toUnicodeWithReplacement(n7)) & 0xFFFFFFFFL) > 65535L) {
                cArray[n5++] = (char)(n6 >>> 16);
                cArray[n5++] = (char)(n6 & 0xFFFF);
                continue;
            }
            cArray[n5++] = (char)n6;
        }
        return new String(cArray, 0, n5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            if (cArray[i2] >= '\ud800' && cArray[i2] < '\udc00') {
                if (i2 + 1 >= n2 || cArray[i2 + 1] < '\udc00' || cArray[i2 + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                c2 = this.toOracleCharacterWithReplacement(cArray[i2], cArray[i2 + 1]);
                ++i2;
            } else {
                c2 = this.toOracleCharacter(cArray[i2], '\u0000');
            }
            if (c2 >> 8 != 0) {
                byArray[n3++] = (byte)(c2 >> 8);
                byArray[n3++] = (byte)c2;
                continue;
            }
            byArray[n3++] = (byte)c2;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte[] toOracleStringWithReplacement(char[] cArray, int n2, byte[] byArray, int n3, int[] nArray) {
        int n4;
        byte[] byArray2;
        int n5 = nArray[0];
        int n6 = 65535;
        int n7 = n2 + n5;
        if (byArray != null) {
            byArray2 = byArray;
            n4 = n3;
        } else {
            byArray2 = new byte[n5 * 4];
            n4 = 0;
            n3 = 0;
        }
        for (int i2 = n2; i2 < n7; ++i2) {
            block8: {
                if (cArray[i2] >= '\ud800' && cArray[i2] < '\udc00') {
                    if (i2 + 1 < n7 && cArray[i2 + 1] >= '\udc00' && cArray[i2 + 1] <= '\udfff') {
                        n6 = this.toOracleCharacterWithReplacement(cArray[i2], cArray[i2 + 1]);
                        ++i2;
                        break block8;
                    } else {
                        byArray2[n4++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray2[n4++] = (byte)this.m_2ByteOraCharReplacement;
                        continue;
                    }
                }
                n6 = this.toOracleCharacterWithReplacement(cArray[i2], '\u0000');
            }
            if (n6 >> 8 != 0) {
                byArray2[n4++] = (byte)(n6 >> 8);
                byArray2[n4++] = (byte)n6;
                continue;
            }
            byArray2[n4++] = (byte)n6;
        }
        nArray[0] = n4 - n3;
        if (byArray == null && n4 < byArray2.length) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            return byArray3;
        }
        return byArray2;
    }

    @Override
    protected boolean isOraCharacterReplacement(char c2, char c3) {
        char c4 = this.toOracleCharacterWithReplacement(c2, c3);
        return c4 == this.getOraChar1ByteRep() || c4 == this.getOraChar2ByteRep();
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        char[] cArray;
        int n7;
        int n8;
        Object object;
        int n9;
        this.m_oraCharLevel1 = new int[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector<int[]> vector = new Vector<int[]>(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n10 = 0;
        int n11 = 0;
        for (n9 = 0; n9 < 256; ++n9) {
            this.m_oraCharLevel1[n9] = -1;
        }
        for (n9 = 0; n9 < 65535; ++n9) {
            int n12 = this.toUnicodeNoException(n9);
            if (n12 == -1) continue;
            object = new int[]{n12, n9};
            vector.addElement((int[])object);
            this.storeMappingRange(n12, hashtable, hashtable2);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n8 = this.extraUnicodeToOracleMapping.length;
            for (n9 = 0; n9 < n8; ++n9) {
                n7 = this.extraUnicodeToOracleMapping[n9][0];
                this.storeMappingRange(n7, hashtable, hashtable2);
            }
        }
        Enumeration enumeration = hashtable.keys();
        int n13 = 0;
        int n14 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n13 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n14 += 256;
        }
        if (n13 != 0) {
            this.m_oraCharSurrogateLevel = new int[n13];
        }
        if (n14 != 0) {
            this.m_oraCharLevel2 = new char[n14];
        }
        for (n6 = 0; n6 < n13; ++n6) {
            this.m_oraCharSurrogateLevel[n6] = -1;
        }
        for (n6 = 0; n6 < n14; ++n6) {
            this.m_oraCharLevel2[n6] = 65535;
        }
        for (n6 = 0; n6 < vector.size(); ++n6) {
            int[] nArray = (int[])vector.elementAt(n6);
            n5 = nArray[0] >> 24 & 0xFF;
            n4 = nArray[0] >> 16 & 0xFF;
            n3 = nArray[0] >> 8 & 0xFF;
            n2 = nArray[0] & 0xFF;
            if (n5 >= 216 && n5 < 220) {
                if (this.m_oraCharLevel1[n5] == -1) {
                    this.m_oraCharLevel1[n5] = n11;
                    n11 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = n11;
                    n11 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = n10;
                    n10 += 256;
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] != '\uffff') continue;
                this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(nArray[1] & 0xFFFF);
                continue;
            }
            if (this.m_oraCharLevel1[n3] == -1) {
                this.m_oraCharLevel1[n3] = n10;
                n10 += 256;
            }
            if (this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] != '\uffff') continue;
            this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(nArray[1] & 0xFFFF);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n8 = this.extraUnicodeToOracleMapping.length;
            for (n6 = 0; n6 < n8; ++n6) {
                n7 = this.extraUnicodeToOracleMapping[n6][0];
                n5 = n7 >>> 24 & 0xFF;
                n4 = n7 >>> 16 & 0xFF;
                n3 = n7 >>> 8 & 0xFF;
                n2 = n7 & 0xFF;
                if (n5 >= 216 && n5 < 220) {
                    if (this.m_oraCharLevel1[n5] == -1) {
                        this.m_oraCharLevel1[n5] = n11;
                        n11 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = n11;
                        n11 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = n10;
                        n10 += 256;
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n6][1] & 0xFFFF);
                    continue;
                }
                if (this.m_oraCharLevel1[n3] == -1) {
                    this.m_oraCharLevel1[n3] = n10;
                    n10 += 256;
                }
                this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n6][1] & 0xFFFF);
            }
        }
    }

    @Override
    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        int n3 = 65535;
        for (int i2 = n2; i2 <= n3; ++i2) {
            try {
                int[] nArray = new int[]{i2, this.toUnicode(i2)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        for (int i2 = 0; i2 < this.extraUnicodeToOracleMapping.length; ++i2) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[i2][0], this.extraUnicodeToOracleMapping[i2][1]};
            vector.addElement(nArray);
        }
    }

    @Override
    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    @Override
    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    @Override
    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    @Override
    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public int ByteToCharConvert(byte[] byArray, int n2, int n3, char[] cArray, int n4, int n5) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public int toUnicodeCharsWithReplacement(byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        return 0;
    }
}

