/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterLC;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterJAEUC
extends CharacterConverterLC {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int LEADINGCODE = 143;

    public CharacterConverterJAEUC() {
        this.m_groupId = 2;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    @Override
    int toUnicode(int n2) throws SQLException {
        int n3 = 0;
        if ((n2 >> 16 & 0xFFFF) == 143) {
            n3 = 256;
        }
        int n4 = n2 >> 8 & 255 + n3;
        int n5 = n2 & 0xFF;
        if (this.m_ucsCharLevel1[n4] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] != -1) {
            return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5];
        }
        throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
    }

    @Override
    int toUnicodeWithReplacement(int n2) {
        int n3 = 0;
        if ((n2 >> 16 & 0xFFFF) == 143) {
            n3 = 256;
        }
        int n4 = n2 >> 8 & 255 + n3;
        int n5 = n2 & 0xFF;
        int n6 = this.m_ucsCharLevel1[n4] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] : this.m_ucsCharReplacement;
        return n6;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        char[] cArray = new char[n3 * 2];
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            int n6 = byArray[n2] & 0xFF;
            int n7 = 0;
            if (n6 == 143) {
                if (n3 < 3) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                n6 = byArray[n2 + 1] << 8 & 0xFF00 | byArray[n2 + 2] & 0xFF;
                n5 = 3;
                n7 = 256;
            } else if (n6 > 127) {
                if (n3 < 2) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                n6 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
                n5 = 2;
            } else {
                n5 = 1;
            }
            int n8 = (n6 >> 8 & 0xFF) + n7;
            int n9 = n6 & 0xFF;
            if (this.m_ucsCharLevel1[n8] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9] == -1) {
                throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
            }
            int n10 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9];
            if (((long)n10 & 0xFFFFFFFFL) > 65535L) {
                cArray[n4++] = (char)(n10 >>> 16);
                cArray[n4++] = (char)(n10 & 0xFFFF);
            } else {
                cArray[n4++] = (char)n10;
            }
            n3 -= n5;
            n2 += n5;
        }
        return new String(cArray, 0, n4);
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[n3 * 2];
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            int n6 = byArray[n2] & 0xFF;
            int n7 = 0;
            if (n6 == 143) {
                if (n3 < 3) break;
                n6 = byArray[n2 + 1] << 8 & 0xFF00 | byArray[n2 + 2] & 0xFF;
                n5 = 3;
                n7 = 256;
            } else if (n6 > 127) {
                if (n3 < 2) break;
                n6 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
                n5 = 2;
            } else {
                n5 = 1;
            }
            int n8 = (n6 >> 8 & 0xFF) + n7;
            int n9 = n6 & 0xFF;
            int n10 = this.m_ucsCharLevel1[n8] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n8] + n9] : this.m_ucsCharReplacement;
            if (((long)n10 & 0xFFFFFFFFL) > 65535L) {
                cArray[n4++] = (char)(n10 >>> 16);
                cArray[n4++] = (char)(n10 & 0xFFFF);
            } else {
                cArray[n4++] = (char)n10;
            }
            n3 -= n5;
            n2 += n5;
        }
        return new String(cArray, 0, n4);
    }

    @Override
    public void extractCodepoints(Vector vector) {
        int[] nArray;
        int n2;
        int n3 = 0;
        int n4 = 65535;
        for (n2 = n3; n2 <= n4; ++n2) {
            try {
                nArray = new int[]{n2, this.toUnicode(n2)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        n3 = 0x8F0000;
        n4 = n3 + 65535;
        for (n2 = n3; n2 <= n4; ++n2) {
            try {
                nArray = new int[]{n2, this.toUnicode(n2)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public int ByteToCharConvert(byte[] byArray, int n2, int n3, char[] cArray, int n4, int n5) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public int toUnicodeCharsWithReplacement(byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        return 0;
    }
}

