/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public abstract class CharacterConverterLC
extends CharacterConverterOGS {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int MAX_7BIT = 127;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int ORACHARWITHLCWIDTH = 32;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int LOW16BITMASK = 65535;
    static final int LEADINGCODEWIDTH = 16;
    static final int LEADINGCODESHIFT = 16;
    static final int LEADINGCODEMASK = 65535;
    static final int LCINDEXWIDTH = 4;
    static final int LCINDEXMASK = 15;
    static final int LCINDEXFACTOR = 2;
    static final int MAXBYTEPERCHAR = 4;
    public char[][] m_ucsCharLeadingCode = null;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    public char[] m_displayWidthLevel1 = null;
    public byte[] m_displayWidthLevel2 = null;
    public char[][] m_displayWidthLeadingCode = null;
    public char[] m_oraCharLevel1 = null;
    public int[] m_oraCharLevel2 = null;
    public char[] m_oraCharSurrogateLevel = null;

    CharacterConverterLC() {
        this.m_groupId = 8;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    @Override
    public char[] getLeadingCodes() {
        char[] cArray = new char[this.m_ucsCharLeadingCode.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = this.m_ucsCharLeadingCode[i2][0];
        }
        return cArray;
    }

    int toUnicode(int n2) throws SQLException {
        int n3;
        int n4 = 0;
        int n5 = n2 >> 16 & 0xFFFF;
        for (n3 = 0; n3 < this.m_ucsCharLeadingCode.length; ++n3) {
            if (n5 != this.m_ucsCharLeadingCode[n3][0]) continue;
            n4 = this.m_ucsCharLeadingCode[n3][1];
            break;
        }
        if (n3 == this.m_ucsCharLeadingCode.length) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n6 = (n2 >> 8 & 0xFF) + n4;
        int n7 = n2 & 0xFF;
        if (this.m_ucsCharLevel1[n6] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        int n8 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7];
        return n8;
    }

    int toUnicodeWithReplacement(int n2) {
        int n3;
        int n4 = 0;
        int n5 = n2 >> 16 & 0xFFFF;
        for (n3 = 0; n3 < this.m_ucsCharLeadingCode.length; ++n3) {
            if (n5 != this.m_ucsCharLeadingCode[n3][0]) continue;
            n4 = this.m_ucsCharLeadingCode[n3][1];
            break;
        }
        if (n3 == this.m_ucsCharLeadingCode.length) {
            return this.m_ucsCharReplacement;
        }
        int n6 = (n2 >> 8 & 0xFF) + n4;
        int n7 = n2 & 0xFF;
        int n8 = this.m_ucsCharLevel1[n6] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] : this.m_ucsCharReplacement;
        return n8;
    }

    @Override
    public int getDisplayWidth(int n2, boolean bl) throws UnsupportedEncodingException, SQLException {
        byte by;
        int n3;
        char[] cArray = this.parseUnicodeCodePoint(n2);
        int n4 = bl ? this.toOracleCharacterWithReplacement(cArray[0], cArray[1]) : this.toOracleCharacter(cArray[0], cArray[1]);
        if (this.m_displayWidthLevel1 == null || this.m_displayWidthLevel2 == null) {
            return this.getDefaultDisplayWidth(n4);
        }
        int n5 = 0;
        int n6 = n4 >> 16 & 0xFFFF;
        for (n3 = 0; n3 < this.m_displayWidthLeadingCode.length; ++n3) {
            if (n6 != this.m_displayWidthLeadingCode[n3][0]) continue;
            n5 = this.m_displayWidthLeadingCode[n3][1];
            break;
        }
        if (n3 == this.m_displayWidthLeadingCode.length) {
            return this.getDefaultDisplayWidth(n4);
        }
        int n7 = (n4 >> 8 & 0xFF) + n5;
        int n8 = n4 & 0xFF;
        if (this.m_displayWidthLevel1[n7] != '\uffff' && (by = this.m_displayWidthLevel2[this.m_displayWidthLevel1[n7] + n8]) != -1) {
            return by;
        }
        return this.getDefaultDisplayWidth(n4);
    }

    int toOracleCharacter(char c2, char c3) throws SQLException {
        int n2 = -1;
        if (c3 != '\u0000') {
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = c3 >>> 8 & 0xFF;
            int n6 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6];
            }
        } else {
            int n7 = c2 >>> 8 & 0xFF;
            int n8 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n7] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8];
            }
        }
        if (n2 == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        return n2;
    }

    int toOracleCharacterWithReplacement(char c2, char c3) {
        int n2 = -1;
        if (c3 != '\u0000') {
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = c3 >>> 8 & 0xFF;
            int n6 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6];
            }
        } else {
            int n7 = c2 >>> 8 & 0xFF;
            int n8 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n7] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8];
            }
        }
        if (n2 == -1) {
            if (c2 > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            if (cArray[i2] >= '\ud800' && cArray[i2] < '\udc00') {
                if (i2 + 1 >= n2 || cArray[i2 + 1] < '\udc00' || cArray[i2 + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                n4 = this.toOracleCharacterWithReplacement(cArray[i2], cArray[i2 + 1]);
                ++i2;
            } else {
                n4 = this.toOracleCharacter(cArray[i2], '\u0000');
            }
            if (n4 >> 24 != 0) {
                byArray[n3++] = (byte)(n4 >> 24);
                byArray[n3++] = (byte)(n4 >> 16);
                byArray[n3++] = (byte)(n4 >> 8);
                byArray[n3++] = (byte)n4;
                continue;
            }
            if (n4 >> 16 != 0) {
                byArray[n3++] = (byte)(n4 >> 16);
                byArray[n3++] = (byte)(n4 >> 8);
                byArray[n3++] = (byte)n4;
                continue;
            }
            if (n4 >> 8 != 0) {
                byArray[n3++] = (byte)(n4 >> 8);
                byArray[n3++] = (byte)n4;
                continue;
            }
            byArray[n3++] = (byte)n4;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public byte[] toOracleStringWithReplacement(char[] cArray, int n2, byte[] byArray, int n3, int[] nArray) {
        int n4;
        byte[] byArray2;
        int n5 = nArray[0];
        int n6 = n2 + n5;
        if (byArray != null) {
            byArray2 = byArray;
            n4 = n3;
        } else {
            byArray2 = new byte[n5 * 4];
            n4 = 0;
            n3 = 0;
        }
        for (int i2 = n2; i2 < n6; ++i2) {
            int n7;
            block10: {
                if (cArray[i2] >= '\ud800' && cArray[i2] <= '\udbff') {
                    if (i2 + 1 < n6 && cArray[i2 + 1] >= '\udc00' && cArray[i2 + 1] <= '\udfff') {
                        n7 = this.toOracleCharacterWithReplacement(cArray[i2], cArray[i2 + 1]);
                        ++i2;
                        break block10;
                    } else {
                        byArray2[n4++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray2[n4++] = (byte)this.m_2ByteOraCharReplacement;
                        continue;
                    }
                }
                n7 = this.toOracleCharacterWithReplacement(cArray[i2], '\u0000');
            }
            if (n7 >> 24 != 0) {
                byArray2[n4++] = (byte)(n7 >> 24);
                byArray2[n4++] = (byte)(n7 >> 16);
                byArray2[n4++] = (byte)(n7 >> 8);
                byArray2[n4++] = (byte)n7;
                continue;
            }
            if (n7 >> 16 != 0) {
                byArray2[n4++] = (byte)(n7 >> 16);
                byArray2[n4++] = (byte)(n7 >> 8);
                byArray2[n4++] = (byte)n7;
                continue;
            }
            if (n7 >> 8 != 0) {
                byArray2[n4++] = (byte)(n7 >> 8);
                byArray2[n4++] = (byte)n7;
                continue;
            }
            byArray2[n4++] = (byte)n7;
        }
        nArray[0] = n4 - n3;
        if (byArray == null && n4 < byArray2.length) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            return byArray3;
        }
        return byArray2;
    }

    @Override
    protected boolean isOraCharacterReplacement(char c2, char c3) {
        int n2 = this.toOracleCharacterWithReplacement(c2, c3);
        return n2 == this.getOraChar1ByteRep() || n2 == this.getOraChar2ByteRep();
    }

    @Override
    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object[] objectArray;
        int n9;
        this.m_oraCharLevel1 = new char[256];
        char[] cArray = null;
        int[] nArray = null;
        Vector<char[]> vector = new Vector<char[]>(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        char c2 = '\u0000';
        char c3 = '\u0000';
        for (n9 = 0; n9 < 256; ++n9) {
            this.m_oraCharLevel1[n9] = 65535;
        }
        for (n9 = 0; n9 < this.m_ucsCharLeadingCode.length; ++n9) {
            int n10 = this.m_ucsCharLeadingCode[n9][0] << 16;
            for (int i2 = 0; i2 < 65535; ++i2) {
                int n11 = this.toUnicodeWithReplacement(n10 | i2);
                if (n11 == this.m_ucsCharReplacement) continue;
                objectArray = new int[2];
                objectArray[0] = n11;
                objectArray[1] = n10 | i2;
                vector.addElement((char[])objectArray);
                this.storeMappingRange(n11, hashtable, hashtable2);
            }
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n8 = this.extraUnicodeToOracleMapping.length;
            for (n9 = 0; n9 < n8; ++n9) {
                n7 = this.extraUnicodeToOracleMapping[n9][0];
                this.storeMappingRange(n7, hashtable, hashtable2);
            }
        }
        Enumeration enumeration = hashtable.keys();
        int n12 = 0;
        int n13 = 0;
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            objectArray = (char[])hashtable.get(k2);
            if (objectArray == null) continue;
            n12 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k3 = enumeration.nextElement();
            objectArray = (char[])hashtable2.get(k3);
            if (objectArray == null) continue;
            n13 += 256;
        }
        if (n12 != 0) {
            cArray = new char[n12];
        }
        if (n13 != 0) {
            nArray = new int[n13];
        }
        for (n6 = 0; n6 < n12; ++n6) {
            cArray[n6] = 65535;
        }
        for (n6 = 0; n6 < n13; ++n6) {
            nArray[n6] = -1;
        }
        for (n6 = 0; n6 < vector.size(); ++n6) {
            int[] nArray2 = (int[])vector.elementAt(n6);
            n5 = nArray2[0] >>> 24 & 0xFF;
            n4 = nArray2[0] >>> 16 & 0xFF;
            n3 = nArray2[0] >>> 8 & 0xFF;
            n2 = nArray2[0] & 0xFF;
            if (n5 >= 216 && n5 < 220) {
                if (this.m_oraCharLevel1[n5] == '\uffff') {
                    this.m_oraCharLevel1[n5] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (cArray[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                    cArray[this.m_oraCharLevel1[n5] + n4] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (cArray[cArray[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                    cArray[cArray[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (nArray[cArray[cArray[this.m_oraCharLevel1[n5] + n4] + n3] + n2] != -1) continue;
                nArray[cArray[cArray[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = nArray2[1];
                continue;
            }
            if (this.m_oraCharLevel1[n3] == '\uffff') {
                this.m_oraCharLevel1[n3] = c2;
                c2 = (char)(c2 + 256);
            }
            if (nArray[this.m_oraCharLevel1[n3] + n2] != -1) continue;
            nArray[this.m_oraCharLevel1[n3] + n2] = nArray2[1];
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n8 = this.extraUnicodeToOracleMapping.length;
            for (n6 = 0; n6 < n8; ++n6) {
                n7 = this.extraUnicodeToOracleMapping[n6][0];
                n5 = n7 >>> 24 & 0xFF;
                n4 = n7 >>> 16 & 0xFF;
                n3 = n7 >>> 8 & 0xFF;
                n2 = n7 & 0xFF;
                if (n5 >= 216 && n5 < 220) {
                    if (this.m_oraCharLevel1[n5] == '\uffff') {
                        this.m_oraCharLevel1[n5] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (cArray[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                        cArray[this.m_oraCharLevel1[n5] + n4] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (cArray[cArray[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                        cArray[cArray[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    nArray[cArray[cArray[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = this.extraUnicodeToOracleMapping[n6][1];
                    continue;
                }
                if (this.m_oraCharLevel1[n3] == '\uffff') {
                    this.m_oraCharLevel1[n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                nArray[this.m_oraCharLevel1[n3] + n2] = this.extraUnicodeToOracleMapping[n6][1];
            }
        }
        this.m_oraCharLevel2 = nArray;
        this.m_oraCharSurrogateLevel = cArray;
    }

    @Override
    public void extractCodepoints(Vector vector) {
        for (int i2 = 0; i2 < this.m_ucsCharLeadingCode.length; ++i2) {
            char c2 = this.m_ucsCharLeadingCode[i2][0];
            int n2 = c2 << 16;
            int n3 = n2 + 65535;
            for (int i3 = n2; i3 <= n3; ++i3) {
                try {
                    int[] nArray = new int[]{i3, this.toUnicode(i3)};
                    vector.addElement(nArray);
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        for (int i2 = 0; i2 < this.extraUnicodeToOracleMapping.length; ++i2) {
            vector.addElement(this.extraUnicodeToOracleMapping[i2]);
        }
    }

    @Override
    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    @Override
    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    @Override
    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    @Override
    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }
}

