/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.util.ResourceBundle;

public class GDKMessage {
    private static final String M_C_MESSAGEFILE = "oracle.i18n.text.converter.Messages";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.i18n.text.converter.Messages");
    private static final String GDK_PREFIX = "GDK";
    private static final String ORA_PREFIX = "ORA";
    private static final String KEY_BASE = "00000";
    private static final int KEY_LENGTH = "00000".length();
    public static final int CHARSET_NOT_SUPPORTED = 17035;
    public static final int FAIL_CONV_UTF8_UCS2 = 17037;
    public static final int NON_SUPPORTED_ADD_GDK = 17056;
    public static final int CANNOT_MAP_ORA_UNICODE = 17154;
    public static final int CANNOT_MAP_UNICODE_ORA = 17155;
    public static final int INVALID_UNICODE_SURROGATE = 7002;

    private GDKMessage() {
    }

    private static String msg(String string, Object object) {
        try {
            if (object != null) {
                return bundle.getString(string) + ": " + object;
            }
            return bundle.getString(string);
        }
        catch (Exception exception) {
            return "Message [" + string + "] not found in '" + M_C_MESSAGEFILE + "'.";
        }
    }

    public static String getMessage(String string, Object object) {
        return "GDK-" + string + ": " + GDKMessage.msg(string, object);
    }

    public static String getMessage(int n2) {
        return GDKMessage.getMessage(n2, null);
    }

    public static String getMessage(int n2, Object object) {
        String string = new Integer(n2).toString();
        if (string.length() < KEY_LENGTH) {
            string = KEY_BASE.substring(string.length()) + string;
        }
        return GDKMessage.getMessage(string, object);
    }

    public static String getORAMessage(int n2) {
        String string = new Integer(n2).toString();
        if (string.length() < KEY_LENGTH) {
            string = KEY_BASE.substring(string.length()) + string;
        }
        return "ORA-" + string + ": " + GDKMessage.msg(string, null);
    }
}

