/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.map.AbstractLinkedMap;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.AbstractFilesCache;
import org.apache.commons.vfs2.util.Messages;

public class LRUFilesCache
extends AbstractFilesCache {
    private static final int DEFAULT_LRU_SIZE = 100;
    private static final Log log = LogFactory.getLog(LRUFilesCache.class);
    private final ConcurrentMap<FileSystem, Map<FileName, FileObject>> filesystemCache = new ConcurrentHashMap<FileSystem, Map<FileName, FileObject>>(10);
    private final int lruSize;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public LRUFilesCache() {
        this(100);
    }

    public LRUFilesCache(int lruSize) {
        this.lruSize = lruSize;
    }

    @Override
    public void putFile(FileObject file) {
        Map<FileName, FileObject> files = this.getOrCreateFilesystemCache(file.getFileSystem());
        this.writeLock.lock();
        try {
            files.put(file.getName(), file);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putFileIfAbsent(FileObject file) {
        Map<FileName, FileObject> files = this.getOrCreateFilesystemCache(file.getFileSystem());
        this.writeLock.lock();
        try {
            FileName name = file.getName();
            if (files.containsKey(name)) {
                boolean bl = false;
                return bl;
            }
            files.put(name, file);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject getFile(FileSystem filesystem, FileName name) {
        Map<FileName, FileObject> files = this.getOrCreateFilesystemCache(filesystem);
        this.readLock.lock();
        try {
            FileObject fileObject = files.get(name);
            return fileObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clear(FileSystem filesystem) {
        Map<FileName, FileObject> files = this.getOrCreateFilesystemCache(filesystem);
        this.writeLock.lock();
        try {
            files.clear();
            this.filesystemCache.remove(filesystem);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected Map<FileName, FileObject> getOrCreateFilesystemCache(FileSystem filesystem) {
        Object files = (Map)this.filesystemCache.get(filesystem);
        if (files == null) {
            files = new MyLRUMap(filesystem, this.lruSize);
            this.filesystemCache.putIfAbsent(filesystem, (Map<FileName, FileObject>)files);
        }
        return files;
    }

    @Override
    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(FileSystem filesystem, FileName name) {
        Map<FileName, FileObject> files = this.getOrCreateFilesystemCache(filesystem);
        this.writeLock.lock();
        try {
            files.remove(name);
            if (files.isEmpty()) {
                this.filesystemCache.remove(filesystem);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void touchFile(FileObject file) {
        this.getFile(file.getFileSystem(), file.getName());
    }

    private class MyLRUMap
    extends LRUMap<FileName, FileObject> {
        private static final long serialVersionUID = 20101208L;
        private final FileSystem filesystem;

        public MyLRUMap(FileSystem filesystem, int size) {
            super(size, true);
            this.filesystem = filesystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry<FileName, FileObject> linkEntry) {
            LRUFilesCache lRUFilesCache = LRUFilesCache.this;
            synchronized (lRUFilesCache) {
                FileObject fileObject = (FileObject)linkEntry.getValue();
                if (fileObject.isAttached() || fileObject.isContentOpen()) {
                    return false;
                }
                if (super.removeLRU(linkEntry)) {
                    try {
                        fileObject.close();
                    }
                    catch (FileSystemException e2) {
                        VfsLog.warn(LRUFilesCache.this.getLogger(), log, Messages.getString("vfs.impl/LRUFilesCache-remove-ex.warn"), e2);
                    }
                    Map files = (Map)LRUFilesCache.this.filesystemCache.get(this.filesystem);
                    if (files.isEmpty()) {
                        LRUFilesCache.this.filesystemCache.remove(this.filesystem);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

