/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.ConditionalFileFilter;

public class OrFileFilter
implements FileFilter,
ConditionalFileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<FileFilter> fileFilters;

    public OrFileFilter() {
        this.fileFilters = new ArrayList<FileFilter>();
    }

    public OrFileFilter(FileFilter ... filters) {
        if (filters == null || filters.length == 0) {
            throw new IllegalArgumentException("The filters must not be null or empty");
        }
        for (FileFilter filter : filters) {
            if (filter != null) continue;
            throw new IllegalArgumentException("Null filters are not allowed");
        }
        this.fileFilters = new ArrayList<FileFilter>(Arrays.asList(filters));
    }

    public OrFileFilter(List<FileFilter> fileFilters) {
        this.fileFilters = fileFilters == null ? new ArrayList<FileFilter>() : new ArrayList<FileFilter>(fileFilters);
    }

    @Override
    public boolean accept(FileSelectInfo fileSelectInfo) throws FileSystemException {
        for (FileFilter fileFilter : this.fileFilters) {
            if (!fileFilter.accept(fileSelectInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFileFilter(FileFilter fileFilter) {
        this.fileFilters.add(fileFilter);
    }

    @Override
    public List<FileFilter> getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    @Override
    public boolean removeFileFilter(FileFilter fileFilter) {
        return this.fileFilters.remove(fileFilter);
    }

    @Override
    public void setFileFilters(List<FileFilter> fileFilters) {
        this.fileFilters.clear();
        this.fileFilters.addAll(fileFilters);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.fileFilters != null) {
            for (int i2 = 0; i2 < this.fileFilters.size(); ++i2) {
                FileFilter filter;
                if (i2 > 0) {
                    buffer.append(",");
                }
                buffer.append((filter = this.fileFilters.get(i2)) == null ? "null" : filter.toString());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

