/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.ram.RamFileObject;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class RamFileRandomAccessContent
implements RandomAccessContent {
    protected int filePointer;
    private byte[] buf;
    private final byte[] buffer8 = new byte[8];
    private final byte[] buffer4 = new byte[4];
    private final byte[] buffer2 = new byte[2];
    private final byte[] buffer1 = new byte[1];
    private final RamFileObject file;
    private final InputStream rafis;
    private static final int BYTE_VALUE_MASK = 255;

    public RamFileRandomAccessContent(RamFileObject file, RandomAccessMode mode) {
        this.buf = file.getData().getContent();
        this.file = file;
        this.rafis = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    return RamFileRandomAccessContent.this.readByte() & 0xFF;
                }
                catch (EOFException e2) {
                    return -1;
                }
            }

            @Override
            public long skip(long n2) throws IOException {
                RamFileRandomAccessContent.this.seek(RamFileRandomAccessContent.this.getFilePointer() + n2);
                return n2;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read(byte[] b2) throws IOException {
                return this.read(b2, 0, b2.length);
            }

            @Override
            public int read(byte[] b2, int off, int len) throws IOException {
                int retLen = -1;
                int left = RamFileRandomAccessContent.this.getLeftBytes();
                if (left > 0) {
                    retLen = Math.min(len, left);
                    RamFileRandomAccessContent.this.readFully(b2, off, retLen);
                }
                return retLen;
            }

            @Override
            public int available() throws IOException {
                return RamFileRandomAccessContent.this.getLeftBytes();
            }
        };
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Attempt to position before the start of the file");
        }
        this.filePointer = (int)pos;
    }

    @Override
    public long length() throws IOException {
        return this.buf.length;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.filePointer < this.buf.length) {
            return this.buf[this.filePointer++] & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toUnsignedShort(this.buffer2);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.buffer8);
        return RamFileRandomAccessContent.toLong(this.buffer8);
    }

    @Override
    public short readShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toShort(this.buffer2);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("The skip number can't be negative");
        }
        long newPos = this.filePointer + n2;
        if (newPos > (long)this.buf.length) {
            throw new IndexOutOfBoundsException("Tyring to skip too much bytes");
        }
        this.seek(newPos);
        return n2;
    }

    @Override
    public void readFully(byte[] b2) throws IOException {
        this.readFully(b2, 0, b2.length);
    }

    @Override
    public void readFully(byte[] b2, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Length is lower than 0");
        }
        if (len > this.getLeftBytes()) {
            throw new IndexOutOfBoundsException("Read length (" + len + ") is higher than buffer left bytes (" + this.getLeftBytes() + ") ");
        }
        System.arraycopy(this.buf, this.filePointer, b2, off, len);
        this.filePointer += len;
    }

    private int getLeftBytes() {
        return this.buf.length - this.filePointer;
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.getLeftBytes() < len) {
            int newSize = this.buf.length + len - this.getLeftBytes();
            this.file.resize(newSize);
            this.buf = this.file.getData().getContent();
        }
        System.arraycopy(b2, off, this.buf, this.filePointer, len);
        this.filePointer += len;
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void writeByte(int i2) throws IOException {
        this.write(i2);
    }

    public static long toLong(byte[] b2) {
        return ((long)b2[7] & 0xFFL) + (((long)b2[6] & 0xFFL) << 8) + (((long)b2[5] & 0xFFL) << 16) + (((long)b2[4] & 0xFFL) << 24) + (((long)b2[3] & 0xFFL) << 32) + (((long)b2[2] & 0xFFL) << 40) + (((long)b2[1] & 0xFFL) << 48) + (((long)b2[0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(long n2, byte[] b2) {
        b2[7] = (byte)n2;
        b2[6] = (byte)(n2 >>>= 8);
        b2[5] = (byte)(n2 >>>= 8);
        b2[4] = (byte)(n2 >>>= 8);
        b2[3] = (byte)(n2 >>>= 8);
        b2[2] = (byte)(n2 >>>= 8);
        b2[1] = (byte)(n2 >>>= 8);
        b2[0] = (byte)(n2 >>>= 8);
        return b2;
    }

    public static short toShort(byte[] b2) {
        return (short)RamFileRandomAccessContent.toUnsignedShort(b2);
    }

    public static int toUnsignedShort(byte[] b2) {
        return (b2[1] & 0xFF) + ((b2[0] & 0xFF) << 8);
    }

    @Override
    public void write(int b2) throws IOException {
        this.buffer1[0] = (byte)b2;
        this.write(this.buffer1);
    }

    @Override
    public void writeBoolean(boolean v2) throws IOException {
        this.write(v2 ? 1 : 0);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        this.write(s2.getBytes(Charset.defaultCharset()));
    }

    @Override
    public void writeChar(int v2) throws IOException {
        this.buffer2[0] = (byte)(v2 >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(v2 >>> 0 & 0xFF);
        this.write(this.buffer2);
    }

    @Override
    public void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            this.writeChar(s2.charAt(i2));
        }
    }

    @Override
    public void writeDouble(double v2) throws IOException {
        this.writeLong(Double.doubleToLongBits(v2));
    }

    @Override
    public void writeFloat(float v2) throws IOException {
        this.writeInt(Float.floatToIntBits(v2));
    }

    @Override
    public void writeInt(int v2) throws IOException {
        this.buffer4[0] = (byte)(v2 >>> 24 & 0xFF);
        this.buffer4[1] = (byte)(v2 >>> 16 & 0xFF);
        this.buffer4[2] = (byte)(v2 >>> 8 & 0xFF);
        this.buffer4[3] = (byte)(v2 & 0xFF);
        this.write(this.buffer4);
    }

    @Override
    public void writeLong(long v2) throws IOException {
        this.write(RamFileRandomAccessContent.toBytes(v2, this.buffer8));
    }

    @Override
    public void writeShort(int v2) throws IOException {
        this.buffer2[0] = (byte)(v2 >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(v2 & 0xFF);
        this.write(this.buffer2);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(str.length());
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeUTF(str);
        dataOut.flush();
        dataOut.close();
        byte[] b2 = out.toByteArray();
        this.write(b2);
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("deprecated");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.file.resize(newLength);
        this.buf = this.file.getData().getContent();
    }
}

