/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;

public class VfsTask
extends Task {
    private static StandardFileSystemManager manager;

    protected FileObject resolveFile(String uri) throws FileSystemException {
        if (manager == null) {
            StandardFileSystemManager mngr = new StandardFileSystemManager();
            mngr.setLogger(new AntLogger());
            mngr.init();
            manager = mngr;
            this.getProject().addBuildListener((BuildListener)new CloseListener());
        }
        return manager.resolveFile(this.getProject().getBaseDir(), uri);
    }

    protected void closeManager() {
        if (manager != null) {
            manager.close();
            manager = null;
        }
    }

    private class AntLogger
    implements Log {
        private AntLogger() {
        }

        @Override
        public void debug(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 4);
        }

        @Override
        public void debug(Object o2, Throwable throwable) {
            this.debug(o2);
        }

        @Override
        public void error(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 0);
        }

        @Override
        public void error(Object o2, Throwable throwable) {
            this.error(o2);
        }

        @Override
        public void fatal(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 0);
        }

        @Override
        public void fatal(Object o2, Throwable throwable) {
            this.fatal(o2);
        }

        @Override
        public void info(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 2);
        }

        @Override
        public void info(Object o2, Throwable throwable) {
            this.info(o2);
        }

        @Override
        public void trace(Object o2) {
        }

        @Override
        public void trace(Object o2, Throwable throwable) {
        }

        @Override
        public void warn(Object o2) {
            VfsTask.this.log(String.valueOf(o2), 1);
        }

        @Override
        public void warn(Object o2, Throwable throwable) {
            this.warn(o2);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public boolean isErrorEnabled() {
            return true;
        }

        @Override
        public boolean isFatalEnabled() {
            return true;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isWarnEnabled() {
            return true;
        }
    }

    private class CloseListener
    implements SubBuildListener {
        private CloseListener() {
        }

        public void subBuildStarted(BuildEvent buildEvent) {
        }

        public void subBuildFinished(BuildEvent buildEvent) {
            VfsTask.this.closeManager();
        }

        public void buildFinished(BuildEvent event) {
            VfsTask.this.closeManager();
        }

        public void buildStarted(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }
    }
}

