/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileSystemException;

public class MonitorOutputStream
extends BufferedOutputStream {
    private final AtomicBoolean finished = new AtomicBoolean(false);

    public MonitorOutputStream(OutputStream out) {
        super(out);
    }

    public MonitorOutputStream(OutputStream out, int bufferSize) {
        super(out, bufferSize);
    }

    @Override
    public void close() throws IOException {
        if (this.finished.getAndSet(true)) {
            return;
        }
        IOException exc = null;
        try {
            super.flush();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.out.close();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.onClose();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    public synchronized void write(int b2) throws IOException {
        this.assertOpen();
        super.write(b2);
    }

    @Override
    public synchronized void write(byte[] b2, int off, int len) throws IOException {
        this.assertOpen();
        super.write(b2, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.assertOpen();
        super.flush();
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.assertOpen();
        super.write(b2);
    }

    protected void assertOpen() throws FileSystemException {
        if (this.finished.get()) {
            throw new FileSystemException("vfs.provider/closed.error");
        }
    }

    protected void onClose() throws IOException {
    }
}

