/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ByteArrayCombinerStream
extends InputStream {
    private final ArrayList<byte[]> arrays;
    private final long specifiedLength;
    private long gOffset = 0L;
    private int arrayIndex = 0;
    private byte[] curArray;
    private int off = 0;

    public ByteArrayCombinerStream(ArrayList<byte[]> arrayList, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Length cannot be negative: " + l2);
        }
        this.specifiedLength = l2;
        long l3 = l2;
        if (arrayList != null && arrayList.size() > 0) {
            byte[] byArray;
            int n2 = arrayList.size();
            this.arrays = new ArrayList(n2);
            for (int i2 = 0; i2 < n2 && l3 > 0L; l3 -= (long)byArray.length, ++i2) {
                byArray = arrayList.get(i2);
                if (l3 < (long)byArray.length) {
                    byte[] byArray2 = new byte[(int)l3];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                    this.arrays.add(byArray2);
                    l3 -= (long)byArray2.length;
                    break;
                }
                this.arrays.add(byArray);
            }
            this.curArray = this.nextArray();
        } else {
            this.gOffset = l2;
            this.arrays = null;
        }
        if (l3 > 0L) {
            throw new IllegalArgumentException("Not enough data, " + l3 + " bytes short of specified length " + l2);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.curArray == null) {
            return -1;
        }
        if (this.off >= this.curArray.length) {
            this.curArray = this.nextArray();
            if (this.curArray == null) {
                return -1;
            }
        }
        ++this.gOffset;
        return this.curArray[this.off++];
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        if (this.curArray == null) {
            return -1;
        }
        if (n3 <= this.curArray.length - this.off) {
            System.arraycopy(this.curArray, this.off, byArray, n2, n3);
            this.off += n3;
            this.gOffset += (long)n3;
            n4 = n3;
        } else {
            int n5 = 0;
            while (this.curArray != null && n4 < n3) {
                n5 = Math.min(this.curArray.length - this.off, n3 - n4);
                System.arraycopy(this.curArray, this.off, byArray, n2 + n4, n5);
                n4 += n5;
                this.gOffset += (long)n5;
                this.off += n5;
                if (this.off < this.curArray.length) break;
                this.curArray = this.nextArray();
            }
        }
        return n4;
    }

    @Override
    public int available() {
        return (int)(this.specifiedLength - this.gOffset);
    }

    private byte[] nextArray() {
        if (this.arrayIndex >= this.arrays.size()) {
            return null;
        }
        byte[] byArray = this.arrays.get(this.arrayIndex);
        this.arrays.set(this.arrayIndex++, null);
        this.off = 0;
        return byArray;
    }
}

