/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.Writer;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;

class ClobWriter
extends Writer {
    private final ClientClob clob_;
    private long offset_;

    ClobWriter(ClientClob clientClob, long l2) throws SqlException {
        this.clob_ = clientClob;
        this.offset_ = l2;
        if (this.offset_ - 1L > this.clob_.sqlLength()) {
            throw new SqlException(this.clob_.agent_.logWriter_, new ClientMessageId("XJ078.S"), l2);
        }
    }

    @Override
    public void write(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        stringBuffer.append((char)n2);
        this.updateClob(stringBuffer);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        stringBuffer.append(cArray, n2, n3);
        this.updateClob(stringBuffer);
    }

    @Override
    public void write(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        stringBuffer.append(string);
        this.updateClob(stringBuffer);
    }

    @Override
    public void write(String string, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(this.clob_.string_.substring(0, (int)this.offset_ - 1));
        stringBuffer.append(string.substring(n2, n2 + n3));
        this.updateClob(stringBuffer);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }

    private void updateClob(StringBuffer stringBuffer) {
        this.clob_.reInitForNonLocator(stringBuffer.toString());
        this.offset_ = this.clob_.string_.length() + 1;
    }
}

