/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BlobLocatorInputStream;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.ClobLocatorInputStream;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.FloatingPoint;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;

public abstract class Cursor {
    protected Agent agent_;
    public static final int STRING = 0;
    public static final int VARIABLE_STRING = 2;
    public static final int VARIABLE_SHORT_STRING = 1;
    public static final int NULL_TERMINATED_STRING = 3;
    public static final int BYTES = 4;
    public static final int NULL_TERMINATED_BYTES = 7;
    static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public byte[] dataBuffer_;
    public ByteArrayOutputStream dataBufferStream_;
    public int position_;
    public int lastValidBytePosition_;
    public boolean hasLobs_;
    protected int currentRowPosition_;
    private int nextRowPosition_;
    protected int[] columnDataPosition_;
    protected int[] columnDataComputedLength_;
    private boolean allRowsReceivedFromServer_;
    long rowsRead_;
    int maxFieldSize_ = 0;
    protected ArrayList<int[]> columnDataPositionCache_ = new ArrayList();
    protected ArrayList<int[]> columnDataLengthCache_ = new ArrayList();
    protected ArrayList<boolean[]> columnDataIsNullCache_ = new ArrayList();
    ArrayList<Boolean> isUpdateDeleteHoleCache_ = new ArrayList();
    boolean isUpdateDeleteHole_;
    private boolean isRowUpdated_;
    static final Boolean ROW_IS_NULL = Boolean.TRUE;
    private static final Boolean ROW_IS_NOT_NULL = Boolean.FALSE;
    private Calendar recyclableCalendar_ = null;
    public int[] jdbcTypes_;
    public int columns_;
    public boolean[] nullable_;
    public Charset[] charset_;
    public boolean[] isNull_;
    public int[] fdocaLength_;
    public int[] ccsid_;
    private char[] charBuffer_;

    public Cursor(Agent agent) {
        this.agent_ = agent;
        this.isRowUpdated_ = false;
        this.dataBufferStream_ = new ByteArrayOutputStream();
    }

    public void setNumberOfColumns(int n2) {
        this.columnDataPosition_ = new int[n2];
        this.columnDataComputedLength_ = new int[n2];
        this.columns_ = n2;
        this.nullable_ = new boolean[n2];
        this.charset_ = new Charset[n2];
        this.ccsid_ = new int[n2];
        this.isNull_ = new boolean[n2];
        this.jdbcTypes_ = new int[n2];
    }

    protected boolean stepNext(boolean bl) throws SqlException {
        this.clearLobData_();
        this.makeNextRowPositionCurrent();
        this.isUpdateDeleteHole_ = false;
        this.isRowUpdated_ = false;
        while (!this.dataBufferHasUnprocessedData()) {
            if (this.allRowsReceivedFromServer_) {
                return false;
            }
            this.getMoreData_();
        }
        boolean bl2 = this.calculateColumnOffsetsForRow_(0, bl);
        this.markNextRowPosition();
        return bl2;
    }

    public boolean next() throws SqlException {
        return this.stepNext(true);
    }

    public void setAllRowsReceivedFromServer(boolean bl) {
        this.allRowsReceivedFromServer_ = bl;
    }

    public final boolean allRowsReceivedFromServer() {
        return this.allRowsReceivedFromServer_;
    }

    final boolean currentRowPositionIsEqualToNextRowPosition() {
        return this.currentRowPosition_ == this.nextRowPosition_;
    }

    public final void resetDataBuffer() {
        this.position_ = 0;
        this.lastValidBytePosition_ = 0;
        this.currentRowPosition_ = 0;
        this.nextRowPosition_ = 0;
        this.setAllRowsReceivedFromServer(false);
        this.dataBufferStream_.reset();
    }

    final boolean dataBufferHasUnprocessedData() {
        return this.lastValidBytePosition_ - this.position_ > 0;
    }

    protected abstract boolean calculateColumnOffsetsForRow_(int var1, boolean var2) throws SqlException, DisconnectException;

    protected abstract void clearLobData_();

    protected abstract void getMoreData_() throws SqlException;

    public final void setIsUpdataDeleteHole(int n2, boolean bl) {
        Boolean bl2;
        this.isUpdateDeleteHole_ = bl;
        Boolean bl3 = bl2 = this.isUpdateDeleteHole_ ? ROW_IS_NULL : ROW_IS_NOT_NULL;
        if (this.isUpdateDeleteHoleCache_.size() == n2) {
            this.isUpdateDeleteHoleCache_.add(bl2);
        } else {
            this.isUpdateDeleteHoleCache_.set(n2, bl2);
        }
    }

    public final void setIsRowUpdated(boolean bl) {
        this.isRowUpdated_ = bl;
    }

    public final boolean getIsRowUpdated() {
        return this.isRowUpdated_;
    }

    public final boolean getIsUpdateDeleteHole() {
        return this.isUpdateDeleteHole_;
    }

    protected final void markNextRowPosition() {
        this.nextRowPosition_ = this.position_;
    }

    protected final void makeNextRowPositionCurrent() {
        this.currentRowPosition_ = this.nextRowPosition_;
    }

    public final void incrementRowsReadEvent() {
        ++this.rowsRead_;
    }

    private boolean get_BOOLEAN(int n2) {
        return SignedBinary.getByte(this.dataBuffer_, this.columnDataPosition_[n2 - 1]) != 0;
    }

    private final short get_SMALLINT(int n2) {
        return SignedBinary.getShort(this.dataBuffer_, this.columnDataPosition_[n2 - 1]);
    }

    protected final int get_INTEGER(int n2) {
        return SignedBinary.getInt(this.dataBuffer_, this.columnDataPosition_[n2 - 1]);
    }

    private final long get_BIGINT(int n2) {
        return SignedBinary.getLong(this.dataBuffer_, this.columnDataPosition_[n2 - 1]);
    }

    private final float get_FLOAT(int n2) {
        return FloatingPoint.getFloat(this.dataBuffer_, this.columnDataPosition_[n2 - 1]);
    }

    private final double get_DOUBLE(int n2) {
        return FloatingPoint.getDouble(this.dataBuffer_, this.columnDataPosition_[n2 - 1]);
    }

    private final BigDecimal get_DECIMAL(int n2) throws SqlException {
        return Decimal.getBigDecimal(this.dataBuffer_, this.columnDataPosition_[n2 - 1], this.getColumnPrecision(n2 - 1), this.getColumnScale(n2 - 1));
    }

    private double getDoubleFromDECIMAL(int n2) throws SqlException {
        try {
            return Decimal.getDouble(this.dataBuffer_, this.columnDataPosition_[n2 - 1], this.getColumnPrecision(n2 - 1), this.getColumnScale(n2 - 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), illegalArgumentException, "double");
        }
    }

    private long getLongFromDECIMAL(int n2, String string) throws SqlException {
        try {
            return Decimal.getLong(this.dataBuffer_, this.columnDataPosition_[n2 - 1], this.getColumnPrecision(n2 - 1), this.getColumnScale(n2 - 1));
        }
        catch (ArithmeticException arithmeticException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), arithmeticException, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), illegalArgumentException, string);
        }
    }

    private String getVARCHAR(int n2) throws SqlException {
        if (this.ccsid_[n2 - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[n2 - 1] + 2, this.columnDataComputedLength_[n2 - 1] - 2);
        }
        if (this.charset_[n2 - 1] == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        String string = new String(this.dataBuffer_, this.columnDataPosition_[n2 - 1] + 2, this.columnDataComputedLength_[n2 - 1] - 2, this.charset_[n2 - 1]);
        return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
    }

    private String getCHAR(int n2) throws SqlException {
        if (this.ccsid_[n2 - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[n2 - 1], this.columnDataComputedLength_[n2 - 1]);
        }
        if (this.charset_[n2 - 1] == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        String string = new String(this.dataBuffer_, this.columnDataPosition_[n2 - 1], this.columnDataComputedLength_[n2 - 1], this.charset_[n2 - 1]);
        return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
    }

    private Date getDATE(int n2, Calendar calendar) throws SqlException {
        return DateTime.dateBytesToDate(this.dataBuffer_, this.columnDataPosition_[n2 - 1], calendar, this.charset_[n2 - 1]);
    }

    private Time getTIME(int n2, Calendar calendar) throws SqlException {
        return DateTime.timeBytesToTime(this.dataBuffer_, this.columnDataPosition_[n2 - 1], calendar, this.charset_[n2 - 1]);
    }

    private final Timestamp getTIMESTAMP(int n2, Calendar calendar) throws SqlException {
        return DateTime.timestampBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n2 - 1], calendar, this.charset_[n2 - 1], this.agent_.connection_.serverSupportsTimestampNanoseconds());
    }

    private final Timestamp getTimestampFromDATE(int n2, Calendar calendar) throws SqlException {
        return DateTime.dateBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n2 - 1], calendar, this.charset_[n2 - 1]);
    }

    private final Timestamp getTimestampFromTIME(int n2, Calendar calendar) throws SqlException {
        return DateTime.timeBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n2 - 1], calendar, this.charset_[n2 - 1]);
    }

    private final Date getDateFromTIMESTAMP(int n2, Calendar calendar) throws SqlException {
        return DateTime.timestampBytesToDate(this.dataBuffer_, this.columnDataPosition_[n2 - 1], calendar, this.charset_[n2 - 1]);
    }

    private final Time getTimeFromTIMESTAMP(int n2, Calendar calendar) throws SqlException {
        return DateTime.timestampBytesToTime(this.dataBuffer_, this.columnDataPosition_[n2 - 1], calendar, this.charset_[n2 - 1]);
    }

    private String getStringFromDATE(int n2) throws SqlException {
        return this.getDATE(n2, this.getRecyclableCalendar()).toString();
    }

    private String getStringFromTIME(int n2) throws SqlException {
        return this.getTIME(n2, this.getRecyclableCalendar()).toString();
    }

    private String getStringFromTIMESTAMP(int n2) throws SqlException {
        return this.getTIMESTAMP(n2, this.getRecyclableCalendar()).toString();
    }

    private byte[] get_CHAR_FOR_BIT_DATA(int n2) throws SqlException {
        int n3 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n2 - 1] : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n2 - 1]);
        byte[] byArray = new byte[n3];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n2 - 1], byArray, 0, n3);
        return byArray;
    }

    private byte[] get_VARCHAR_FOR_BIT_DATA(int n2) throws SqlException {
        int n3 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n2 - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n2 - 1] - 2);
        byte[] byArray = new byte[n3];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n2 - 1] + 2, byArray, 0, byArray.length);
        return byArray;
    }

    private Object get_UDT(int n2) throws SqlException {
        int n3 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n2 - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n2 - 1] - 2);
        byte[] byArray = new byte[n3];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n2 - 1] + 2, byArray, 0, byArray.length);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XN020.S"), exception, exception.getMessage());
        }
    }

    private Calendar getRecyclableCalendar() {
        if (this.recyclableCalendar_ == null) {
            this.recyclableCalendar_ = new GregorianCalendar();
        }
        return this.recyclableCalendar_;
    }

    CallableLocatorProcedures getLocatorProcedures() {
        return this.agent_.connection_.locatorProcedureCall();
    }

    protected abstract int locator(int var1);

    public abstract ClientBlob getBlobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    public abstract ClientClob getClobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    final boolean getBoolean(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.get_BOOLEAN(n2);
            }
            case 5: {
                return this.agent_.crossConverters_.getBooleanFromShort(this.get_SMALLINT(n2));
            }
            case 4: {
                return this.agent_.crossConverters_.getBooleanFromInt(this.get_INTEGER(n2));
            }
            case -5: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.get_BIGINT(n2));
            }
            case 7: {
                return this.agent_.crossConverters_.getBooleanFromFloat(this.get_FLOAT(n2));
            }
            case 8: {
                return this.agent_.crossConverters_.getBooleanFromDouble(this.get_DOUBLE(n2));
            }
            case 3: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.getLongFromDECIMAL(n2, "boolean"));
            }
            case 1: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("boolean", n2);
    }

    final byte getByte(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getByteFromBoolean(this.get_BOOLEAN(n2));
            }
            case 5: {
                return this.agent_.crossConverters_.getByteFromShort(this.get_SMALLINT(n2));
            }
            case 4: {
                return this.agent_.crossConverters_.getByteFromInt(this.get_INTEGER(n2));
            }
            case -5: {
                return this.agent_.crossConverters_.getByteFromLong(this.get_BIGINT(n2));
            }
            case 7: {
                return this.agent_.crossConverters_.getByteFromFloat(this.get_FLOAT(n2));
            }
            case 8: {
                return this.agent_.crossConverters_.getByteFromDouble(this.get_DOUBLE(n2));
            }
            case 3: {
                return this.agent_.crossConverters_.getByteFromLong(this.getLongFromDECIMAL(n2, "byte"));
            }
            case 1: {
                return this.agent_.crossConverters_.getByteFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getByteFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("byte", n2);
    }

    final short getShort(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getShortFromBoolean(this.get_BOOLEAN(n2));
            }
            case 5: {
                return this.get_SMALLINT(n2);
            }
            case 4: {
                return this.agent_.crossConverters_.getShortFromInt(this.get_INTEGER(n2));
            }
            case -5: {
                return this.agent_.crossConverters_.getShortFromLong(this.get_BIGINT(n2));
            }
            case 7: {
                return this.agent_.crossConverters_.getShortFromFloat(this.get_FLOAT(n2));
            }
            case 8: {
                return this.agent_.crossConverters_.getShortFromDouble(this.get_DOUBLE(n2));
            }
            case 3: {
                return this.agent_.crossConverters_.getShortFromLong(this.getLongFromDECIMAL(n2, "short"));
            }
            case 1: {
                return this.agent_.crossConverters_.getShortFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getShortFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("short", n2);
    }

    final int getInt(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getIntFromBoolean(this.get_BOOLEAN(n2));
            }
            case 5: {
                return this.get_SMALLINT(n2);
            }
            case 4: {
                return this.get_INTEGER(n2);
            }
            case -5: {
                return this.agent_.crossConverters_.getIntFromLong(this.get_BIGINT(n2));
            }
            case 7: {
                return this.agent_.crossConverters_.getIntFromFloat(this.get_FLOAT(n2));
            }
            case 8: {
                return this.agent_.crossConverters_.getIntFromDouble(this.get_DOUBLE(n2));
            }
            case 3: {
                return this.agent_.crossConverters_.getIntFromLong(this.getLongFromDECIMAL(n2, "int"));
            }
            case 1: {
                return this.agent_.crossConverters_.getIntFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getIntFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("int", n2);
    }

    final long getLong(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getLongFromBoolean(this.get_BOOLEAN(n2));
            }
            case 5: {
                return this.get_SMALLINT(n2);
            }
            case 4: {
                return this.get_INTEGER(n2);
            }
            case -5: {
                return this.get_BIGINT(n2);
            }
            case 7: {
                return this.agent_.crossConverters_.getLongFromFloat(this.get_FLOAT(n2));
            }
            case 8: {
                return this.agent_.crossConverters_.getLongFromDouble(this.get_DOUBLE(n2));
            }
            case 3: {
                return this.getLongFromDECIMAL(n2, "long");
            }
            case 1: {
                return this.agent_.crossConverters_.getLongFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLongFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("long", n2);
    }

    final float getFloat(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getFloatFromBoolean(this.get_BOOLEAN(n2));
            }
            case 7: {
                return this.get_FLOAT(n2);
            }
            case 8: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.get_DOUBLE(n2));
            }
            case 3: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.getDoubleFromDECIMAL(n2));
            }
            case 5: {
                return this.get_SMALLINT(n2);
            }
            case 4: {
                return this.get_INTEGER(n2);
            }
            case -5: {
                return this.get_BIGINT(n2);
            }
            case 1: {
                return this.agent_.crossConverters_.getFloatFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getFloatFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("float", n2);
    }

    final double getDouble(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getDoubleFromBoolean(this.get_BOOLEAN(n2));
            }
            case 7: {
                double d2 = this.get_FLOAT(n2);
                return d2;
            }
            case 8: {
                return this.get_DOUBLE(n2);
            }
            case 3: {
                return this.getDoubleFromDECIMAL(n2);
            }
            case 5: {
                return this.get_SMALLINT(n2);
            }
            case 4: {
                return this.get_INTEGER(n2);
            }
            case -5: {
                return this.get_BIGINT(n2);
            }
            case 1: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("double", n2);
    }

    final BigDecimal getBigDecimal(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return BigDecimal.valueOf(this.getLong(n2));
            }
            case 3: {
                return this.get_DECIMAL(n2);
            }
            case 7: {
                float f2 = this.get_FLOAT(n2);
                return new BigDecimal(String.valueOf(f2));
            }
            case 8: {
                return BigDecimal.valueOf(this.get_DOUBLE(n2));
            }
            case 5: {
                return BigDecimal.valueOf(this.get_SMALLINT(n2));
            }
            case 4: {
                return BigDecimal.valueOf(this.get_INTEGER(n2));
            }
            case -5: {
                return BigDecimal.valueOf(this.get_BIGINT(n2));
            }
            case 1: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getVARCHAR(n2));
            }
        }
        throw this.coercionError("java.math.BigDecimal", n2);
    }

    final Date getDate(int n2, Calendar calendar) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 91: {
                return this.getDATE(n2, calendar);
            }
            case 93: {
                return this.getDateFromTIMESTAMP(n2, calendar);
            }
            case 1: {
                return this.agent_.crossConverters_.getDateFromString(this.getCHAR(n2), calendar);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDateFromString(this.getVARCHAR(n2), calendar);
            }
        }
        throw this.coercionError("java.sql.Date", n2);
    }

    final Time getTime(int n2, Calendar calendar) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 92: {
                return this.getTIME(n2, calendar);
            }
            case 93: {
                return this.getTimeFromTIMESTAMP(n2, calendar);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimeFromString(this.getCHAR(n2), calendar);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimeFromString(this.getVARCHAR(n2), calendar);
            }
        }
        throw this.coercionError("java.sql.Time", n2);
    }

    final Timestamp getTimestamp(int n2, Calendar calendar) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 93: {
                return this.getTIMESTAMP(n2, calendar);
            }
            case 91: {
                return this.getTimestampFromDATE(n2, calendar);
            }
            case 92: {
                return this.getTimestampFromTIME(n2, calendar);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getCHAR(n2), calendar);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getVARCHAR(n2), calendar);
            }
        }
        throw this.coercionError("java.sql.Timestamp", n2);
    }

    final String getString(int n2) throws SqlException {
        try {
            switch (this.jdbcTypes_[n2 - 1]) {
                case 16: {
                    if (this.get_BOOLEAN(n2)) {
                        return Boolean.TRUE.toString();
                    }
                    return Boolean.FALSE.toString();
                }
                case 1: {
                    return this.getCHAR(n2);
                }
                case -1: 
                case 12: {
                    return this.getVARCHAR(n2);
                }
                case 5: {
                    return String.valueOf(this.get_SMALLINT(n2));
                }
                case 4: {
                    return String.valueOf(this.get_INTEGER(n2));
                }
                case -5: {
                    return String.valueOf(this.get_BIGINT(n2));
                }
                case 7: {
                    return String.valueOf(this.get_FLOAT(n2));
                }
                case 8: {
                    return String.valueOf(this.get_DOUBLE(n2));
                }
                case 3: {
                    return String.valueOf(this.get_DECIMAL(n2));
                }
                case 91: {
                    return this.getStringFromDATE(n2);
                }
                case 92: {
                    return this.getStringFromTIME(n2);
                }
                case 93: {
                    return this.getStringFromTIMESTAMP(n2);
                }
                case -2: {
                    String string = this.agent_.crossConverters_.getStringFromBytes(this.get_CHAR_FOR_BIT_DATA(n2));
                    return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
                }
                case -4: 
                case -3: {
                    String string = this.agent_.crossConverters_.getStringFromBytes(this.get_VARCHAR_FOR_BIT_DATA(n2));
                    return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
                }
                case 2000: {
                    Object object = this.get_UDT(n2);
                    if (object == null) {
                        return null;
                    }
                    return object.toString();
                }
                case 2004: {
                    ClientBlob clientBlob = this.getBlobColumn_(n2, this.agent_, false);
                    String string = this.agent_.crossConverters_.getStringFromBytes(clientBlob.getBytes(1L, (int)clientBlob.length()));
                    return string;
                }
                case 2005: {
                    ClientClob clientClob = this.getClobColumn_(n2, this.agent_, false);
                    String string = clientClob.getSubString(1L, (int)clientClob.length());
                    return string;
                }
            }
            throw this.coercionError("String", n2);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    final byte[] getBytes(int n2) throws SqlException {
        try {
            switch (this.jdbcTypes_[n2 - 1]) {
                case -2: {
                    return this.get_CHAR_FOR_BIT_DATA(n2);
                }
                case -4: 
                case -3: {
                    return this.get_VARCHAR_FOR_BIT_DATA(n2);
                }
                case 2004: {
                    ClientBlob clientBlob = this.getBlobColumn_(n2, this.agent_, false);
                    byte[] byArray = clientBlob.getBytes(1L, (int)clientBlob.length());
                    return byArray;
                }
            }
            throw this.coercionError("byte[]", n2);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    final InputStream getBinaryStream(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n2));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n2));
            }
            case 2004: {
                ClientBlob clientBlob = this.getBlobColumn_(n2, this.agent_, false);
                if (clientBlob.isLocator()) {
                    BlobLocatorInputStream blobLocatorInputStream = new BlobLocatorInputStream(this.agent_.connection_, clientBlob);
                    return new BufferedInputStream(blobLocatorInputStream);
                }
                return clientBlob.getBinaryStreamX();
            }
        }
        throw this.coercionError("java.io.InputStream", n2);
    }

    final InputStream getAsciiStream(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 2005: {
                ClientClob clientClob = this.getClobColumn_(n2, this.agent_, false);
                if (clientClob.isLocator()) {
                    ClobLocatorInputStream clobLocatorInputStream = new ClobLocatorInputStream(this.agent_.connection_, clientClob);
                    return new BufferedInputStream(clobLocatorInputStream);
                }
                return clientClob.getAsciiStreamX();
            }
            case 1: {
                return new ByteArrayInputStream(this.getCHAR(n2).getBytes(ISO_8859_1));
            }
            case -1: 
            case 12: {
                return new ByteArrayInputStream(this.getVARCHAR(n2).getBytes(ISO_8859_1));
            }
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n2));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n2));
            }
            case 2004: {
                return this.getBinaryStream(n2);
            }
        }
        throw this.coercionError("java.io.InputStream", n2);
    }

    final Reader getCharacterStream(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 2005: {
                ClientClob clientClob = this.getClobColumn_(n2, this.agent_, false);
                if (clientClob.isLocator()) {
                    ClobLocatorReader clobLocatorReader = new ClobLocatorReader(this.agent_.connection_, clientClob);
                    return new BufferedReader(clobLocatorReader);
                }
                return clientClob.getCharacterStreamX();
            }
            case 1: {
                return new StringReader(this.getCHAR(n2));
            }
            case -1: 
            case 12: {
                return new StringReader(this.getVARCHAR(n2));
            }
            case -2: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n2)), UTF_16BE);
            }
            case -4: 
            case -3: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n2)), UTF_16BE);
            }
            case 2004: {
                return new InputStreamReader(this.getBinaryStream(n2), UTF_16BE);
            }
        }
        throw this.coercionError("java.io.Reader", n2);
    }

    final Blob getBlob(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 2004: {
                return this.getBlobColumn_(n2, this.agent_, true);
            }
        }
        throw this.coercionError("java.sql.Blob", n2);
    }

    final Clob getClob(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 2005: {
                return this.getClobColumn_(n2, this.agent_, true);
            }
        }
        throw this.coercionError("java.sql.Clob", n2);
    }

    final Array getArray(int n2) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getArray(int)");
    }

    final Ref getRef(int n2) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getRef(int)");
    }

    final Object getObject(int n2) throws SqlException {
        switch (this.jdbcTypes_[n2 - 1]) {
            case 16: {
                return this.get_BOOLEAN(n2);
            }
            case 5: {
                return (int)this.get_SMALLINT(n2);
            }
            case 4: {
                return this.get_INTEGER(n2);
            }
            case -5: {
                return this.get_BIGINT(n2);
            }
            case 7: {
                return Float.valueOf(this.get_FLOAT(n2));
            }
            case 8: {
                return this.get_DOUBLE(n2);
            }
            case 3: {
                return this.get_DECIMAL(n2);
            }
            case 91: {
                return this.getDATE(n2, this.getRecyclableCalendar());
            }
            case 92: {
                return this.getTIME(n2, this.getRecyclableCalendar());
            }
            case 93: {
                return this.getTIMESTAMP(n2, this.getRecyclableCalendar());
            }
            case 1: {
                return this.getCHAR(n2);
            }
            case -1: 
            case 12: {
                return this.getVARCHAR(n2);
            }
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(n2);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(n2);
            }
            case 2000: {
                return this.get_UDT(n2);
            }
            case 2004: {
                return this.getBlobColumn_(n2, this.agent_, true);
            }
            case 2005: {
                return this.getClobColumn_(n2, this.agent_, true);
            }
        }
        throw this.coercionError("Object", n2);
    }

    public final void allocateCharBuffer() {
        int n2 = 0;
        block3: for (int i2 = 0; i2 < this.columns_; ++i2) {
            switch (this.jdbcTypes_[i2]) {
                case -1: 
                case 1: 
                case 12: {
                    if (this.fdocaLength_[i2] <= n2) continue block3;
                    n2 = this.fdocaLength_[i2];
                }
            }
        }
        this.charBuffer_ = new char[n2];
    }

    private String getStringWithoutConvert(int n2, int n3) {
        int n4 = n2 + n3;
        int n5 = 0;
        for (int i2 = n2; i2 < n4; i2 += 2) {
            this.charBuffer_[n5++] = (char)((this.dataBuffer_[i2] & 0xFF) << 8 | this.dataBuffer_[i2 + 1] & 0xFF);
        }
        return new String(this.charBuffer_, 0, n5);
    }

    private ColumnTypeConversionException coercionError(String string, int n2) {
        return new ColumnTypeConversionException(this.agent_.logWriter_, string, ClientTypes.getTypeString(this.jdbcTypes_[n2 - 1]));
    }

    public void nullDataForGC() {
        this.dataBuffer_ = null;
        this.dataBufferStream_ = null;
        this.columnDataPosition_ = null;
        this.columnDataComputedLength_ = null;
        this.columnDataPositionCache_ = null;
        this.columnDataLengthCache_ = null;
        this.columnDataIsNullCache_ = null;
        this.jdbcTypes_ = null;
        this.nullable_ = null;
        this.charset_ = null;
        this.ccsid_ = null;
        this.isUpdateDeleteHoleCache_ = null;
        this.isNull_ = null;
        this.fdocaLength_ = null;
        this.charBuffer_ = null;
    }

    private int getColumnPrecision(int n2) {
        return this.fdocaLength_[n2] >> 8 & 0xFF;
    }

    private int getColumnScale(int n2) {
        return this.fdocaLength_[n2] & 0xFF;
    }
}

