/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class Decimal {
    public static final int PACKED_DECIMAL = 48;
    private static final MessageUtil msgutil = SqlException.getMessageUtil();
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};

    private Decimal() {
    }

    private static final int packedNybblesToInt(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = n3 / 2;
        if (n3 % 2 != 0) {
            n5 += byArray[n2 + n6] & 0xF;
            ++n6;
        }
        int n7 = n3 + n4 - 1;
        while (n6 < (n7 + 1) / 2) {
            n5 = n5 * 10 + ((byArray[n2 + n6] & 0xF0) >>> 4);
            n5 = n5 * 10 + (byArray[n2 + n6] & 0xF);
            ++n6;
        }
        if (n7 % 2 == 0) {
            n5 = n5 * 10 + ((byArray[n2 + n6] & 0xF0) >>> 4);
        }
        return n5;
    }

    private static final long packedNybblesToLong(byte[] byArray, int n2, int n3, int n4) {
        long l2 = 0L;
        int n5 = n3 / 2;
        if (n3 % 2 != 0) {
            l2 += (long)(byArray[n2 + n5] & 0xF);
            ++n5;
        }
        int n6 = n3 + n4 - 1;
        while (n5 < (n6 + 1) / 2) {
            l2 = l2 * 10L + (long)((byArray[n2 + n5] & 0xF0) >>> 4);
            l2 = l2 * 10L + (long)(byArray[n2 + n5] & 0xF);
            ++n5;
        }
        if (n6 % 2 == 0) {
            l2 = l2 * 10L + (long)((byArray[n2 + n5] & 0xF0) >>> 4);
        }
        return l2;
    }

    private static final int[] computeMagnitude(int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        nArray2[n2 - 1] = nArray[n2 - 1];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            int n3 = 0;
            int n4 = tenRadixMagnitude[i2].length - 1;
            int n5 = n2 - 1;
            while (n4 >= 0) {
                long l2 = ((long)nArray[n2 - 2 - i2] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i2][n4] & 0xFFFFFFFFL) + ((long)nArray2[n5] & 0xFFFFFFFFL) + ((long)n3 & 0xFFFFFFFFL);
                n3 = (int)(l2 >>> 32);
                nArray2[n5] = (int)(l2 & 0xFFFFFFFFL);
                --n4;
                --n5;
            }
            nArray2[n5] = n3;
        }
        return nArray2;
    }

    static BigDecimal getBigDecimal(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n3 / 2 + 1;
        int n6 = (byArray[n2 + n5 - 1] & 0xF) == 13 ? -1 : 1;
        if (n3 <= 18) {
            long l2 = Decimal.packedNybblesToLong(byArray, n2, 0, n5 * 2 - 1);
            if (n6 < 0) {
                l2 = -l2;
            }
            return BigDecimal.valueOf(l2, n4);
        }
        if (n3 <= 27) {
            int n7 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 5) * 2, 9);
            int n8 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 10) * 2 + 1, 9);
            int n9 = Decimal.packedNybblesToInt(byArray, n2, 0, (n5 - 10) * 2 + 1);
            int[] nArray = Decimal.computeMagnitude(new int[]{n9, n8, n7});
            byte[] byArray2 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2]};
            return new BigDecimal(new BigInteger(n6, byArray2), n4);
        }
        if (n3 <= 31) {
            int n10 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 5) * 2, 9);
            int n11 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 10) * 2 + 1, 9);
            int n12 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 14) * 2, 9);
            int n13 = Decimal.packedNybblesToInt(byArray, n2, 0, (n5 - 14) * 2);
            int[] nArray = Decimal.computeMagnitude(new int[]{n13, n12, n11, n10});
            byte[] byArray3 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2], (byte)(nArray[3] >>> 24), (byte)(nArray[3] >>> 16), (byte)(nArray[3] >>> 8), (byte)nArray[3]};
            return new BigDecimal(new BigInteger(n6, byArray3), n4);
        }
        throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2", new Object[0]));
    }

    static double getDouble(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n3 / 2 + 1;
        int n6 = (byArray[n2 + n5 - 1] & 0xF) == 13 ? -1 : 1;
        if (n3 <= 9) {
            int n7 = Decimal.packedNybblesToInt(byArray, n2, 0, n5 * 2 - 1);
            return (double)(n6 * n7) / Math.pow(10.0, n4);
        }
        if (n3 <= 18) {
            long l2 = Decimal.packedNybblesToLong(byArray, n2, 0, n5 * 2 - 1);
            return (double)((long)n6 * l2) / Math.pow(10.0, n4);
        }
        if (n3 <= 27) {
            int n8 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 5) * 2, 9);
            int n9 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 10) * 2 + 1, 9);
            int n10 = Decimal.packedNybblesToInt(byArray, n2, 0, (n5 - 10) * 2 + 1);
            return (double)n6 * ((double)n8 / Math.pow(10.0, n4) + (double)n9 * Math.pow(10.0, 9 - n4) + (double)n10 * Math.pow(10.0, 18 - n4));
        }
        if (n3 <= 31) {
            int n11 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 5) * 2, 9);
            int n12 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 10) * 2 + 1, 9);
            int n13 = Decimal.packedNybblesToInt(byArray, n2, (n5 - 14) * 2, 9);
            int n14 = Decimal.packedNybblesToInt(byArray, n2, 0, (n5 - 14) * 2);
            return (double)n6 * ((double)n11 / Math.pow(10.0, n4) + (double)n12 * Math.pow(10.0, 9 - n4) + (double)n13 * Math.pow(10.0, 18 - n4) + (double)n14 * Math.pow(10.0, 27 - n4));
        }
        throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2", new Object[0]));
    }

    static long getLong(byte[] byArray, int n2, int n3, int n4) {
        if (n3 > 31) {
            throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2", new Object[0]));
        }
        int n5 = n3 / 2 + 1;
        int n6 = (byArray[n2 + n5 - 1] & 0xF) == 13 ? -1 : 1;
        if (n3 - n4 <= 18) {
            int n7 = n5 * 2 - 1 - n4;
            return (long)n6 * Decimal.packedNybblesToLong(byArray, n2, 0, n7);
        }
        BigDecimal bigDecimal = new BigDecimal(Decimal.getBigDecimal(byArray, n2, n3, n4).toBigInteger());
        return bigDecimal.longValueExact();
    }

    public static final int bigDecimalToPackedDecimalBytes(byte[] byArray, int n2, BigDecimal bigDecimal, int n3, int n4) throws SqlException {
        int n5;
        int n6;
        if (n3 > 31) {
            throw new SqlException(null, new ClientMessageId("22003.S.2"), new Object[0]);
        }
        String string = bigDecimal.unscaledValue().abs().toString();
        int n7 = string.length();
        if (n7 > 31) {
            throw new SqlException(null, new ClientMessageId("22003"), new SqlCode(-405), "packed decimal");
        }
        int n8 = bigDecimal.scale();
        int n9 = n7 - n8;
        if (n9 > 0 && !string.equals("0") && n9 > (n6 = n3 - n4)) {
            throw new SqlException(null, new ClientMessageId("22003.S.3"), new SqlCode(-413), bigDecimal.toString(), "packed decimal");
        }
        n6 = 48;
        int n10 = n3 - 1;
        if (n8 >= n4) {
            n5 = n7 - 1 - (n8 - n4);
            byArray[n2 + (n10 + 1) / 2] = n5 < 0 ? (byte)(bigDecimal.signum() >= 0 ? 12 : 13) : (byte)((string.charAt(n5) - n6 << 4) + (bigDecimal.signum() >= 0 ? 12 : 13));
            n10 -= 2;
            n5 -= 2;
        } else {
            n5 = n4 - n8 - 1;
            byArray[n2 + (n10 + 1) / 2] = (byte)(bigDecimal.signum() >= 0 ? 12 : 13);
            n10 -= 2;
            n5 -= 2;
            while (n5 >= 0) {
                byArray[n2 + (n10 + 1) / 2] = 0;
                n10 -= 2;
                n5 -= 2;
            }
            if (n5 == -1) {
                byArray[n2 + (n10 + 1) / 2] = (byte)(string.charAt(n7 - 1) - n6 << 4);
                n10 -= 2;
                n5 = n7 - 3;
            } else {
                n5 = n7 - 2;
            }
        }
        while (n5 >= 0) {
            byArray[n2 + (n10 + 1) / 2] = (byte)((string.charAt(n5) - n6 << 4) + (string.charAt(n5 + 1) - n6));
            n10 -= 2;
            n5 -= 2;
        }
        if (n5 == -1) {
            byArray[n2 + (n10 + 1) / 2] = (byte)(string.charAt(0) - n6);
            n10 -= 2;
        }
        while (n10 >= -1) {
            byArray[n2 + (n10 + 1) / 2] = 0;
            n10 -= 2;
        }
        return n3 / 2 + 1;
    }
}

