/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.util.Arrays;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.SqlException;

class LOBStateTracker {
    public static final LOBStateTracker NO_OP_TRACKER = new LOBStateTracker(new int[0], new boolean[0], false);
    private final int[] columns;
    private final boolean[] isBlob;
    private final boolean[] published;
    private final boolean doRelease;
    private final int[] lastLocatorSeen;

    LOBStateTracker(int[] nArray, boolean[] blArray, boolean bl) {
        this.columns = nArray;
        this.isBlob = blArray;
        this.published = new boolean[this.columns.length];
        this.doRelease = bl;
        this.lastLocatorSeen = new int[this.columns.length];
    }

    void checkCurrentRow(Cursor cursor) throws SqlException {
        if (this.doRelease && !cursor.getIsUpdateDeleteHole()) {
            CallableLocatorProcedures callableLocatorProcedures = cursor.getLocatorProcedures();
            for (int i2 = 0; i2 < this.columns.length; ++i2) {
                if (this.published[i2] || cursor.isNull_[this.columns[i2] - 1]) continue;
                int n2 = cursor.locator(this.columns[i2]);
                if (n2 == this.lastLocatorSeen[i2]) {
                    return;
                }
                if (n2 == -1) {
                    return;
                }
                this.lastLocatorSeen[i2] = n2;
                if (this.isBlob[i2]) {
                    callableLocatorProcedures.blobReleaseLocator(n2);
                    continue;
                }
                callableLocatorProcedures.clobReleaseLocator(n2);
            }
            Arrays.fill(this.published, false);
        }
    }

    void discardState() {
        if (this.doRelease) {
            Arrays.fill(this.published, true);
        }
    }

    void markAsPublished(int n2) {
        if (this.doRelease) {
            int n3 = Arrays.binarySearch(this.columns, n2);
            this.published[n3] = true;
        }
    }
}

