/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.SqlException;

public class Section {
    private int sectionNumber;
    private String packageName;
    private String serverCursorName;
    private int resultSetHoldability_;
    private byte[] PKGNAMCBytes;
    private boolean isGenerated;
    private Agent agent_;
    String serverCursorNameForPositionedUpdate_ = null;
    private transient String clientCursorName_;

    Section(Agent agent, String string, int n2, String string2, int n3) {
        this.init(agent, string, n2, string2, n3, false);
    }

    public Section(Agent agent, String string, int n2, String string2, int n3, boolean bl) {
        this.init(agent, string, n2, string2, n3, bl);
    }

    private void init(Agent agent, String string, int n2, String string2, int n3, boolean bl) {
        this.packageName = string;
        this.sectionNumber = n2;
        this.serverCursorName = string2;
        this.resultSetHoldability_ = n3;
        this.agent_ = agent;
        this.isGenerated = bl;
        if (!bl) {
            if (this.resultSetHoldability_ == 1) {
                this.PKGNAMCBytes = this.agent_.sectionManager_.holdPKGNAMCBytes;
            } else if (this.resultSetHoldability_ == 2) {
                this.PKGNAMCBytes = this.agent_.sectionManager_.noHoldPKGNAMCBytes;
            }
        }
    }

    public void setPKGNAMCBytes(byte[] byArray) {
        if (this.isGenerated) {
            this.PKGNAMCBytes = (byte[])byArray.clone();
        } else {
            this.agent_.sectionManager_.setPKGNAMCBytes(byArray, this.resultSetHoldability_);
        }
    }

    public byte[] getPKGNAMCBytes() {
        return this.PKGNAMCBytes != null ? (byte[])this.PKGNAMCBytes.clone() : null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getServerCursorName() {
        return this.serverCursorName;
    }

    public String getServerCursorNameForPositionedUpdate() {
        return this.serverCursorNameForPositionedUpdate_;
    }

    public String getClientCursorName() {
        return this.clientCursorName_;
    }

    public void setClientCursorName(String string) {
        this.clientCursorName_ = string;
    }

    void free() {
        if (this.resultSetHoldability_ != -1) {
            this.agent_.sectionManager_.freeSection(this, this.resultSetHoldability_);
        }
    }

    public boolean isReservedPositionedUpdate() {
        return false;
    }

    public int getStaticStatementType() {
        return 0;
    }

    public Section getPositionedUpdateSection() throws SqlException {
        return this.agent_.sectionManager_.getPositionedUpdateSection(this);
    }

    public void setCursorName(String string) {
        this.serverCursorName = string;
    }
}

