/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.SqlException;

class UpdateSensitiveClobLocatorReader
extends Reader {
    private BufferedReader r = null;
    private ClientConnection con = null;
    private ClientClob clob = null;
    private long updateCount;
    private long currentPos;
    private long length;

    protected UpdateSensitiveClobLocatorReader(ClientConnection clientConnection, ClientClob clientClob) throws SqlException {
        clientClob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(clientConnection, clientClob));
        this.currentPos = 1L;
        this.con = clientConnection;
        this.clob = clientClob;
        this.updateCount = clientClob.getUpdateCount();
        this.length = -1L;
    }

    protected UpdateSensitiveClobLocatorReader(ClientConnection clientConnection, ClientClob clientClob, long l2, long l3) throws SqlException {
        clientClob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(clientConnection, clientClob, l2, l3));
        this.con = clientConnection;
        this.clob = clientClob;
        this.currentPos = l2;
        this.length = l3;
        this.updateCount = clientClob.getUpdateCount();
    }

    @Override
    public int read() throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n2 = this.r.read();
        if (n2 == -1) {
            return n2;
        }
        ++this.currentPos;
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n4 = this.r.read(cArray, n2, n3);
        if (n4 == -1) {
            return n4;
        }
        this.currentPos += (long)n4;
        return n4;
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }

    private void identifyAndReplaceObseleteStream() throws IOException {
        long l2 = this.clob.getUpdateCount();
        if (this.updateCount != l2) {
            try {
                this.r = new BufferedReader(this.reCreateStream());
            }
            catch (SqlException sqlException) {
                IOException iOException = new IOException();
                iOException.initCause(sqlException);
                throw iOException;
            }
        } else {
            return;
        }
        this.updateCount = l2;
    }

    private Reader reCreateStream() throws SqlException {
        ClobLocatorReader clobLocatorReader = null;
        clobLocatorReader = this.length != -1L ? new ClobLocatorReader(this.con, this.clob, this.currentPos, this.length - this.currentPos + 1L) : new ClobLocatorReader(this.con, this.clob, this.currentPos, -1L);
        return clobLocatorReader;
    }
}

