/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am.stmtcache;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.derby.client.am.stmtcache.StatementKey;

public final class JDBCStatementCache {
    private final LinkedHashMap<StatementKey, PreparedStatement> statements;

    public JDBCStatementCache(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("maxSize must be positive: " + n2);
        }
        this.statements = new BoundedLinkedHashMap(n2);
    }

    public synchronized PreparedStatement getCached(StatementKey statementKey) {
        return (PreparedStatement)this.statements.remove(statementKey);
    }

    public synchronized boolean cacheStatement(StatementKey statementKey, PreparedStatement preparedStatement) {
        boolean bl = this.statements.containsKey(statementKey);
        if (!bl) {
            this.statements.put(statementKey, preparedStatement);
        }
        return !bl;
    }

    private static class BoundedLinkedHashMap
    extends LinkedHashMap<StatementKey, PreparedStatement> {
        private final int maxSize;

        public BoundedLinkedHashMap(int n2) {
            this.maxSize = n2;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<StatementKey, PreparedStatement> entry) {
            boolean bl;
            boolean bl2 = bl = this.size() > this.maxSize;
            if (bl && entry != null) {
                try {
                    entry.getValue().close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return bl;
        }
    }
}

