/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.ConnectionReplyInterface;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.Reply;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.i18n.MessageUtil;

class NetConnectionReply
extends Reply
implements ConnectionReplyInterface {
    private static MessageUtil msgutil_ = SqlException.getMessageUtil();

    NetConnectionReply(NetAgent netAgent, int n2) {
        super(netAgent, n2);
    }

    void readExchangeServerAttributes(ClientConnection clientConnection) throws SqlException {
        this.startSameIdChainParse();
        this.parseEXCSATreply((NetConnection)clientConnection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readAccessSecurity(ClientConnection clientConnection, int n2) throws SqlException {
        this.startSameIdChainParse();
        this.parseACCSECreply((NetConnection)clientConnection, n2);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readSecurityCheck(ClientConnection clientConnection) throws SqlException {
        this.startSameIdChainParse();
        this.parseSECCHKreply((NetConnection)clientConnection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readAccessDatabase(ClientConnection clientConnection) throws SqlException {
        this.startSameIdChainParse();
        this.parseACCRDBreply((NetConnection)clientConnection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    @Override
    public void readCommitSubstitute(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseDummyEXCSATreply((NetConnection)connectionCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readLocalCommit(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseRDBCMMreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readLocalRollback(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseRDBRLLBCKreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readLocalXAStart(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    @Override
    public void readLocalXACommit(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    @Override
    public void readLocalXARollback(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    void readXaStartUnitOfWork(NetConnection netConnection) throws DisconnectException {
    }

    int readXaEndUnitOfWork(NetConnection netConnection) throws DisconnectException {
        return 0;
    }

    int readXaPrepare(NetConnection netConnection) throws DisconnectException {
        return 0;
    }

    void readXaCommit(NetConnection netConnection) throws DisconnectException {
    }

    int readXaRollback(NetConnection netConnection) throws DisconnectException {
        return 0;
    }

    void readXaRecover(NetConnection netConnection) throws DisconnectException {
    }

    void readXaForget(NetConnection netConnection) throws DisconnectException {
    }

    private void parseRDBCMMreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.parseTypdefsOrMgrlvlovrs();
        this.parseENDUOWRM(connectionCallbackInterface);
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        if (n2 == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            connectionCallbackInterface.completeSqlca(netSqlca);
        } else {
            this.parseCommitError(connectionCallbackInterface);
        }
    }

    private void parseRDBRLLBCKreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.parseTypdefsOrMgrlvlovrs();
        this.parseENDUOWRM(connectionCallbackInterface);
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        if (n2 == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            connectionCallbackInterface.completeSqlca(netSqlca);
        } else {
            this.parseRollbackError();
        }
    }

    private void parseEXCSATreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 5187) {
            this.parseExchangeServerAttributesError();
            return;
        }
        this.parseEXCSATRD(netConnection);
    }

    private void parseDummyEXCSATreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 5187) {
            this.parseExchangeServerAttributesError();
            return;
        }
        this.parseDummyEXCSATRD(netConnection);
    }

    private void parseACCSECreply(NetConnection netConnection, int n2) throws DisconnectException {
        int n3 = this.peekCodePoint();
        if (n3 != 5292) {
            this.parseAccessSecurityError(netConnection);
            return;
        }
        this.parseACCSECRD(netConnection, n2);
        this.netAgent_.exceptionConvertingRdbnam = null;
        n3 = this.peekCodePoint();
    }

    private void parseSECCHKreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 4633) {
            this.parseSecurityCheckError(netConnection);
            return;
        }
        this.parseSECCHKRM(netConnection);
        if (this.peekCodePoint() == 4572) {
            this.parseSECTKN(false);
        }
    }

    private void parseACCRDBreply(NetConnection netConnection) throws DisconnectException {
        int n2 = this.peekCodePoint();
        if (n2 != 8705) {
            this.parseAccessRdbError(netConnection);
            return;
        }
        this.parseACCRDBRM(netConnection);
        this.parseInitialPBSD(netConnection);
        n2 = this.peekCodePoint();
        if (n2 == -2) {
            return;
        }
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        netConnection.completeSqlca(netSqlca);
    }

    int parseTypdefsOrMgrlvlovrs() throws DisconnectException {
        int n2;
        boolean bl = false;
        while (true) {
            if ((n2 = this.peekCodePoint()) == 47) {
                if (!bl) {
                    this.netAgent_.targetTypdef_ = (Typdef)this.netAgent_.targetTypdef_.clone();
                    bl = true;
                }
                this.parseTYPDEFNAM();
                continue;
            }
            if (n2 != 53) break;
            if (!bl) {
                this.netAgent_.targetTypdef_ = (Typdef)this.netAgent_.targetTypdef_.clone();
                bl = true;
            }
            this.parseTYPDEFOVR();
        }
        return n2;
    }

    private void parseCommitError(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(connectionCallbackInterface, null);
                connectionCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseRollbackError() throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseExchangeServerAttributesError() throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4624: {
                this.parseMGRLVLRM();
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseAccessSecurityError(NetConnection netConnection) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseSecurityCheckError(NetConnection netConnection) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    private void parseAccessRdbError(NetConnection netConnection) throws DisconnectException {
        int n2 = this.peekCodePoint();
        switch (n2) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8711: {
                this.parseRDBACCRM();
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            case 8907: {
                this.parseRDBATHRM(netConnection);
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            default: {
                this.parseCommonError(n2);
            }
        }
    }

    void parseCommonError(int n2) throws DisconnectException {
        switch (n2) {
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 4677: {
                this.parsePRCCNVRM();
                break;
            }
            case 4684: {
                this.parseSYNTAXRM();
                break;
            }
            case 4690: {
                this.parseVALNSPRM();
                break;
            }
            default: {
                this.doObjnsprmSemantics(n2);
            }
        }
    }

    private NetSqlca parseAbnormalEndUow(ConnectionCallbackInterface connectionCallbackInterface, UnitOfWorkListener unitOfWorkListener) throws DisconnectException {
        NetSqlca netSqlca;
        this.parseABNUOWRM();
        if (this.peekCodePoint() != 9224) {
            this.parseTypdefsOrMgrlvlovrs();
        }
        if (ExceptionUtil.getSeverityFromIdentifier((netSqlca = this.parseSQLCARD(null)).getSqlState()) > 20000 || unitOfWorkListener == null) {
            connectionCallbackInterface.completeAbnormalUnitOfWork();
        } else {
            connectionCallbackInterface.completeAbnormalUnitOfWork(unitOfWorkListener);
        }
        return netSqlca;
    }

    NetSqlca parseAbnormalEndUow(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        return this.parseAbnormalEndUow(statementCallbackInterface.getConnectionCallbackInterface(), statementCallbackInterface);
    }

    NetSqlca parseAbnormalEndUow(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        return this.parseAbnormalEndUow(resultSetCallbackInterface.getConnectionCallbackInterface(), resultSetCallbackInterface);
    }

    private void parseRdbAccessFailed(NetConnection netConnection) throws DisconnectException {
        this.parseRDBAFLRM();
        if (this.peekCodePoint() == 47) {
            this.parseTYPDEFNAM();
            this.parseTYPDEFOVR();
        } else {
            this.parseTYPDEFOVR();
            this.parseTYPDEFNAM();
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        if (netSqlca.getSqlErrmc() == null) {
            netConnection.setConnectionNull(true);
        } else {
            netConnection.completeSqlca(netSqlca);
        }
    }

    private void parseSECCHKRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n3 = 0;
        boolean bl3 = false;
        byte[] byArray = null;
        this.parseLengthAndMatchCodePoint(4633);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl4 = false;
            if (n4 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SEVERE);
                n4 = this.peekCodePoint();
            }
            if (n4 == 4516) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n3 = this.parseSECCHKCD();
                n4 = this.peekCodePoint();
            }
            if (n4 == 4572) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                byArray = this.parseSECTKN(true);
                n4 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        netConnection.securityCheckComplete(n2, n3);
    }

    private void parseACCRDBRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        byte[] byArray = null;
        boolean bl7 = false;
        String string2 = null;
        this.parseLengthAndMatchCodePoint(8705);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl8 = false;
            if (n3 == 4425) {
                bl8 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_WARNING);
                n3 = this.peekCodePoint();
            }
            if (n3 == 4398) {
                bl8 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parsePRDID(false);
                n3 = this.peekCodePoint();
            }
            if (n3 == 47) {
                bl8 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                this.parseTYPDEFNAM();
                n3 = this.peekCodePoint();
            }
            if (n3 == 53) {
                bl8 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                this.parseTYPDEFOVR();
                n3 = this.peekCodePoint();
            }
            if (n3 == 4512) {
                bl8 = true;
                bl7 = this.checkAndGetReceivedFlag(bl7);
                string2 = this.parseUSRID(true);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8501) {
                bl8 = true;
                bl6 = this.checkAndGetReceivedFlag(bl6);
                byArray = this.parseCRRTKN(false);
                n3 = this.peekCodePoint();
            }
            if (bl8) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2, bl3, bl4);
        netConnection.rdbAccessed(n2, string, bl6, byArray);
    }

    void parseENDUOWRM(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n3 = 0;
        boolean bl3 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8716);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl4 = false;
            if (n4 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_WARNING);
                n4 = this.peekCodePoint();
            }
            if (n4 == 8469) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n3 = this.parseUOWDSP();
                n4 = this.peekCodePoint();
            }
            if (n4 == 8464) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string = this.parseRDBNAM(true);
                n4 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        if (n3 == 1) {
            connectionCallbackInterface.completeLocalCommit();
        } else {
            connectionCallbackInterface.completeLocalRollback();
        }
    }

    void parseCMDCHKRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(4692);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (n3 == 4444) {
                bl3 = true;
                this.parseLengthAndMatchCodePoint(4444);
                this.skipBytes();
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl);
        this.netAgent_.setSvrcod(n2);
        NetSqlca netSqlca = this.parseSQLCARD(null);
        this.netAgent_.netConnection_.completeSqlca(netSqlca);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Throwable)new SqlException(this.agent_.logWriter_, netSqlca), msgutil_.getTextMessage("J123", new Object[0])));
    }

    void parseRDBNACRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8708);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), msgutil_.getTextMessage("J122", new Object[0])));
    }

    private void parseRDBNFNRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8721);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08004.C.2"), netConnection.databaseName_));
    }

    private void parseRDBATHRM(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8907);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        this.netAgent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil_.getTextMessage("J121", new Object[0])));
    }

    private void parseSYNTAXRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n3 = 0;
        boolean bl3 = false;
        String string = null;
        boolean bl4 = false;
        int n4 = 0;
        this.parseLengthAndMatchCodePoint(4684);
        this.pushLengthOnCollectionStack();
        int n5 = this.peekCodePoint();
        while (n5 != -1) {
            boolean bl5 = false;
            if (n5 == 4425) {
                bl5 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n5 = this.peekCodePoint();
            }
            if (n5 == 4426) {
                bl5 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n3 = this.parseSYNERRCD();
                n5 = this.peekCodePoint();
            }
            if (n5 == 8464) {
                bl5 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string = this.parseRDBNAM(true);
                n5 = this.peekCodePoint();
            }
            if (n5 == 12) {
                bl5 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                n4 = this.parseCODPNT();
                n5 = this.peekCodePoint();
            }
            if (bl5) continue;
            this.doPrmnsprmSemantics(n5);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        this.doSyntaxrmSemantics(n4);
    }

    private void parseRDBACCRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8711);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), msgutil_.getTextMessage("J124", new Object[0])));
    }

    private void parseRDBAFLRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8730);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
    }

    private void parseVALNSPRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        int n3 = 0;
        this.parseLengthAndMatchCodePoint(4690);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl4 = false;
            if (n4 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n4 = this.peekCodePoint();
            }
            if (n4 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n4 = this.peekCodePoint();
            }
            if (n4 == 12) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n3 = this.parseCODPNT();
                n4 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl3);
        this.netAgent_.setSvrcod(n2);
        this.doValnsprmSemantics(n3, "\"\"");
    }

    private void parsePRCCNVRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        int n3 = 0;
        this.parseLengthAndMatchCodePoint(4677);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl4 = false;
            if (n4 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SESDMG);
                n4 = this.peekCodePoint();
            }
            if (n4 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n4 = this.peekCodePoint();
            }
            if (n4 == 4415) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n3 = this.parsePRCCNVCD();
                n4 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl3);
        this.netAgent_.setSvrcod(n2);
        this.doPrccnvrmSemantics(4677);
    }

    void parseOBJNSPRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        int n3 = 0;
        this.parseLengthAndMatchCodePoint(4691);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl4 = false;
            if (n4 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SEVERE);
                n4 = this.peekCodePoint();
            }
            if (n4 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n4 = this.peekCodePoint();
            }
            if (n4 == 12) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n3 = this.parseCODPNT();
                n4 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl3);
        this.netAgent_.setSvrcod(n2);
        this.doObjnsprmSemantics(n3);
    }

    private void parseMGRLVLRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int[] nArray = null;
        int[] nArray2 = null;
        this.parseLengthAndMatchCodePoint(4624);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 5124) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                this.parseLengthAndMatchCodePoint(5124);
                int n4 = this.getDdmLength();
                if (n4 == 0 || n4 % 7 != 0) {
                    this.doSyntaxrmSemantics(CodePoint.SYNERRCD_OBJ_LEN_NOT_ALLOWED);
                }
                int n5 = n4 / 7;
                nArray = new int[n5];
                nArray2 = new int[n5];
                for (int i2 = 0; i2 < n5; ++i2) {
                    nArray[i2] = this.parseCODPNTDR();
                    nArray2[i2] = this.parseMGRLVLN();
                }
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
        this.doMgrlvlrmSemantics(nArray, nArray2);
    }

    void parseCMDNSPRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        int n3 = 0;
        this.parseLengthAndMatchCodePoint(4688);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl4 = false;
            if (n4 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                n4 = this.peekCodePoint();
            }
            if (n4 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n4 = this.peekCodePoint();
            }
            if (n4 == 12) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n3 = this.parseCODPNT();
                n4 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl3);
        this.netAgent_.setSvrcod(n2);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58014.C"), Integer.toHexString(n3)));
    }

    private void parseABNUOWRM() throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        this.parseLengthAndMatchCodePoint(8717);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl3 = false;
            if (n3 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                String string = this.parseRDBNAM(true);
                n3 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n2);
    }

    private void parseEXCSATRD(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        boolean bl4 = false;
        boolean bl5 = false;
        String string2 = null;
        this.parseLengthAndMatchCodePoint(5187);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl6 = false;
            if (n2 == 4446) {
                bl6 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                String string3 = this.parseEXTNAM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 5124) {
                bl6 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                this.parseMGRLVLLS(netConnection);
                n2 = this.peekCodePoint();
            }
            if (n2 == 4423) {
                bl6 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string = this.parseSRVCLSNM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 4461) {
                bl6 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                this.parseSRVNAM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 4442) {
                bl6 = true;
                bl5 = this.checkAndGetReceivedFlag(bl5);
                string2 = this.parseSRVRLSLV();
                n2 = this.peekCodePoint();
            }
            if (bl6) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        netConnection.setServerAttributeData(string, string2);
    }

    private void parseDummyEXCSATRD(NetConnection netConnection) throws DisconnectException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        boolean bl4 = false;
        String string2 = null;
        boolean bl5 = false;
        String string3 = null;
        this.parseLengthAndMatchCodePoint(5187);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl6 = false;
            if (n2 == 4446) {
                bl6 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                String string4 = this.parseEXTNAM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 5124) {
                bl6 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                this.parseMGRLVLLS(netConnection);
                n2 = this.peekCodePoint();
            }
            if (n2 == 4423) {
                bl6 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                string = this.parseSRVCLSNM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 4461) {
                bl6 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                string2 = this.parseSRVNAM();
                n2 = this.peekCodePoint();
            }
            if (n2 == 4442) {
                bl6 = true;
                bl5 = this.checkAndGetReceivedFlag(bl5);
                string3 = this.parseSRVRLSLV();
                n2 = this.peekCodePoint();
            }
            if (bl6) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
    }

    private void parseACCSECRD(NetConnection netConnection, int n2) throws DisconnectException {
        boolean bl = false;
        int[] nArray = null;
        boolean bl2 = false;
        byte[] byArray = null;
        boolean bl3 = false;
        int n3 = 0;
        this.parseLengthAndMatchCodePoint(5292);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl4 = false;
            if (n4 == 4514) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                nArray = this.parseSECMEC();
                n4 = this.peekCodePoint();
            }
            if (n4 == 4572) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                byArray = this.parseSECTKN(false);
                n4 = this.peekCodePoint();
            }
            if (n4 == 4516) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n3 = this.parseSECCHKCD();
                n4 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl);
        netConnection.setAccessSecurityData(n3, n2, nArray, bl2, byArray);
        if (netConnection.serverSupportsUtf8Ccsid()) {
            netConnection.netAgent_.switchToUtf8CcsidMgr();
        } else {
            netConnection.netAgent_.switchToEbcdicMgr();
        }
    }

    private void parseTYPDEFNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(47);
        this.netAgent_.targetTypdef_.setTypdefnam(this.readString());
    }

    private void parseTYPDEFOVR() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(53);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl = false;
            if (n2 == 4508) {
                bl = true;
                this.netAgent_.targetTypdef_.setCcsidSbc(this.parseCCSIDSBC());
                n2 = this.peekCodePoint();
            }
            if (n2 == 4509) {
                bl = true;
                this.netAgent_.targetTypdef_.setCcsidDbc(this.parseCCSIDDBC());
                n2 = this.peekCodePoint();
            }
            if (n2 == 4510) {
                bl = true;
                this.netAgent_.targetTypdef_.setCcsidMbc(this.parseCCSIDMBC());
                n2 = this.peekCodePoint();
            }
            if (bl) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
    }

    int parseSYNCCRD(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        return 0;
    }

    int parseXARETVAL() throws DisconnectException {
        return 0;
    }

    byte parseSYNCTYPE() throws DisconnectException {
        return 0;
    }

    int parseSYNCCTLreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        if (this.peekCodePoint() == 49152) {
            this.parsePBSD();
        }
        return 0;
    }

    void parseSYNCCTLError(int n2) throws DisconnectException {
        switch (n2) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4677: {
                this.parsePRCCNVRM();
                break;
            }
            case 4684: {
                this.parseSYNTAXRM();
                break;
            }
            case 4690: {
                this.parseVALNSPRM();
                break;
            }
            default: {
                this.doObjnsprmSemantics(n2);
            }
        }
    }

    private void parseMGRLVLLS(NetConnection netConnection) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(5124);
        int n2 = this.getDdmLength();
        if (n2 == 0 || n2 % 4 != 0) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_OBJ_LEN_NOT_ALLOWED);
        }
        int n3 = n2 / 4;
        block12: for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.parseCODPNTDR();
            int n5 = this.parseMGRLVLN();
            switch (n4) {
                case 5123: {
                    if (n5 < 3 || n5 > netConnection.targetAgent_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetAgent_ = n5;
                    continue block12;
                }
                case 5236: {
                    if (n5 < 5 || n5 > netConnection.targetCmntcpip_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetCmntcpip_ = n5;
                    continue block12;
                }
                case 9231: {
                    if (n5 < 3 || n5 > netConnection.targetRdb_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetRdb_ = n5;
                    continue block12;
                }
                case 5184: {
                    if (n5 < 5 || n5 > netConnection.targetSecmgr_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetSecmgr_ = n5;
                    continue block12;
                }
                case 9223: {
                    if (n5 < 4 || n5 > this.netAgent_.targetSqlam_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    this.netAgent_.orignalTargetSqlam_ = n5;
                    continue block12;
                }
                case 5188: {
                    if (n5 < 3 || n5 > netConnection.targetCmnappc_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetCmnappc_ = n5;
                    continue block12;
                }
                case 7169: {
                    if (n5 != 0 && n5 < 7 || n5 > netConnection.targetXamgr_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetXamgr_ = n5;
                    continue block12;
                }
                case 5312: {
                    if (n5 != 0 && n5 < 5 || n5 > netConnection.targetSyncptmgr_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetSyncptmgr_ = n5;
                    continue block12;
                }
                case 7176: {
                    if (n5 < 0 || n5 > netConnection.targetUnicodemgr_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetUnicodemgr_ = n5;
                    continue block12;
                }
                case 5313: {
                    if (n5 != 0 && n5 < 5 || n5 > netConnection.targetRsyncmgr_) {
                        this.doMgrlvlrmSemantics(n4, n5);
                    }
                    netConnection.targetRsyncmgr_ = n5;
                    continue block12;
                }
                default: {
                    this.doMgrlvlrmSemantics(n4, n5);
                }
            }
        }
    }

    private String parseEXTNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4446);
        return this.readString();
    }

    private String parseSRVCLSNM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4423);
        return this.readString();
    }

    private String parseSRVNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4461);
        return this.readString();
    }

    private String parseSRVRLSLV() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4442);
        return this.readString();
    }

    private int parseMGRLVLN() throws DisconnectException {
        return this.readUnsignedShort();
    }

    private int[] parseSECMEC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4514);
        return this.readUnsignedShortList();
    }

    private byte[] parseSECTKN(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4572);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    private int parseSECCHKCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4516);
        int n2 = this.readUnsignedByte();
        if (n2 < 0 || n2 > 21) {
            this.doValnsprmSemantics(4516, n2);
        }
        return n2;
    }

    private String parsePRDID(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4398);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    private String parseUSRID(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4512);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    private int parseCODPNTDR() throws DisconnectException {
        return this.readUnsignedShort();
    }

    private byte[] parseCRRTKN(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8501);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    private int parseUOWDSP() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8469);
        int n2 = this.readUnsignedByte();
        if (n2 != 1 && n2 != 2) {
            this.doValnsprmSemantics(8469, n2);
        }
        return n2;
    }

    String parseRDBNAM(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8464);
        if (bl) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    Xid parseXID() throws DisconnectException {
        return null;
    }

    List<Xid> parseIndoubtList() throws DisconnectException {
        return null;
    }

    private int parseSYNERRCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4426);
        int n2 = this.readUnsignedByte();
        if (n2 < 1 || n2 > 29) {
            this.doValnsprmSemantics(4426, n2);
        }
        return n2;
    }

    private int parseCODPNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(12);
        return this.parseCODPNTDR();
    }

    private int parsePRCCNVCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4415);
        int n2 = this.readUnsignedByte();
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 16 && n2 != 17 && n2 != 18 && n2 != 19 && n2 != 21) {
            this.doValnsprmSemantics(4415, n2);
        }
        return n2;
    }

    private int parseCCSIDSBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4508);
        return this.readUnsignedShort();
    }

    private int parseCCSIDMBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4510);
        return this.readUnsignedShort();
    }

    private int parseCCSIDDBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4509);
        return this.readUnsignedShort();
    }

    int parseSVRCOD(int n2, int n3) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4425);
        int n4 = this.readUnsignedShort();
        if (n4 != CodePoint.SVRCOD_INFO && n4 != CodePoint.SVRCOD_WARNING && n4 != CodePoint.SVRCOD_ERROR && n4 != CodePoint.SVRCOD_SEVERE && n4 != CodePoint.SVRCOD_ACCDMG && n4 != CodePoint.SVRCOD_PRMDMG && n4 != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, n4);
        }
        if (n4 < n2 || n4 > n3) {
            this.doValnsprmSemantics(4425, n4);
        }
        return n4;
    }

    int parseFastSVRCOD(int n2, int n3) throws DisconnectException {
        this.matchCodePoint(4425);
        int n4 = this.readFastUnsignedShort();
        if (n4 != CodePoint.SVRCOD_INFO && n4 != CodePoint.SVRCOD_WARNING && n4 != CodePoint.SVRCOD_ERROR && n4 != CodePoint.SVRCOD_SEVERE && n4 != CodePoint.SVRCOD_ACCDMG && n4 != CodePoint.SVRCOD_PRMDMG && n4 != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, n4);
        }
        if (n4 < n2 || n4 > n3) {
            this.doValnsprmSemantics(4425, n4);
        }
        return n4;
    }

    NetSqlca parseSQLCARD(Sqlca[] sqlcaArray) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9224);
        int n2 = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n2);
        NetSqlca netSqlca = this.parseSQLCARDrow(sqlcaArray);
        this.adjustLengths(this.getDdmLength());
        return netSqlca;
    }

    NetSqlca parseSQLCARDrow(Sqlca[] sqlcaArray) throws DisconnectException {
        return this.parseSQLCAGRP(sqlcaArray);
    }

    int parseSQLNUMROW() throws DisconnectException {
        return this.parseSQLNUMGRP();
    }

    int parseFastSQLNUMROW() throws DisconnectException {
        return this.parseFastSQLNUMGRP();
    }

    private int parseSQLNUMGRP() throws DisconnectException {
        return this.readShort();
    }

    private int parseFastSQLNUMGRP() throws DisconnectException {
        return this.readFastShort();
    }

    private NetSqlca parseSQLCAGRP(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return null;
        }
        int n2 = this.readFastInt();
        byte[] byArray = this.readFastBytes(5);
        byte[] byArray2 = this.readFastBytes(8);
        NetSqlca netSqlca = null;
        try {
            netSqlca = new NetSqlca((ClientConnection)this.netAgent_.netConnection_, n2, byArray, byArray2);
            this.parseSQLCAXGRP(netSqlca);
            if (this.netAgent_.targetSqlam_ >= 7) {
                netSqlca.setRowsetRowCount(this.parseSQLDIAGGRP(sqlcaArray));
            }
        }
        catch (SqlException sqlException) {
            throw new DisconnectException(this.netAgent_, sqlException);
        }
        return netSqlca;
    }

    private void parseSQLCAXGRP(NetSqlca netSqlca) throws DisconnectException {
        byte[] byArray;
        if (this.readFastUnsignedByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        if (this.netAgent_.targetSqlam_ < 7) {
            this.skipFastBytes(18);
        }
        int[] nArray = new int[6];
        this.readFastIntArray(nArray);
        byte[] byArray2 = this.readFastBytes(11);
        if (this.netAgent_.targetSqlam_ >= 7) {
            this.parseFastVCS();
        }
        if ((byArray = this.readFastLDBytes()) != null) {
            int n2 = this.netAgent_.targetTypdef_.getCcsidMbc();
            this.skipFastBytes(2);
        } else {
            byArray = this.readFastLDBytes();
            int n3 = this.netAgent_.targetTypdef_.getCcsidSbc();
        }
        netSqlca.setSqlerrd(nArray);
        netSqlca.setSqlwarnBytes(byArray2);
        netSqlca.setSqlerrmcBytes(byArray);
    }

    private long parseSQLDIAGGRP(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        long l2 = this.parseSQLDIAGSTT(sqlcaArray);
        this.parseSQLDIAGCI(sqlcaArray);
        this.parseSQLDIAGCN();
        return l2;
    }

    String parseFastVCS() throws DisconnectException {
        return this.readFastString(this.readFastUnsignedShort(), this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
    }

    boolean checkAndGetReceivedFlag(boolean bl) throws DisconnectException {
        if (bl) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DUP_OBJ_PRESENT);
        }
        return true;
    }

    void checkRequiredObjects(boolean bl) throws DisconnectException {
        if (!bl) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    void checkRequiredObjects(boolean bl, boolean bl2) throws DisconnectException {
        if (!bl || !bl2) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    void checkRequiredObjects(boolean bl, boolean bl2, boolean bl3) throws DisconnectException {
        if (!(bl && bl2 && bl3)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    private void checkRequiredObjects(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws DisconnectException {
        if (!(bl && bl2 && bl3 && bl4)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    private void doObjnsprmSemantics(int n2) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58015.C"), Integer.toHexString(n2)));
    }

    void doPrmnsprmSemantics(int n2) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58016.C"), Integer.toHexString(n2)));
    }

    void doValnsprmSemantics(int n2, int n3) throws DisconnectException {
        this.doValnsprmSemantics(n2, Integer.toString(n3));
    }

    private void doValnsprmSemantics(int n2, String string) throws DisconnectException {
        if (n2 == 5242) {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("58017.C"), Integer.toHexString(n2)));
            return;
        }
        if (n2 == 4508 || n2 == 4509 || n2 == 4510) {
            int n3 = 0;
            switch (n2) {
                case 4508: {
                    n3 = this.netAgent_.typdef_.getCcsidSbc();
                    break;
                }
                case 4509: {
                    n3 = this.netAgent_.typdef_.getCcsidDbc();
                    break;
                }
                case 4510: {
                    n3 = this.netAgent_.typdef_.getCcsidSbc();
                    break;
                }
            }
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("57017.C"), n3, string));
            return;
        }
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58017.C"), Integer.toHexString(n2)));
    }

    void doDtamchrmSemantics() throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), msgutil_.getTextMessage("J125", new Object[0])));
    }

    private void doMgrlvlrmSemantics(String string, String string2) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58010.C"), string, string2));
    }

    private void doMgrlvlrmSemantics(int n2, int n3) throws DisconnectException {
        this.doMgrlvlrmSemantics("0x" + Integer.toHexString(n2), "0x" + Integer.toHexString(n3));
    }

    private void doMgrlvlrmSemantics(int[] nArray, int[] nArray2) throws DisconnectException {
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(100);
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("0x");
            stringBuilder.append(nArray[i2]);
            stringBuilder2.append("0x");
            stringBuilder2.append(nArray2[i2]);
            if (i2 == n2 - 1) continue;
            stringBuilder.append(",");
            stringBuilder2.append(",");
        }
        this.doMgrlvlrmSemantics(stringBuilder.toString(), stringBuilder2.toString());
    }

    private void doPrccnvrmSemantics(int n2) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), msgutil_.getTextMessage("J126", Integer.toHexString(n2))));
    }

    private void parseSQLDCTOKS() throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int n2 = this.parseFastSQLNUMROW();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parseSQLTOKROW();
        }
    }

    private void parseSQLDIAGCI(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int n2 = this.parseFastSQLNUMROW();
        if (n2 == 0) {
            this.resetRowsetSqlca(sqlcaArray, 0);
        }
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = this.parseSQLDCROW(sqlcaArray, n3);
        }
        this.resetRowsetSqlca(sqlcaArray, n3 + 1);
    }

    private void parseSQLDIAGCN() throws DisconnectException {
        if (this.readUnsignedByte() == 255) {
            return;
        }
        int n2 = this.parseFastSQLNUMROW();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parseSQLCNROW();
        }
    }

    private void parseSQLCNROW() throws DisconnectException {
        this.parseSQLCNGRP();
    }

    private int parseSQLDCROW(Sqlca[] sqlcaArray, int n2) throws DisconnectException {
        return this.parseSQLDCGRP(sqlcaArray, n2);
    }

    private void parseSQLTOKROW() throws DisconnectException {
        this.parseSQLTOKGRP();
    }

    private void parseSQLTOKGRP() throws DisconnectException {
        this.skipFastNVCMorNVCS();
    }

    private long parseSQLDIAGSTT(Sqlca[] sqlcaArray) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        int n2 = this.readFastInt();
        int n3 = this.readFastInt();
        int n4 = this.readFastInt();
        this.skipFastBytes(16);
        long l2 = this.readFastLong();
        this.skipFastBytes(24);
        return l2;
    }

    private void parseSQLCNGRP() throws DisconnectException {
        this.skipBytes(18);
        String string = this.parseFastVCS();
        String string2 = this.parseFastVCS();
        String string3 = this.parseFastVCS();
    }

    private int parseSQLDCGRP(Sqlca[] sqlcaArray, int n2) throws DisconnectException {
        int n3 = this.readFastInt();
        String string = this.readFastString(5, Typdef.UTF8ENCODING);
        int n4 = this.readFastInt();
        int n5 = this.readFastInt();
        int n6 = (int)this.readFastLong();
        if (n3 == 20237) {
            sqlcaArray[0] = new NetSqlca((ClientConnection)this.netAgent_.netConnection_, n3, string, null);
        } else if (sqlcaArray[n6] != null) {
            sqlcaArray[n6].resetRowsetSqlca(this.netAgent_.netConnection_, n3, string);
        } else {
            sqlcaArray[n6] = new NetSqlca((ClientConnection)this.netAgent_.netConnection_, n3, string, null);
        }
        for (int i2 = n2 + 1; i2 < n6; ++i2) {
            sqlcaArray[i2] = null;
        }
        this.skipFastBytes(47);
        String string2 = this.parseFastVCS();
        this.parseSQLDCTOKS();
        String string3 = this.parseFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseSQLDCXGRP();
        return n6;
    }

    private void parseSQLDCXGRP() throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        String string = this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
    }

    private String parseFastNVCMorNVCS() throws DisconnectException {
        int n2;
        String string = null;
        if (this.readFastUnsignedByte() != 255) {
            int n3 = this.readFastUnsignedShort();
            if (n3 > 0) {
                string = this.readFastString(n3, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            }
            if (this.readFastUnsignedByte() != 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.20"), new Object[0]));
            }
        } else if (this.readFastUnsignedByte() != 255 && (n2 = this.readFastUnsignedShort()) > 0) {
            string = this.readFastString(n2, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return string;
    }

    private void skipFastNVCMorNVCS() throws DisconnectException {
        int n2;
        if (this.readFastUnsignedByte() != 255) {
            int n3 = this.readFastUnsignedShort();
            if (n3 > 0) {
                this.skipFastBytes(n3);
            }
            if (this.readFastUnsignedByte() != 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.20"), new Object[0]));
            }
        } else if (this.readFastUnsignedByte() != 255 && (n2 = this.readFastUnsignedShort()) > 0) {
            this.skipFastBytes(n2);
        }
    }

    private void resetRowsetSqlca(Sqlca[] sqlcaArray, int n2) {
        int n3 = sqlcaArray == null ? 0 : sqlcaArray.length;
        for (int i2 = n2; i2 < n3; ++i2) {
            sqlcaArray[i2] = null;
        }
    }

    private void parseInitialPBSD(ClientConnection clientConnection) throws DisconnectException {
        if (this.peekCodePoint() != 49152) {
            return;
        }
        this.parseLengthAndMatchCodePoint(49152);
        int n2 = this.peekCodePoint();
        while (n2 != -2) {
            this.parseLengthAndMatchCodePoint(n2);
            switch (n2) {
                case 49153: {
                    this.netAgent_.netConnection_.completeInitialPiggyBackIsolation(this.readUnsignedByte());
                    break;
                }
                case 49154: {
                    this.netAgent_.netConnection_.completeInitialPiggyBackSchema(this.readString(this.getDdmLength(), Typdef.UTF8ENCODING));
                    break;
                }
                default: {
                    this.parseCommonError(n2);
                }
            }
            n2 = this.peekCodePoint();
        }
    }

    void parsePBSD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(49152);
        int n2 = this.peekCodePoint();
        while (n2 != -2) {
            this.parseLengthAndMatchCodePoint(n2);
            switch (n2) {
                case 49153: {
                    this.netAgent_.netConnection_.completePiggyBackIsolation(this.readUnsignedByte());
                    break;
                }
                case 49154: {
                    this.netAgent_.netConnection_.completePiggyBackSchema(this.readString(this.getDdmLength(), Typdef.UTF8ENCODING));
                    break;
                }
                default: {
                    this.parseCommonError(n2);
                }
            }
            n2 = this.peekCodePoint();
        }
    }
}

