/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.PrintWriter;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.net.CodePointNameTable;
import org.apache.derby.client.net.NetConnection;

public class NetLogWriter
extends LogWriter {
    static final int TYPE_TRACE_RECEIVE = 2;
    static final int TYPE_TRACE_SEND = 1;
    private static final char[] asciiChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static final String colPosHeader__ = "       0 1 2 3 4 5 6 7   8 9 A B C D E F   0123456789ABCDEF  0123456789ABCDEF";
    private static final char[] ebcdicChar__ = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '|', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '`', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '.', '.', '.', '.', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '.', '.', '.', '.', '.', '.', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '\\', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};
    private static final char[] hexDigit__ = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String receiveHeader__ = "       RECEIVE BUFFER:                     (ASCII)           (EBCDIC)";
    private static final String sendHeader__ = "       SEND BUFFER:                        (ASCII)           (EBCDIC)";
    private static final char spaceChar__ = ' ';
    private static final char zeroChar__ = '0';
    private static CodePointNameTable codePointNameTable__ = null;

    public NetLogWriter(PrintWriter printWriter, int n2) {
        super(printWriter, n2);
        if (codePointNameTable__ == null) {
            this.initCodePointTable();
        }
    }

    private synchronized void initCodePointTable() {
        if (codePointNameTable__ == null) {
            codePointNameTable__ = new CodePointNameTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traceConnectsExit(ClientConnection clientConnection) {
        NetConnection netConnection = (NetConnection)clientConnection;
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            super.traceConnectsExit(netConnection);
            this.dncnetprint("  PROTOCOL manager levels: { ");
            this.printWriter_.print("SQLAM=" + netConnection.getSQLAM() + ", ");
            this.printWriter_.print("AGENT=" + netConnection.getAGENT() + ", ");
            this.printWriter_.print("CMNTCPIP=" + netConnection.getCMNTCPIP() + ", ");
            this.printWriter_.print("RDB=" + netConnection.getRDB() + ", ");
            this.printWriter_.print("SECMGR=" + netConnection.getSECMGR() + ", ");
            this.printWriter_.print("XAMGR=" + netConnection.getXAMGR() + ", ");
            this.printWriter_.print("SYNCPTMGR=" + netConnection.getSYNCPTMGR() + ", ");
            this.printWriter_.print("RSYNCMGR=" + netConnection.getRSYNCMGR());
            this.printWriter_.println(" }");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traceConnectsResetExit(ClientConnection clientConnection) {
        NetConnection netConnection = (NetConnection)clientConnection;
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            super.traceConnectsResetExit(netConnection);
            this.dncnetprint("  PROTOCOL manager levels: { ");
            this.printWriter_.print("SQLAM=" + netConnection.getSQLAM() + ", ");
            this.printWriter_.print("AGENT=" + netConnection.getAGENT() + ", ");
            this.printWriter_.print("CMNTCPIP=" + netConnection.getCMNTCPIP() + ", ");
            this.printWriter_.print("RDB=" + netConnection.getRDB() + ", ");
            this.printWriter_.print("SECMGR=" + netConnection.getSECMGR() + ", ");
            this.printWriter_.print("XAMGR=" + netConnection.getXAMGR() + ", ");
            this.printWriter_.print("SYNCPTMGR=" + netConnection.getSYNCPTMGR() + ", ");
            this.printWriter_.print("RSYNCMGR=" + netConnection.getRSYNCMGR());
            this.printWriter_.println(" }");
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void traceProtocolFlow(byte[] byArray, int n2, int n3, int n4, String string, String string2, int n5) {
        if (!this.loggingEnabled(64)) {
            return;
        }
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.tracepoint("[net]", n5, string, string2);
            int n6 = n3;
            boolean bl = true;
            while (n6 >= 2) {
                int n7;
                int n8;
                n3 = ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
                if (n3 < 10 || n3 > n6) {
                    n3 = n6;
                }
                n6 -= n3;
                if (n3 == 0) continue;
                String string3 = null;
                if (n3 >= 10 && (string3 = codePointNameTable__.lookup(n8 = NetLogWriter.getCodePoint(byArray, n2 + 8))) == null) {
                    n3 += n6;
                    n6 = 0;
                }
                if (!bl) {
                    this.dncnetprintln("");
                }
                if (string3 == null) {
                    this.dncnetprintln(NetLogWriter.getHeader(n4));
                } else {
                    this.printHeaderWithCodePointName(string3, n4);
                }
                if (bl) {
                    this.dncnetprintln(colPosHeader__);
                    bl = false;
                }
                char[] cArray = new char[77];
                int n9 = 7;
                int n10 = 43;
                int n11 = 61;
                cArray[0] = 48;
                cArray[1] = 48;
                cArray[2] = 48;
                cArray[3] = 48;
                int n12 = 16;
                for (n7 = 4; n7 < 77; ++n7) {
                    cArray[n7] = 32;
                }
                n7 = 0;
                do {
                    int n13 = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
                    ++n2;
                    ++n7;
                    int n14 = n9;
                    n9 = (short)(n9 + 1);
                    cArray[n14] = hexDigit__[n13 >>> 4 & 0xF];
                    int n15 = n9;
                    n9 = (short)(n9 + 1);
                    cArray[n15] = hexDigit__[n13 & 0xF];
                    int n16 = n10;
                    n10 = (short)(n10 + 1);
                    cArray[n16] = asciiChar__[n13];
                    int n17 = n11;
                    n11 = (short)(n11 + 1);
                    cArray[n17] = ebcdicChar__[n13];
                    if (n7 % 8 != 0) continue;
                    if (n7 % 16 == 0) {
                        this.dncnetprintln(cArray);
                        if (n7 == n3) continue;
                        if (n3 - n7 < 16) {
                            for (int i2 = 0; i2 < cArray.length; ++i2) {
                                cArray[i2] = 32;
                            }
                        }
                        n9 = 0;
                        n10 = 43;
                        n11 = 61;
                        if (n12 == 0x100000) {
                            n12 = 0;
                        }
                        int n18 = n9;
                        n9 = (short)(n9 + 1);
                        cArray[n18] = hexDigit__[n12 >>> 12 & 0xF];
                        int n19 = n9;
                        n9 = (short)(n9 + 1);
                        cArray[n19] = hexDigit__[n12 >>> 8 & 0xF];
                        int n20 = n9;
                        n9 = (short)(n9 + 1);
                        cArray[n20] = hexDigit__[n12 >>> 4 & 0xF];
                        int n21 = n9;
                        n9 = (short)(n9 + 1);
                        cArray[n21] = hexDigit__[n12 & 0xF];
                        n9 = (short)(n9 + 3);
                        n12 += 16;
                        continue;
                    }
                    n9 = (short)(n9 + 2);
                } while (n7 < n3);
                if (n3 % 16 == 0) continue;
                this.dncnetprintln(cArray);
            }
            this.dncnetprintln("");
        }
    }

    private static int getCodePoint(byte[] byArray, int n2) {
        return ((byArray[n2++] & 0xFF) << 8) + (byArray[n2] & 0xFF);
    }

    private static String getHeader(int n2) {
        switch (n2) {
            case 1: {
                return sendHeader__;
            }
            case 2: {
                return receiveHeader__;
            }
        }
        return null;
    }

    private static int getStartPosition(int n2) {
        switch (n2) {
            case 1: {
                return 20;
            }
            case 2: {
                return 23;
            }
        }
        return 0;
    }

    private void printHeaderWithCodePointName(String string, int n2) {
        char[] cArray = NetLogWriter.getHeader(n2).toCharArray();
        int n3 = string.length() < 17 ? string.length() : 16;
        int n4 = NetLogWriter.getStartPosition(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[n4++] = string.charAt(i2);
        }
        this.dncnetprintln(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprint(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprintln(String string) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.println("[derby] " + string);
            this.printWriter_.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dncnetprintln(char[] cArray) {
        PrintWriter printWriter = this.printWriter_;
        synchronized (printWriter) {
            this.printWriter_.print("[derby] ");
            this.printWriter_.println(cArray);
            this.printWriter_.flush();
        }
    }
}

