/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.TableNameInfo;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class LockTable
extends VTITemplate
implements VTICosting {
    public static final int LATCH = 1;
    public static final int TABLE_AND_ROWLOCK = 2;
    public static final int ALL = -1;
    private TransactionController tc;
    private Hashtable currentRow;
    private Enumeration lockTable;
    private boolean wasNull;
    private boolean initialized;
    private final int flag;
    private TableNameInfo tabInfo;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("MODE", 12, false, 4), EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("LOCKNAME", 12, false, 20), EmbedResultSetMetaData.getResultColumnDescriptor("STATE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("TABLETYPE", 12, false, 9), EmbedResultSetMetaData.getResultColumnDescriptor("LOCKCOUNT", 12, false, 5), EmbedResultSetMetaData.getResultColumnDescriptor("INDEXNAME", 12, true, 128)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public LockTable() {
        this.flag = 2;
    }

    public LockTable(int n2) {
        this.flag = n2;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
                this.tc = languageConnectionContext.getTransactionExecute();
                LockFactory lockFactory = this.tc.getAccessManager().getLockFactory();
                this.lockTable = lockFactory.makeVirtualLockTable();
                this.initialized = true;
                this.tabInfo = new TableNameInfo(languageConnectionContext, true);
            }
            this.currentRow = null;
            if (this.lockTable != null) {
                while (this.lockTable.hasMoreElements() && this.currentRow == null) {
                    this.currentRow = this.dumpLock((Latch)this.lockTable.nextElement());
                }
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        return this.currentRow != null;
    }

    @Override
    public void close() {
        this.lockTable = null;
    }

    @Override
    public String getString(int n2) {
        String string = (String)this.currentRow.get(columnInfo[n2 - 1].getName());
        this.wasNull = string == null;
        return string;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) {
        return false;
    }

    private Hashtable<String, Object> dumpLock(Latch latch) throws StandardException {
        Object object;
        String string;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(17);
        Object object2 = latch.getQualifier();
        Lockable lockable = latch.getLockable();
        if (!lockable.lockAttributes(this.flag, hashtable)) {
            return null;
        }
        if (hashtable.get("LOCKNAME") == null || hashtable.get("TYPE") == null) {
            return null;
        }
        int n2 = latch.getCount();
        if (n2 != 0) {
            string = "GRANT";
        } else {
            if (!(latch instanceof ActiveLock)) {
                return null;
            }
            string = "WAIT";
        }
        Long l2 = (Long)hashtable.get("CONGLOMID");
        if (l2 == null) {
            if (hashtable.get("CONTAINERID") == null) {
                return null;
            }
            object = (Long)hashtable.get("CONTAINERID");
            l2 = this.tc.findConglomid((Long)object);
            hashtable.put("CONGLOMID", l2);
        }
        hashtable.put("LOCKOBJ", latch);
        object = latch.getCompatabilitySpace().getOwner();
        hashtable.put("XID", object == null ? "<null>" : object.toString());
        hashtable.put("MODE", object2.toString());
        hashtable.put("LOCKCOUNT", Integer.toString(n2));
        hashtable.put("STATE", string);
        String string2 = this.tabInfo.getTableName(l2);
        hashtable.put("TABLENAME", string2);
        String string3 = this.tabInfo.getIndexName(l2);
        if (string3 != null) {
            hashtable.put("INDEXNAME", string3);
        }
        String string4 = this.tabInfo.getTableType(l2);
        hashtable.put("TABLETYPE", string4);
        return hashtable;
    }
}

